//#pragma rtGlobals=1		// Use modern global access method.
#include <Remove Points>
////********************************************************************************f
////ITIR-FCCS Control.ipf	(mm/dd/yyyy)
////						Ver 1.0 Build 09/07/2009 by Thorsten Wohland
////						Ver 2.0 Build 4 Dec 2009 by Jagadish Sankaran
////                                       Ver 2.1 Commented 30 Mar 2013 Jagadish Sankaran
////********************************************************************************
////F 
////     
////     
////********************************************************************************
//
//
////********************************************************************************
////  New menu item in Analysis menu
////********************************************************************************
//
Menu "Analysis"
	"ImFCS", ITIRFCCSInitVariables_new();ITIRFCCSShowMainControl_new() 
	
End
//
////********************************************************************************
////  Initiating Function for variable definition and windows control
////********************************************************************************
//
Function ITIRFCCSInitVariables_new()					//Initiate Global variables
	String dfSave=GetDataFolder(1)
	Variable cbB, cbR
	NewDataFolder/O/S root:ITIRFCCS				//The data folder for storing all the variables
	String/G titlebox_pixel = "pixel position"
	String/G CorOpt="ACF (all);dCCF (horiz);dCCF (vert);dCCF (horiz & vert);dCCF (diag 45 deg);dCCF (diag 135 deg);dCCF (diag 45 & 135 deg);dCCF (all);CCF (dual view);CCF (left & right);CCF (up &down);CCF (pixels at 45 deg);CCF (pixels at -45 deg);CCF (surrounding rect);ACF (Sel Region);CCF (Sel Region);dccfhor(ab-bc)" 
	String/G Displayopt
	String/G cameraopt = "128x128;512x512"
	String/G MagOpt  = "10X;20X;40X;60X;63X;100X"
	String/G FileName="C:\Users\adminNUS\Desktop\ITIR-FCS programs"	
	String/G path_mac, path_mac1, path_real	
	String/G diff_co
	
	/////************************************************************
	//Initials on the display for data analysis
	Variable/G FirstFrame = 1										//Default frames to be correlated
	Variable/G LastFrame =30000
	Variable/G TimeLag = 0.002				// Default time lag
	Variable/G Bin = 1													// Default binning size in X and Y
	Variable/G Background = 80										// Default BGR value
	Variable/G BGRFile = 0												// The two variable conrol the setting of the BGR buttons since only one can be selected
	Variable/G BGRConstant = 1
	Variable/G BinLimit = 7	
	String/G basename = "corr"
	/////************************************************************
	
	/////************************************************************
	/////Initials for data fitting on the display
	Variable/G vx =0
	Variable/G vy =0 
	Variable/G channel1 =16			//p value in (p,q) correlator
	Variable/G channel2 = 8			// q value in (p,q) correlator
	Variable/G logarithmiccorrelation = 1 //By default, correelation is logarithmic
	Variable/G linearpoints = 7000 	// Number of points till which the correlation has to be carried
	Variable/G gRadioval	
	Variable/G fit_check = 0
	variable/G xwave_scale= 0
	Variable/G pixel = 240e-9
	Variable/G sigma = 0.4
	variable/g sigz = 0.21
	Variable/G N = 10
	Variable/G q = 0.25
	Variable/G lambda = 5.1e-7
	Variable/G D = 0.0000000000001
	Variable/G D1 = 0.0000000000001
	Variable/G NA = 1.45
	Variable/G fittingparameter = 1
	Variable/G fittingparameter_D
	Variable/G fittingparameter_vx = 1
	Variable/G fittingparameter_vy =1 
	Variable/G fittingparameter_D1=0
	Variable/G q_hold=0
	Variable/G filestochoose = 2
	Variable/G sd_display = 0
	Variable/G sd__ = 0
	Variable/G koppel_display = 0      //The user modifies this, if the standard deviation has to be changed to Koppel's mode
	Variable/G sig_it_display = 0 		// The user modifies this, if the S.D has to be changed to SD while calculating the mean
	Variable/G split_frame_display = 1		//By default, the S.D mode is by splitting the frame.
	//variable/G bleach_value = 0
	Variable/G spim_mod = 0				// Choosing the fitting model
	Variable/G ITIRFCCS_mod = 1			// By default, the fitting model is ITIR-FCCS
	DoWindow/K table0
	Dowindow/H/Hide=1
	Variable/G xval2, yval2
	Variable/G check_var = 0
	String/G hisopt = "D; N; sig; DC; chisq; dccf-h; dccf-v"  
	Variable/G sigz_hold= 0
	//Execute "ModifyBrowser close"
	variable/G NA_exc = 1.45	//This value is only for the ITIR-FCCS model
	Variable/G lambda_exc = 4.88e-7 //This value is only for the SPIM model.
	variable/g auto_bin= 1
	variable/g manual_bin = 0
	variable/g v_start = 0
	variable/g v_size = 0
	variable/g v_end = 0
	Variable/G image_display = 1 
	Variable/G histogram_display = 0
	Variable/G N_hold= 0
	Variable/G bleachexpov=1
	Variable/G bleachwindowv=0
	Variable/G time_Slide= 1
	Variable/G p1_mod = 1
	Variable/G p2_mod= 0
	variable/G particle=1
End
//
////********************************************************************************
////  Main Control Panel definitions
////********************************************************************************
//
Function ITIRFCCSShowMainControl_new()
	DoWindow/K ITIRFCCSMainControl_new
	Execute "ITIRFCCSMainControl_new()" 
End	
//
//
////***********************************
Window ITIRFCCSMainControl_new() : Panel
	String dfSave=GetDataFolder(1) 
	SetDataFolder root:ITIRFCCS
	String/G Displayopt
	//	String CurrentFileName, StartFileName, EndFileName
	Variable/G PanelPosL, PanelPosT, PanelPosR,PanelPosB
	Variable PMPosX, PMPosY
	Variable i
	PanelPosL=950
	PanelPosT=0
	PanelPosR=1250
	PanelPosB=870
	PMPosX=5
	PMPosY=130 
		
	//	PauseUpdate; Silent 1
	NewPanel/K=2/W=(PanelPosL,PanelPosT,PanelPosR,PanelPosB) as "ImFCS"	// initial values depend on screen
	
	//////////*********************************************************
	///Parameters of the file
	PopupMenu SelectCor title="Corr",fsize=10,font="Arial",pos={10,20},size={200,9},value=root:ITIRFCCS:CorOpt
	GroupBox File_param title="Stack info", pos={5,50},size={100,105}
	SetVariable FirstFrame, title="Initial", fsize=10, font="Arial", pos={10,70},size={85,20},frame=1,limits = {1, 140000,1}, value=FirstFrame
	SetVariable LastFrame, title="Final", fsize=10, font="Arial", pos={10,100},size={85,20},frame=1,limits = {1, 140000,1},value=LastFrame
	/////////**********************************************************
	
	
	CheckBox sd_display1 title="SD", pos={15,255}, size={14,14}, mode=0, value=sd_display, proc = sd_ca
	SetVariable Bin, title="Bin", fsize=10, font="Arial", pos={125,22},size={50,10},frame=1, limits={1,10,1},value = Bin
	SetVariable basename, title="Name", fsize=10, font="Arial", pos={70,300},size={90,25},frame=1, value = basename, disable =1
	SetVariable TimeLag, title="Time", fsize=10, font="Arial", pos={10,130},size={85,20},frame=1, limits={0,1,0.0001},value=TimeLag
	
	////////////////****************************************************
	//Details of the background
	GroupBox Background_BOX title="Background ", pos={110,50},size={100,105}
	CheckBox BGRFile title="File", pos={115, 70}, size={14,14}, mode=1, value=BGRFile, proc=MyCheckProc_new
	CheckBox BGRConstant title="Constant", pos={115,100}, size={14,14}, mode=1,  value=BGRConstant, proc=MyCheckProc_new
	SetVariable Background, title="Value", fsize=10, font="Arial", pos={115,130},size={85,25},frame=1, limits={0,65536,1},value = Background
	///////////////////////////////////////////////////////////////////
	
	
	/////////////////*************************************************
	////Correlator Structure
	GroupBox Correlation_algorithm title="Correlation scheme", pos={5,160},size={285,45}
	SetVariable channel1, title="p ", fsize=10, font="Arial", pos={10,180},size={50,25},frame=1, limits={2,100,2},value = Channel1
	SetVariable channel2, title="q ", fsize=10, font="Arial", pos={70,180},size={50,25},frame=1, limits={2,99,1},value = Channel2
	/////////////////////////////////////////////////////////////////////////
	
	/////////////////***********************************************
	////Curve Fitting details
	GroupBox Curve_fitting title="Curve fitting", pos={5, 310},size={285,250}, disable = 1
	SetVariable  D, title = "D  ", fsize = 12, font  = "Arial", pos = {10, 325}, size = {80,25}, frame = 1, limits = {0, 1, 1e-13},value = D, disable = 1
	GroupBox fit_results title="Fit Results", pos={10,710},size={150,150}, disable = 1
	SetVariable vx, title = "vx  ", fsize = 12, font  = "Arial", pos = {10, 355}, size = {80,25}, frame = 1, limits = {0,1e-3, 1},value = vx, disable =1
	PopupMenu histo title="His",disable = 0,fsize=10,font="Arial",pos={130,637},size={110,25},value=root:ITIRFCCS:hisopt, proc = his_pop, disable = 1
	CheckBox fittingparameter title="Fix", pos={100, 445}, size={14,14}, mode=0, value=fittingparameter, disable = 1
	SetVariable   vy, title = "vy", fsize = 12, font  = "Arial", pos = {10, 385}, size = {80,25}, frame = 1, limits = {0,1e-3, 1e-8},value =vy, disable = 1
	SetVariable   N, title = "N", fsize = 12, font  = "Arial", pos = {10, 415}, size = {80,25}, frame = 1, limits = {0.1,10000, 0.01},value =N, disable = 1
	SetVariable  sigma, title = "sig xy ", fsize = 12, font  = "Arial", pos = {10,445}, size = {80,25}, frame = 1, limits = {0,1000, 0.01},value = sigma, disable = 1
	SetVariable  pixel, title = "pixel ", fsize = 12, font  = "Arial", pos = {10,660}, size = {110,25}, frame = 1, limits = {1e-7,1e-6, 1e-8},value = pixel, disable = 1
	SetVariable  lambda, title = "WL Emi", fsize = 12, font  = "Arial", pos = {160, 600}, size = {120,25}, frame = 1, limits = {1e-8,1e-6, 1e-8},value = lambda, disable = 1
	SetVariable NA, title = "NA Emi", fsize = 12, font  = "Arial", pos = {10,600}, size = {90,25}, frame = 1, limits = {0.1,2, 0.1},value = NA, disable = 1
	Button Fit pos={120, 300}, size={110, 24}, fsize=10, font="Arial", title="Fit", proc=CurveFitting, disable = 1
	CheckBox fittingparameter_D title="Fix", pos={100, 325}, size={14,14}, mode=0, value=fittingparameter_D, disable = 1
	CheckBox fittingparameter_vx title="Fix", pos={100,355}, size={14,14}, mode=0, value=fittingparameter_vx, disable = 1
	CheckBox fittingparameter_vy title="Fix", pos={100, 385}, size={14,14}, mode=0, value=fittingparameter_vy, disable = 1
	CheckBox fittingparameter_N title="Fix", pos={100, 415}, size={14,14}, mode=0, value=N_hold, disable = 1
	PopupMenu camera title="Cam",fsize=10,font="Arial",pos={110,475},size={200,24},value=root:ITIRFCCS:CameraOpt, proc = cam_pop, disable = 1
	PopupMenu mag title="Mag",fsize=10,font="Arial",pos={210,475},size={200,24},value=root:ITIRFCCS:MagOpt, proc = cam_pop, disable = 1
	////////////////*************************************************
	
	
	//////Fitting Model choice
	CheckBox ITIRFCCS_model title="ITIR-FCCS", pos={10, 295}, size={14,14}, mode=1, value=ITIRFCCS_mod, proc = fitmodel_choose, disable = 1
	CheckBox spim_model title="SPIM", pos={90, 295}, size={14,14}, mode=1, value=spim_mod, proc = fitmodel_choose, disable = 1
	/////////////////////////////////////////////////////////////////////////
	
	///////*********************************************************
	///////Particle Model choice
	CheckBox p1_model title="1p", pos={220, 295}, size={14,14}, mode=1, value=p1_mod, proc = p_choose, disable = 1
	CheckBox p2_model title="2p", pos={255, 295}, size={14,14}, mode=1, value=p2_mod, proc =p_choose, disable = 1
	//////////////////////////////////////////////////////////////////////////
	
	//////////********************************************************
	//////////Histogram Details
	CheckBox automated_bin title="auto", pos={70, 640}, size={14,14}, mode=1, value=auto_bin, proc=MyCheckProc_histogram, disable = 1
	CheckBox manual_bin title="manual", pos={10, 640}, size={14,14}, mode=1, value=manual_bin, proc=MyCheckProc_histogram , disable = 1
	GroupBox his_results title="Histogram", pos={5,670},size={285,100}, disable = 1
	//////////********************************************************
	
	//////////********************************************************
	//////////Automated Calibration and diffusion law
	GroupBox cal_results title="Calibration", pos={300,430},size={210,200}, disable = 1
	Button Calibrate pos={320, 600}, size={110, 24}, fsize=10, font="Arial", title="Calibrate", proc=Calibration, disable = 1
	Button dlaw pos={320, 800}, size={110, 24}, fsize=10, font="Arial", title="Diffusion law", proc=Calibration1, disable = 1
	//////////**********************************************************
	
	CheckBox image_show title="Image", pos={10, 700}, size={14,14}, mode=1, value=image_display, proc = display_choose, disable = 1
	CheckBox histogram_show title="Histogram", pos={90, 700}, size={14,14}, mode=1, value=histogram_display, proc =display_choose, disable = 1
	Button MultipleFile pos={190, 20}, size={60,24}, fsize=10, font="Arial", title="Choose file",proc= ITIRFCSLoadAll_new
	Button killeverything pos = {270,20}, size = {25,24}, fsize = 12, font = "Arial", title = "Kill", proc = KillEverything
	
	
End 


////////************* The files are chosen here for analysis
Function ITIRFCSLoadAll_new(ctrlName) : ButtonControl
	String ctrlName
	String outputpath1
	String outputpath
	String FileList
	variable i, j
	//Open/D/R/M="Select a file in the folder you want to load all files" refNum
	//outputPath1 = S_fileName
	//outputpath = ParseFilePath(1, outputpath1, ":", 1, 0)
	String outputpathwindows
	Variable refNum
	String message = "Select one or more files"
	String outputPaths
	String fileFilters = "Data Files (*.tif):.tif;" 
	//fileFilters += "All Files:.*;"
	//NVAR bleach_value = root:ITIRFCCS:bleach_value
	
	//Open /D /R /MULT=1 /F=fileFilters /M=message refNum
	Open /D /R /M=message refNum
	outputPaths = S_fileName
	Variable numFilesSelected = ItemsInList(outputPaths, "\r")
	j = numFilesSelected
	if (j>5)
		//print "This program can process only 5 files at a time. Only the first 5 files were taken for analysis"
		j = 5
	endif
	if(strlen(outputPaths)==0)
		Print "No files selected"
		return -1 
	else
		Variable position
		Make/O/T/N=(j) FolderFileList
		Make/O/T/N=(j) output_minimum
		Make/O/T/N=(j) output_corr
		Make/O/T/N=(j) output_int
		Make/O/T/N=(j) output_sd
		
		Make/O/N=(j) numberoffiles
		Make/O/N=(j) numberofrows
		Make/O/N=(j) numberofcolumns
		Make/O/N=(j) minimum
		Make/O/N=(j) maximum
		String corr_dis, int_dis
		Make/O/T/N = (j) output_corr_dis
		Make/O/T/N =(j) output_int_dis
		Make/O/T/N = (j) output_bleach
		String/G path
		for(i=0;i<numFilesSelected;i+=1)	
			//Open/D/R/M="Select a file in the folder you want to load all files" refNum
			//outputpath1 = S_filename
			path = StringFromList(i, outputPaths, "\r")
			// print path
			outputPath = ParseFilePath(5, path, "\\", 1, 0)
			position = strsearch(outputPath, ".tif", 0)
	
			if (position == -1)
				print "choose a tif file"
				return -1
			endif
				
			FolderFileList[i] = ParseFilePath(5, path, "\\", 1, 0) //This folder stores the filename of the tif file being correlated
			output_minimum[i] =  RemoveEnding(FolderFileList[i], ".tif") 
			output_corr[i] =  RemoveEnding(FolderFileList[i], ".tif") //This is the name of the file which stores the correlation.This is a binary file
			output_int[i] =  RemoveEnding(FolderFileList[i], ".tif")	//This stores the intensity values in the file
			output_bleach[i] = removeEnding(FolderFileList[i], ".tif"); 
			output_sd[i] = removeEnding(FolderFileList[i], ".tif"); //This stores the standard of the autocorrelation of the pixels
			//config[i] = removeEnding(FolderFileList[i], ".tif"); 
			corr_dis = output_corr[i]
			int_dis = output_int[i]
			
			/////////*******************************************************
			/////////This section determines the names of the various files to be created
			output_minimum[i] = output_minimum[i] + "_min.txt"
			output_corr[i] = output_corr[i] + "_corr.bin"
			output_int[i] = output_int[i] + "_int.bin"
			output_bleach[i] = output_bleach[i] + "_bleach.tif"
			output_int_dis[i]= int_dis + "_int_nn.bin"
			output_corr_dis[i] = corr_dis + "_corr_nn.bin"
			output_sd[i] = output_sd[i] + "_sd.bin"
		       //////////*******************************************************
			//print config[i] 
			//maximum[i] =  maximum_tif_corr(FolderFileList[i], output_minimum[i], 1, numberoffiles[i] )
			minimum[i] = all_tif_corr(FolderFileList[i], output_minimum[i])	
			Make/O wave0 
			LoadWave/O/A= wave/J /N/Q output_minimum[i]
			//DeleteFile output_minimum[i]
			String name_filedata = "file_data" + num2str(i)
			numberofrows[i]  = wave0[0]; //Number of rows in the image
			numberofcolumns[i] = wave0[1]; //Number of columns in the image
			numberoffiles[i]=wave0[2]; //The total number of files which the program can handle at present is only 1
			maximum[i] = wave0[3]; 
			//Rename wave0, $name_filedata
			Make/O $name_filedata
			Duplicate/O wave0,$name_filedata 
			 
			KillWaves wave0	  		 
		endfor     
	endif  
	
	//Print "Proceed on to Correlate the chosen file(s)" 
	Button correlate pos={130,175}, size={55,24}, fsize=10, font="Arial", title="Correlate",proc= correlate_proc
	variable ll, loopn

	variable i1=0, filecal = 1
	NVAR channel1 = root:ITIRFCCS:channel1
	NVAR channel2 = root:ITIRFCCS:channel2
	if ( mod(Channel1, 2) != 0)
		channel1 = channel1+1
	endif
	NVAR timeLag = root:ITIRFCCS:timeLag
	NVAR logarithmiccorrelation = root:ITIRFCCS:logarithmiccorrelation
	NVAR linearpoints = root:ITIRFCCS:linearpoints
	if(logarithmiccorrelation == 1)
		//variable ll
		Make/O/N = (channel1 + (channel2-1)*channel1/2) lagtime = 0
		Make/O/N = (channel1 + (channel2-1)*channel1/2) lagtime_check = 0
		Make/O/N = (channel1 + (channel2-1)*channel1/2) m_value = 0
		
		/////////////////////*******************************************
		//**********The lagtime values are calculated here for a semi-logarithmic calculator
		do
			lagtime_check[i1] = i1 * filecal;
			m_value[i1] = i1
			i1 = i1 + 1;
		while( i1<channel1); 
		i1 = 2;
		ll = 1
		do
			variable k1=0, a 
		
			do
				a =  (2.0^ll);
				lagtime_check[i1*(channel1/2)+k1] = filecal*a*(k1+1) + lagtime_check[i1*(channel1/2) -1]
				m_value[i1*(channel1/2)+k1] = k1
				k1= k1 + 1;
			while(k1 <=(channel1/2)-1);
		
			i1= i1 + 1;
			ll = ll+ 1

		while( ll<channel2);
	
		filecal = timelag
		i1=0
	 
		do
	
			lagtime[i1] = i1 * filecal;
			i1 = i1 + 1;
		
		while( i1<channel1);

		i1 = 2;
		ll = 1
		do

			k1=0
		 
			do

				a =  (2.0^ll);
				lagtime[i1*(channel1/2)+k1] = filecal*a*(k1+1) + lagtime[i1*channel1/2 -1]
				k1= k1 + 1;

			while(k1 <=(channel1/2)-1);
		
			i1= i1 + 1;
			ll = ll+ 1
			
		while( ll<channel2);
		
	
	else
	
	//////************************************************************
	//////*********************The lagtime values in a linear calculator are chosen here
	
		Make/O/N = (linearpoints) lagtime = 0 
		Make/O/N = (linearpoints) lagtime_check = 0 
					
		i1=0
		filecal = timelag
		do
			lagtime[i1] = i1 * filecal;
			i1 = i1 + 1;
		while( i1<linearpoints);
	
	endif
	NVAR firstframe = root:ITIRFCCS:firstframe
	NVAR lastframe = root:ITIRFCCS:lastframe
	Wave numberofrows = root:ITIRFCCS:numberofrows
	waveStats/Q numberofrows
	variable loopnumber = V_npnts
	Make/O/D/N = (loopnumber) successfulfiles = -1
	Variable succ_file_count = 0
	for ( i = 0; i<loopnumber; i=i+1)
		//print i
		if( FirstFrame > numberoffiles[i]  ||  LastFrame >numberoffiles[i])
			print "The suggested frames don't exist in this file numbered ", i
			continue
		endif
		
		if(logarithmiccorrelation == 1)
		//////////******************************************************
		//////////In order to calculate the logarithmic correlation, a certain minimum number of files is required. If that certain number of files do not exist, an error message is thrown out
	
			if ( LastFrame - FirstFrame < lagtime_check[ (channel1 + (channel2-1)*channel1/2)-1])
				print "The suggested number of frames is not sufficient to carry out correlations for the chosen number of channels in file numbered", i
				continue
			endif
		/////////********************************************************		
		else
	
				
			if ( LastFrame - FirstFrame < linearpoints)
				print "The suggested number of frames is not sufficient to carry out correlations for the chosen number of points in file numbered " ,i 
				continue
			endif
				
		endif
		successfulfiles[succ_file_count] = i
		succ_file_count = succ_file_count+ 1
		String temp2= "Display_intensity" + num2str(i)
		LoadWave/O/A=Dis_intensity/J /N/Q output_minimum[i]
		DeletePoints 0,4, dis_intensity0
		Redimension/N=(numberofcolumns[i], numberofrows[i]) dis_intensity0
		/////This step is changed to accomodate the presence of cursors
	
	
		//	MatrixTranspose dis_intensity0
	
	
		/////	/////////////////////////////////////////////////////////////////////////////////	
		Make/N = (numberofcolumns[i]*numberofrows[i])/O wave_dis
		Variable bb
		for (bb= 0; bb <numberofcolumns[i]*numberofrows[i]; bb = bb + 1)
			wave_dis[bb] =bb
		endfor
		tif_program(FolderFileList[i], output_corr_dis[i], output_int_dis[i], 1, numberoffiles[i] , 0,1, channel1, channel2,wave_dis, wave_dis)
		GBLoadWave/B/A=uk/T={96,96}/W=(numberofcolumns[i]*numberofrows[i])/U=(numberoffiles[i])/Q output_int_dis[i]
		DeleteFile output_int_dis[i]
		DeleteFile output_corr_dis[i]
		String ren_wave 
		String uk_wave 
		//////////////////NandB analysis
		Make/n=(numberofcolumns[i]*numberofrows[i]) N_B_mean
		Make/n=(numberofcolumns[i]*numberofrows[i]) N_B_sd
		for (bb= 0; bb <numberofcolumns[i]*numberofrows[i]; bb = bb + 1)
			uk_wave = "uk" + num2str(bb)
			ren_wave = "int_" + num2str(i) + "_" + num2str(bb) 
			//Rename $uk_wave, $ren_wave
			Make/O $ren_wave
			Duplicate/O $uk_wave, $ren_wave
			KillWaves $uk_wave
			wavestats/Q $ren_wave
			N_B_mean[bb] = V_avg
			N_B_sd[bb]=V_sdev
			
		endfor	
		
		NVAR Background = root:ITIRFCCS:Background 
		Redimension/N=(numberofcolumns[i], numberofrows[i]) N_B_mean
		Redimension/N=(numberofcolumns[i], numberofrows[i]) N_B_sd
		Make/N=(numberofcolumns[i], numberofrows[i])/O NandB_N
		Make/N=(numberofcolumns[i], numberofrows[i])/O NandB_B
		variable emccd_variance
		//emccd_variance = N_B_mean
		emccd_variance=3.39*3.39
		NandB_N = (N_B_mean-Background)^2/(N_B_sd^2-emccd_variance)
		NandB_B = (N_B_sd^2-emccd_variance)/(N_B_mean-Background)
		Display/N = NandB_N/I/W = (0,0.5, 2,2.5); AppendImage NandB_N
		ModifyGraph width=100,height={Aspect,1}
		SetAxis/A/R left
		Display/N = NandB_B/I/W = (0,0.5, 2,2.5); AppendImage NandB_B
		ModifyGraph width=100,height={Aspect,1}
		SetAxis/A/R left
		/////////////////////////////////////////////////////////////////N and B ends
		String display_wave
		display_wave = "displaY_wave" + "_" + num2str(i)
		Make/N = (numberoffiles[i])/O $display_wave = 0
		Display/N = Intensity_dis/I/W = (2.5,0.5,4.5,2.5) $display_wave  
		Label left "counts"
		Label bottom "Frame"
		ModifyGraph width=100,height={Aspect,1}
		ModifyGraph highTrip(bottom)=100000
		Display/N = Choose_Pixel/I/W = (0,0.5, 2,2.5); AppendImage dis_intensity0
		ModifyGraph width=100,height={Aspect,1}
		
		///This step is acomodated to change the movement of cursors
		//ModifyGraph swapXY=1 
		///////////////////////////////////////////
		SetAxis/A/R left
		ShowInfo
		String graphname = winname(0,1)
		Cursor /I A dis_intensity0 0, 0
		Cursor /K/W=$graphName B
		Cursor/M /C=(65535,65535,0)/W=$graphName A
		Rename dis_intensity0, $temp2
		//Make/O $temp2
		//Duplicate/O dis_intensity0, $temp2
		//KillWaves dis_intensity0
		CursorGlobalsForGraph()
		CursorDependencyForGraph()
		CursorMoved(graphname, 0)
	Endfor
	
	//variable filestobedeleted = 0
	for (j = 0; j< loopnumber; j=j+1)
		if(successfulfiles[j] == -1)
			//filestobedeleted = filestobedeleted + 1
			successfulfiles[j] = nan
		Endif
	Endfor
	RemoveNans(successfulfiles)  
		
	Dowindow/F ITIRFCCSmaincontrol_new
	Wavestats/Q Successfulfiles 
	Variable  n_1 = V_npnts, uu
	String str = "\""
	for ( uu = 0; uu < n_1; uu = uu +1)
		//str = str + ParseFilePath(3, FolderFileList[(successfulfiles[uu])] , ":", 0, 0) + ";"
		str= str + num2str(successfulfiles[uu]) + ";"
	endfor
	str = str + "\"" 
	ControlInfo/W=ITIRFCCSMainControl_new SelectCor
	if (V_Value ==1)

	endif
	String/G titlestr = "Pixel"
	TitleBox  pixel_pos, pos = {65,735}, size ={260,30}, fsize = 12, font = "Arial", frame = 1, variable = titlebox_pixel
	TitleBox  pixel_pos1, frame = 0, pos = {20,735}, size ={260,30}, fsize = 12, font = "Arial", variable = titlestr
	SetVariable FirstFrame disable=2
	SetVariable LastFrame disable=2
	SetVariable TimeLag disable=2
	SetVariable channel1 disable=2
	SetVariable channel2 disable=2
	Button multiplefile disable = 2
	ControlInfo/W=ITIRFCCSMainControl_new sd_display1
	//print "V_value", V_value
	//print time()
	GroupBox Config_info title="Configuration", pos={215,50},size={85,105}
	Button save_config pos={230,80}, size={55, 24}, fsize=10, font="Arial", title="Save conf", proc=save_config
	Button load_config pos={230,110}, size={55, 24}, fsize=10, font="Arial", title="Load conf", proc=load_config

End   
////////////////********** The values of the auto and cross-correlation are calculated here
Function correlate_proc(ctrlName) : ButtonControl 
	String ctrlName 
	
	NVAR bin = root:ITIRFCCS:bin
	NVAR firstframe = root:ITIRFCCS:firstframe
	NVAR lastframe = root:ITIRFCCS:lastframe
	NVAR channel1 = root:ITIRFCCS:channel1
	NVAR channel2 = root:ITIRFCCS:channel2
	NVAR Background = root:ITIRFCCS:Background
	NVAR logarithmiccorrelation = root:ITIRFCCS:logarithmiccorrelation
	NVAR linearpoints = root:ITIRFCCS:linearpoints
	NVAR timeLag = root:ITIRFCCS:timeLag
	NVAR auto_bin= root:ITIRFCCS:auto_bin
	NVAR v_size = root:ITIRFCCS:v_size
	NVAR v_start = root:ITIRFCCS:v_start
	NVAR v_end = root:ITIRFCCS:v_end
	SVAR hisopt = root:ITIRFCCS:hisopt
	SVAR basename = root:ITIRFCCS:basename
	//NVAR bleach_value = root:ITIRFCCS:bleach_value
	//SVAR display_opt= root:ITIRFCCS:display_opt
	Variable/G i,j, k, l,m
	Variable cp
	Variable/G background_for_program
	String firstpixel , secondpixel
	String basename_modified
	String graph_name
	String graph_rename
	Wave lagtime_check = root:ITIRFCCS:lagtime_check
	wavestats/Q lagtime_check
	Variable critical_files
	critical_files = v_npnts
	Wave lagtime = root:ITIRFCCS:lagtime
	Wave numberoffiles = root:ITIRFCCS:numberoffiles
	Wave numberofrows = root:ITIRFCCS:numberofrows
	Wave numberofcolumns = root:ITIRFCCS:numberofcolumns
	Wave minimum = root:ITIRFCCS:minimum
	Wave/T FolderFileList = root:ITIRFCCS:FolderFileList
	Wave/T output_corr= root:ITIRFCCS:output_corr
	Wave/T output_int = root:ITIRFCCS:output_int
	Wave/T output_minimum = root:ITIRFCCS:output_minimum
	Wave/T output_corr_dis = root:ITIRFCCS:output_corr_dis
	//Wave/T output_int_dis = root:ITIRFCCS:output_int_dis
	Wave/T output_sd = root:ITIRFCCS:output_sd
	ControlInfo/W=ITIRFCCSMainControl_new sd_display1
	//print  "V_value_", V_value
	Nvar sd__ =  root:ITIRFCCS:sd__
	sd__  = V_Value
			
	if (FirstFrame > LastFrame)
		print "The firstframe cannot be greater than the last frame"
		return -1
	endif
	Button bleach title="Bleach Correct", pos={200, 217}, size={85,20}, disable = 0, fsize=10, font="Arial", proc = bleach_corr
	
	//////////////////
	
	
	NVAR bleachexpov = root:ITIRFCCS:bleachexpov
	NVAR bleachwindowv = root:ITIRFCCS:bleachwindowv
	NVAR time_slide = root:ITIRFCCS:time_Slide
	GroupBox bleach_info title="Bleach info", pos={5,200},size={285,45}
	
	CheckBox bleachexpo title="Expo", pos={10, 220}, size={14,14}, mode=1, value=bleachexpov, proc=MyCheckProc_new1
	CheckBox bleachwindow title="Slide", pos={70,220}, size={14,14}, mode=1,  value=bleachwindowv, proc=MyCheckProc_new1
	SetVariable bleachvalue, title="time", font="Arial", pos={130,220},size={60,25},frame=1, limits={0,65536,1},disable = 1, value = time_slide
	
	
	////////////////////////////
	
	waveStats/Q numberofrows
	variable loopnumber = V_npnts
	Variable display_counter

	//	
	GroupBox Curve_fitting title="Curve fitting", pos={5, 278},size={285,290}, disable = 0
	SetVariable  D, title = "D  ", fsize = 12, font  = "Arial", pos = {10, 325}, size = {80,25}, frame = 1, limits = {0, 1, 1e-13},value = D, disable = 0
	GroupBox fit_results title="Fit Results", pos={10, 720},size={290,140}, disable = 0
	SetVariable vx, title = "vx  ", fsize = 12, font  = "Arial", pos = {10, 355}, size = {80,25}, frame = 1, limits = {0,1e-3, 1},value = vx, disable =0
	//Button histogram pos = {170,630}, size  = {90, 20}, fsize = 12, font = "arial", title = "Histogram", proc= histogram_fcs
	PopupMenu histo  proc = his_pop, disable = 0
	
	CheckBox fittingparameter  disable =0
	SetVariable   vy, title = "vy", fsize = 12, font  = "Arial", pos = {10, 385}, size = {80,25}, frame = 1, limits = {0,1e-3, 1e-8},value =vy, disable = 0
	SetVariable   N, title = "N", fsize = 12, font  = "Arial", pos = {10, 415}, size = {80,25}, frame = 1, limits = {0.1,10000, 0.01},value =N, disable =0
	SetVariable  sigma, title = "sig xy ", fsize = 12, font  = "Arial", pos = {10,445}, size = {80,25}, frame = 1, limits = {0,1000, 0.01},value = sigma, disable = 0
	SetVariable  pixel, title = "pixel ", fsize = 12, font  = "Arial", pos = {10,475}, size = {100,25}, frame = 1, limits = {1e-7,1e-6, 1e-8},value = pixel, disable =0
	SetVariable  lambda, title = "WL Emi", fsize = 12, font  = "Arial", pos = {160, 505}, size = {120,25}, frame = 1, limits = {1e-8,1e-6, 1e-8},value = lambda, disable = 0
	SetVariable NA, title = "NA Emi", fsize = 12, font  = "Arial", pos = {10,505}, size = {90,25}, frame = 1, limits = {0.1,2, 0.1},value = NA, disable = 0
	Button Fit pos={115, 300}, size={25, 24}, fsize=10, font="Arial", title="Fit", proc=CurveFitting, disable = 0
	CheckBox fittingparameter_D disable = 0
	CheckBox fittingparameter_vx disable = 0
	CheckBox fittingparameter_vy  disable =0
	CheckBox fittingparameter_N  disable = 0
	//PopupMenu SelectCor title="Corr Type:",fsize=10,font="Arial",pos={10,20},size={200,24},value=root:ITIRFCCS:CorOpt
	//Setvariable fit_check_1, value= fit_check
	PopupMenu camera disable =0
	PopupMenu mag disable =0
	//variable bleach_value
	//GroupBox Bleach_corr title="Bleach correction ", pos={183,55},size={115,80}
	CheckBox ITIRFCCS_model disable = 0
	CheckBox spim_model disable = 0
	//String/G titlemod = "Fitting Model" 
	//TitleBox  fir_mod, frame = 0, pos = {15,350}, size ={260,30}, fsize = 12, font = "Arial", variable = titlemod, disable = 0
	CheckBox automated_bin  disable = 0
	CheckBox manual_bin disable = 0
	GroupBox his_results title="Histogram", pos={5,620},size={285,100}, disable = 0
	//GroupBox cal_results title="Calibration", pos={300,300},size={75,200}, disable = 0
	Button Calibrate pos={93, 570}, size={75, 24}, fsize=10, font="Arial", title="PSF", proc=Calibration, disable = 0
	Button dlaw pos={10, 570}, size={75, 24}, fsize=10, font="Arial", title="Diffusion law", proc=Calibration1, disable = 0
	CheckBox image_show disable =0
	CheckBox histogram_show  disable =0
	
	//Button fit_again disable = 0
	Button Fit pos={140, 295}, size={25, 24}, disable = 0, fsize=10, font="Arial", title="Fit", proc=CurveFitting
	Button Plot_all pos={200, 175}, size={50, 24}, fsize=10, font="Arial", title="Plot all", proc=Plot_all
	CheckBox p1_model  disable = 0
	CheckBox p2_model  disable = 0
	
	ControlInfo/W=ITIRFCCSMainControl_new SelectCor
	Variable/g V_value_ = V_value
	//print "V_" , V_value
	//Make/O/D/N = (loopnumber) successfulfiles = -1
	Variable succ_file_count = 0
	//Button show_intensity pos = {170, 235}, size = {90, 20}, font = "arial", title = "Show Intensity", proc = display_intensity
	String display_wave_corr
	if(sd__ ==1)
		CheckBox koppel title="koppel", disable = 2
		CheckBox sig_it title="algo", disable = 2
		Checkbox split_frame title = "split", disable = 2
	endif
	CheckBox sd_display1 title="SD",   disable = 2
	
	
	for ( i = 0; i<loopnumber; i=i+1)
		//print i
		if( FirstFrame > numberoffiles[i]  ||  LastFrame >numberoffiles[i])
			print "The suggested frames don't exist in this file numbered ", i
			continue
		endif
	
		if (Background > minimum[i])
			Print  i, " numbered file has a lower minimum than the chosen background file"
			Background_for_program = minimum[i]
			print background_for_program
			Background = Background_for_program
		else
			background_for_program = Background
		endif
	
		firstpixel = "firstpixel" + num2str(i)
		secondpixel = "secondpixel" + num2str(i)
		variable jj
		//This begins the correlation section
		//******************
		//The variable V_value_ indicates the type of correlation to be performed. The values have one to one correspondence to types of correlation displayed in the dropdown box on the ImFCS screen
		if (V_value_ ==1)
	
			Make/N = (floor(numberofrows[i]/bin) * floor(numberofcolumns[i]/bin))/O/D w1
			Make/N = (floor(numberofrows[i]/bin) * floor(numberofcolumns[i]/bin))/O/D w2
			//firstpixel = "firstpixel_acf" + num2str(i)
			//secondpixel = "secondpixel_acf" + num2str(i)
			l = 0
	
			for (j = 0; j<floor(numberofrows[i]/ bin); j= j+1)
				for (k = 0; k<floor(numberofcolumns[i]/bin); k= k+1)
					w1[l] = j*bin*numberofcolumns[i] + bin*k
					w2[l] = w1[l]
					l = l+ 1
				Endfor
			Endfor
			variable changer_cha
			ControlInfo/W=ITIRFCCSMainControl_new split_frame
			changer_cha = V_value
			variable algo_sd_value
			ControlInfo/W=ITIRFCCSMainControl_new sig_it
			algo_sd_value = V_value
			if(logarithmiccorrelation == 1)
				//			
				if (sd__ == 1)
					if(changer_cha == 1)
						if((lastframe - firstframe)/10 < lagtime_check[critical_files])
							for (jj = 1; jj<channel2; jj = jj+1)
								if ( lagtime_check[channel1 + (jj-1)*channel2]<(Lastframe  - firstframe)/10)
								else
									break;
								endif
							endfor
	
							channel2 = jj-1
						endif
						//print "channel2 = ", channel2 
						Redimension/N = ((channel1 + (channel2-1)*channel1/2)) lagtime
						Redimension/N = ((channel1 + (channel2-1)*channel1/2)) lagtime_check
					endif
				endif
	
	
	
				if ( LastFrame - FirstFrame < lagtime_check[ (channel1 + (channel2-1)*channel1/2)-1])
					print "The suggested number of frames is not sufficient to carry out correlations for the chosen number of channels in file numbered", i
					continue
				endif
				//print "mainprogram", Background_for_program 
				//print firstframe, lastframe
				if (sd__ == 1)
					if(algo_sd_value ==1)
						tif_program_s(output_sd[i], FolderFileList[i], output_corr[i], output_int[i], FirstFrame, LastFrame, Background_for_program, Bin, channel1, channel2,w1,w2)
						GBLoadWave/Q/B/A=corr/T={2,2}/W=(floor(numberofrows[i]/bin) * floor(numberofcolumns[i]/bin))/U=(channel1 + (channel2-1)*channel1/2) output_corr[i]
						GBLoadWave/Q/B/A=SD_file_0_pixel_/T={2,2}/W=(floor(numberofrows[i]/bin) * floor(numberofcolumns[i]/bin))/U=(channel1 + (channel2-1)*channel1/2) output_sd[i]
						DeleteFile output_int[i]
						DeleteFile  output_corr[i]
					else
						tif_program(FolderFileList[i], output_corr[i], output_int[i], FirstFrame, LastFrame, Background_for_program, Bin, channel1, channel2,w1,w2)
						GBLoadWave/Q/B/A=corr/T={2,2}/W=(floor(numberofrows[i]/bin) * floor(numberofcolumns[i]/bin))/U=(channel1 + (channel2-1)*channel1/2) output_corr[i]
						DeleteFile output_int[i]
						DeleteFile  output_corr[i]
					endif 
				else
					tif_program(FolderFileList[i], output_corr[i], output_int[i], FirstFrame, LastFrame, Background_for_program, Bin, channel1, channel2,w1,w2)
					GBLoadWave/Q/B/A=corr/T={2,2}/W=(floor(numberofrows[i]/bin) * floor(numberofcolumns[i]/bin))/U=(channel1 + (channel2-1)*channel1/2) output_corr[i]
					DeleteFile output_int[i]
					DeleteFile  output_corr[i]
				endif
				
				//String residual_wave_corr
				display_wave_corr = "displaY_wave_corr" + "_" + num2str(i)
				//residual_wave_corr = "residual_wave_corr" + "_" + num2str(i)
				Make/N = (channel1 + (channel2-1)*channel1/2)/O $display_wave_corr = 0
				Display/N = corr_dis/I/W = (5.1,0.5, 7.1,2.9) $display_wave_corr[1,(channel1 + (channel2-1)*channel1/2)-1]  vs lagtime[1,(channel1 + (channel2-1)*channel1/2)-1]
				ModifyGraph width=100,height=110
				Label left "\\Z11G(\\F'Symbol't\\F'Arial')"
				Label bottom "\\Z11\\F'Symbol't\\F'Arial' [s]"
				ShowInfo
				Cursor A, $display_wave_corr, leftx($display_wave_corr)
				Cursor B, $display_wave_corr, rightx($display_wave_corr) 
				ModifyGraph log(bottom)=1
				ModifyGraph rgb=(0,0,0)
				ControlInfo/W=ITIRFCCSMainControl_new sd_display1
				//print "V_value", V_value
				if(sd__==1)
					//ErrorBars display_wave_corr_0 Y,wave=(SD_file_0_pixel_50[1,71],SD_file_0_pixel_50[1,71])
					String sd_wave_corr = "sd_wave_corr_" + num2str(i)
					Make/N = (channel1 + (channel2-1)*channel1/2)/O $sd_wave_corr = 0
					ErrorBars $display_wave_corr Y,wave=($sd_wave_corr[1,(channel1 + (channel2-1)*channel1/2)],$sd_wave_corr[1,(channel1 + (channel2-1)*channel1/2)])
				endif	
		
			else
	
				//print "linearmode of correlation" 
				if ( LastFrame - FirstFrame < linearpoints)
					print "The suggested number of frames is not sufficient to carry out correlations for the chosen number of points in file numbered " ,i 
					continue
				endif
	
				linear_acf(FolderFileList[i], output_corr[i], output_int[i], FirstFrame, LastFrame, Background_for_program, Bin, linearpoints,w1,w2)
				GBLoadWave/Q/B/A=corr/T={2,2}/W=(floor(numberofrows[i]/bin) * floor(numberofcolumns[i]/bin))/U=(linearpoints) output_corr[i]
				DeleteFile output_int[i]
				DeleteFile  output_corr[i]
					
				display_wave_corr = "displaY_wave_corr" + "_" + num2str(i)
				Make/N =(linearpoints) $display_wave_corr = 0
				Display/N = Corr_dis/I/W = (6.5,0.5, 9.5,2.2)  $display_wave_corr[1, linearpoints-1] vs lagtime[1, linearpoints-1]
				//ModifyGraph width=151.2,height={Aspect,1}
				//ModifyGraph height=158.4
				ModifyGraph log(bottom)=1
	
	
			endif
	
			display_counter = 0
	
			for ( 	m =0; m <(floor(numberofrows[i]/bin) * floor(numberofcolumns[i]/bin)); m= m+1)
				graph_name = "corr" + num2str(m)
				graph_rename =basename + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m])
				//Rename $graph_name, $graph_rename
				////////////////////
				Make/O $graph_rename
				Duplicate/O $graph_name, $graph_rename
				killwaves $graph_name
				////////////////////
			endfor
			ModifyGraph log(bottom)=1
		
			Make/O $firstpixel, $secondpixel
			Duplicate/O w1, $firstpixel
			Duplicate/O w2, $secondpixel
		
		endif 
		
		if(V_value_ ==2)
		////********************************************
		//area_calc is the lagtime upto which the area under the curve needs to be calculated
			variable area_calc = 40
			variable area_calc1 = 1
		//area_calc1 is the lagtime from which the area under the curve needs to be calculated
			Prompt area_calc1, "Enter area_start"
			DoPrompt "area_start", area_calc1
			Prompt area_calc, "Enter area_end"
			DoPrompt "area_end", area_calc
			//			////Beginning of ab-ba
			Make/N = (floor(numberofrows[i]/bin) * (floor(numberofcolumns[i]/bin)-1)*2)/O/D w1
			Make/N = (floor(numberofrows[i]/bin) * (floor(numberofcolumns[i]/bin)-1)*2)/O/D w2
			l= 0
			for (j = 0; j<(floor(numberofrows[i]/bin)); j= j+1)
				for (k = 0; k<(floor(numberofcolumns[i]/bin)-1); k= k+1)
					w1[l] = j*numberofcolumns[i]*bin + k*bin
					w2[l] = j*numberofcolumns[i]*bin + k*bin + bin
					l = l+1
					w1[l] =j*numberofcolumns[i]*bin + k*bin + bin
					w2[l] = j*numberofcolumns[i]*bin + k*bin
					l= l+1
				Endfor
			Endfor
	
			firstpixel = "firstpixel_hor" + num2str(i)
			secondpixel = "secondpixel_hor" + num2str(i)
	
			if(logarithmiccorrelation == 1)
	
				if ( LastFrame - FirstFrame < lagtime_check[ (channel1 + (channel2-1)*channel1/2)-1])
					print "The suggested number of frames is not sufficient to carry out correlations for the chosen number of channels in file numbered", i
					continue
				endif
	
				tif_program(FolderFileList[i], output_corr[i], output_int[i], FirstFrame, LastFrame, Background_for_program, Bin, channel1, channel2,w1,w2)
				GBLoadWave/Q/B/A=corr/T={2,2}/W=(floor(numberofrows[i]/bin) * (floor(numberofcolumns[i]/bin)-1)*2)/U=(channel1 + (channel2-1)*channel1/2) output_corr[i]
				DeleteFile output_int[i]
				DeleteFile  output_corr[i]
			else
	
				print "linearmode of correlation" 
				if ( LastFrame - FirstFrame < linearpoints)
					print "The suggested number of frames is not sufficient to carry out correlations for the chosen number of points in file numbered " ,i 
					continue
				endif
	
				linear_acf(FolderFileList[i], output_corr[i], output_int[i], FirstFrame, LastFrame, Background_for_program, Bin, linearpoints,w1,w2)
				GBLoadWave/Q/B/A=corr/T={2,2}/W=(floor(numberofrows[i]/bin) * (floor(numberofcolumns[i]/bin)-1)*2)/U=(linearpoints) output_corr[i]
				DeleteFile output_int[i]
				DeleteFile  output_corr[i]
			endif
	
			display_counter = 0
	
	
			for ( 	m =0; m <(floor(numberofrows[i]/bin) * (floor(numberofcolumns[i]/bin)-1)*2); m= m+1)
				graph_name = "corr" + num2str(m)
				graph_rename =basename + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m])
				//Rename $graph_name, $graph_rename
				
				Make/O $graph_rename
				Duplicate/O $graph_name, $graph_rename
				killwaves $graph_name
				
				if(display_counter==0)
					Display/I/W = (7,0.5, 10,3.3) $graph_rename vs lagtime
					display_counter = display_counter+1
				else
					AppendTograph $graph_rename vs lagtime
					display_counter = display_counter + 1
				endif
	
			endfor
			ShowInfo
			ModifyGraph log(bottom)=1
	

			String newtemp1 = "area_value_hor" + num2str(i)
			Make/O/N = (floor(numberofrows[i]/bin) , floor(numberofcolumns[i]/bin)-1) wave_temp_area

			string temp1_2 , temp2_2, temp3_2
	
			if(logarithmiccorrelation == 1)
				Print "The area was calculated upto", lagtime[area_calc ]
				for ( 	m =0; m <(floor(numberofrows[i]/bin) * (floor(numberofcolumns[i]/bin)-1)*2); m= m+2)
					temp1_2=basename + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m])
					temp2_2=basename + "_" + num2str(i) + "_" + num2str(w1[m+1]) + "_" +num2str(w2[m+1])
					temp3_2 = "sub" + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m]) + "_______" +  num2str(w1[m+1]) + "_" +num2str(w2[m+1]) 
					Make/O/D/N =(channel1 + (channel2-1)*8) w1_2
					Wave w1_2 = $temp1_2
					Make/O/D/N = (channel1 + (channel2-1)*8) w2_2
					Wave w2_2 = $temp2_2
					Make/O/D/N=(channel1 + (channel2-1)*8) $temp3_2
					Wave w3_2 = $temp3_2
					w3_2 = (w1_2- w2_2)/(w1_2[1] + w2_2[1]-2)
					wave_temp_area[floor(w1[m]/bin/numberofcolumns[i])][floor(w1[m]/bin) -floor(w1[m]/bin/numberofcolumns[i])*numberofcolumns[i] ] = areaXY(lagtime, w3_2,lagtime[area_calc1 ], lagtime[area_calc ])
				ENDfor
	
			else	
				for ( 	m =0; m <(floor(numberofrows[i]/bin) * (floor(numberofcolumns[i]/bin)-1)*2); m= m+2)
					temp1_2=basename + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m])
					temp2_2=basename + "_" + num2str(i) + "_" + num2str(w1[m+1]) + "_" +num2str(w2[m+1])
					temp3_2 = "sub" + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m]) + "_______" +  num2str(w1[m+1]) + "_" +num2str(w2[m+1]) 
					Make/O/D/N =(channel1 + (channel2-1)*8) w1_2
					Wave w1_2 = $temp1_2
					Make/O/D/N = (channel1 + (channel2-1)*8) w2_2
					Wave w2_2 = $temp2_2
					Make/O/D/N=(channel1 + (channel2-1)*8) $temp3_2
					Wave w3_2 = $temp3_2
					w3_2 = (w1_2- w2_2)
					wave_temp_area[floor(w1[m]/bin/numberofcolumns[i])][floor(w1[m]/bin) -floor(w1[m]/bin/numberofcolumns[i])*numberofcolumns[i] ] = areaXY(lagtime, w3_2,0, lagtime[linearpoints-1 ])
				ENDfor 

			endif
	
			//rename w1, $firstpixel
			Make/O $firstpixel
			Duplicate/O w1, $firstpixel
			killwaves w1
			//rename w2, $secondpixel
			Make/O $secondpixel
			Duplicate/O w2, $secondpixel
			killwaves w2
			//Rename wave_temp_area, $newtemp1
			Make/O $newtemp1
			Duplicate/O wave_temp_area, $newtemp1
			killwaves wave_temp_area
				
			Display/I/W = (0,5, 3,8.5); AppendImage $newtemp1
			ModifyGraph width=151.2,height={Aspect,1}
			ModifyGraph swapXY=1
			SetAxis/A/R left
					
			ColorScale/C/N=text0/F=0/A=MB/E vert=0,lowTrip=0.01, width=87
			ColorScale/C/N=text0 nticks=3	
			
			
			
			
			
			StatsQuantiles/iNaN area_value_hor0
			wavestats area_value_hor0
			Variable bin_h = ceil (V_npnts ^ (1/3) * (V_max - V_min)/2/V_IQR)
			Make/N=(Bin_h)/O area_value_hor0_Hist;DelayUpdate
			//Histogram/B={V_min,(V_max-V_min)/Bin,Bin} 
			//Histogram/B={V_avg - 3* V_sdev,V_sdev*6/Bin,Bin} chisq_0,chisq_0_Hist
			//if (V_avg - 3* V_sdev > 1e-16)
			if (auto_bin ==1)
				Histogram/B={V_avg - 3* V_sdev,V_sdev*6/Bin_h,Bin_h} area_value_hor0,area_value_hor0_hist
				//print V_avg - 3* V_sdev, V_sdev*6/Bin,Bin
			else
				Histogram/B={v_start,v_size,floor((v_end - v_start)/v_size)} area_value_hor0,area_value_hor0_hist
				//print v_start,v_size,floor((v_end - v_start)/v_size)
			endif
			//else
			//Histogram/B={0,V_sdev*6/Bin,Bin}  area_value_hor0,area_value_hor0_hist
			//endif
			Display/W = (0,0.5, 3,3.5)  area_value_hor0_hist
			ModifyGraph width=151.2,height={Aspect,1}
			ModifyGraph mode=5
			ModifyGraph mirror=2
			ModifyGraph useNegRGB=1,usePlusRGB=1,hbFill=2,rgb=(0,0,0);DelayUpdate
			ModifyGraph negRGB=(47872,47872,47872),plusRGB=(47872,47872,47872)
		endif
		/////End of ab -ba
	
		if(V_value_ ==3)
			area_calc = 40
			Prompt area_calc, "Enter area_calc"
			DoPrompt "area_calc", area_calc
			Make/N = ((floor(numberofrows[i]/bin) -1)* (floor(numberofcolumns[i]/bin))*2)/O/D w1
			Make/N = ((floor(numberofrows[i]/bin)-1) * (floor(numberofcolumns[i]/bin))*2)/O/D w2
			l= 0
			for (j = 0; j<(floor(numberofrows[i]/bin)-1); j= j+1)
				for (k = 0; k<(floor(numberofcolumns[i]/bin)); k= k+1)
					w1[l] = j*numberofcolumns[i]*bin + k*bin
					w2[l] = (j+1)*numberofcolumns[i]*bin + k*bin 
					l = l+1
					w1[l] =(j+1)*numberofcolumns[i]*bin + k*bin 
					w2[l] = j*numberofcolumns[i]*bin + k*bin
					l= l+1
				Endfor
			Endfor
	
	
			firstpixel = "firstpixel_ver" + num2str(i)
			secondpixel = "secondpixel_ver" + num2str(i)
			if(logarithmiccorrelation == 1)
	
				if ( LastFrame - FirstFrame < lagtime_check[ (channel1 + (channel2-1)*channel1/2)-1])
					print "The suggested number of frames is not sufficient to carry out correlations for the chosen number of channels in file numbered", i
					continue
				endif
	
				tif_program(FolderFileList[i], output_corr[i], output_int[i], FirstFrame, LastFrame, Background_for_program, Bin, channel1, channel2,w1,w2)
				GBLoadWave/Q/B/A=corr/T={2,2}/W=((floor(numberofrows[i]/bin) -1)* (floor(numberofcolumns[i]/bin))*2)/U=(channel1 + (channel2-1)*channel1/2) output_corr[i]
				DeleteFile output_int[i]
				DeleteFile  output_corr[i]
			else
	
				print "linearmode of correlation" 
				if ( LastFrame - FirstFrame < linearpoints)
					print "The suggested number of frames is not sufficient to carry out correlations for the chosen number of points in file numbered " ,i 
					continue
				endif
	
				linear_acf(FolderFileList[i], output_corr[i], output_int[i], FirstFrame, LastFrame, Background_for_program, Bin, linearpoints,w1,w2)
				GBLoadWave/Q/B/A=corr/T={2,2}/W=((floor(numberofrows[i]/bin)-1) * (floor(numberofcolumns[i]/bin))*2)/U=(linearpoints) output_corr[i]
				DeleteFile output_int[i]
				DeleteFile  output_corr[i]
				
			endif
	
			display_counter = 0
	
	
			for ( 	m =0; m <((floor(numberofrows[i]/bin) -1)* (floor(numberofcolumns[i]/bin))*2); m= m+1)
				graph_name = "corr" + num2str(m)
				graph_rename =basename + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m])
				//Rename $graph_name, $graph_rename
				Make/O $graph_rename
				Duplicate/O $graph_name, $graph_rename
				killwaves $graph_name
				if(display_counter==0)
					Display/I/W = (7,0.5, 10,3.3) $graph_rename vs lagtime
					display_counter = display_counter+1
				else
					AppendTograph $graph_rename vs lagtime
					display_counter = display_counter + 1
				endif
	
			endfor
			ModifyGraph log(bottom)=1
	

			newtemp1 = "area_value_ver" + num2str(i)
			Make/O/N = (floor(numberofrows[i]/bin)-1 , floor(numberofcolumns[i]/bin)) wave_temp_area
			//Wave wave_temp_area = $newtemp1

	
			if(logarithmiccorrelation == 1)
	
				for ( 	m =0; m <((floor(numberofrows[i]/bin)-1) * (floor(numberofcolumns[i]/bin))*2); m= m+2)
					temp1_2=basename + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m])
					temp2_2=basename + "_" + num2str(i) + "_" + num2str(w1[m+1]) + "_" +num2str(w2[m+1])
					temp3_2 = "sub" + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m]) + "_______" +  num2str(w1[m+1]) + "_" +num2str(w2[m+1]) 
					Make/O/D/N =(channel1 + (channel2-1)*8) w1_2
					Wave w1_2 = $temp1_2
					Make/O/D/N = (channel1 + (channel2-1)*8) w2_2
					Wave w2_2 = $temp2_2
					Make/O/D/N=(channel1 + (channel2-1)*8) $temp3_2
					Wave w3_2 = $temp3_2
					w3_2 = (w1_2- w2_2)/(w1_2[1] + w2_2[1]-2)
					//'wave_temp_area[floor(w1[m]/bin/numberofcolumns[i])][floor(w1[m]/bin) -floor(w1[m]/bin/numberofcolumns[i])*numberofcolumns[i] ] = areaXY(lagtime, w3_2,0, lagtime[(channel1 + (channel2-1)*8)-1 ])
					wave_temp_area[floor(w1[m]/bin/numberofcolumns[i])][floor(w1[m]/bin) -floor(w1[m]/bin/numberofcolumns[i])*numberofcolumns[i] ] = areaXY(lagtime, w3_2,lagtime[1 ], lagtime[area_calc ])
				
				ENDfor
	
			else
	
				for ( 	m =0; m <((floor(numberofrows[i]/bin)-1) * (floor(numberofcolumns[i]/bin))*2); m= m+2)
					temp1_2=basename + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m])
					temp2_2=basename + "_" + num2str(i) + "_" + num2str(w1[m+1]) + "_" +num2str(w2[m+1])
					temp3_2 = "sub" + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m]) + "_______" +  num2str(w1[m+1]) + "_" +num2str(w2[m+1]) 
					Make/O/D/N =(channel1 + (channel2-1)*8) w1_2
					Wave w1_2 = $temp1_2
					Make/O/D/N = (channel1 + (channel2-1)*8) w2_2
					Wave w2_2 = $temp2_2
					Make/O/D/N=(channel1 + (channel2-1)*8) $temp3_2
					Wave w3_2 = $temp3_2
					w3_2 = (w1_2- w2_2)
					wave_temp_area[floor(w1[m]/bin/numberofcolumns[i])][floor(w1[m]/bin) -floor(w1[m]/bin/numberofcolumns[i])*numberofcolumns[i] ] = areaXY(lagtime, w3_2,0, lagtime[linearpoints-1 ])
				ENDfor 
	
			endif
	
			Make/O $firstpixel
			Duplicate/O w1, $firstpixel
			killwaves w1
			//rename w2, $secondpixel
			Make/O $secondpixel
			Duplicate/O w2, $secondpixel
			killwaves w2
			//Rename wave_temp_area, $newtemp1
			Make/O $newtemp1
			Duplicate/O wave_temp_area, $newtemp1
			killwaves wave_temp_area
				
			Display/I/W = (0,5, 3,8.5); AppendImage $newtemp1
			ModifyGraph width=151.2,height={Aspect,1}
			ModifyGraph swapXY=1
			SetAxis/A/R left
					
			ColorScale/C/N=text0/F=0/A=MB/E vert=0,lowTrip=0.01, width=87
			ColorScale/C/N=text0 nticks=3	
		endif
			
	
		if(V_value_ ==4)
			area_calc = 40
			Prompt area_calc, "Enter area_calc"
			DoPrompt "area_calc", area_calc
			firstpixel = "firstpixel_hor" + num2str(i)
			secondpixel = "secondpixel_hor" + num2str(i)
	
			Make/N = (floor(numberofrows[i]/bin) * (floor(numberofcolumns[i]/bin)-1)*2)/O/D w1
			Make/N = (floor(numberofrows[i]/bin) * (floor(numberofcolumns[i]/bin)-1)*2)/O/D w2
			l= 0
			for (j = 0; j<(floor(numberofrows[i]/bin)); j= j+1)
				for (k = 0; k<(floor(numberofcolumns[i]/bin)-1); k= k+1)
					w1[l] = j*numberofcolumns[i]*bin + k*bin
					w2[l] = j*numberofcolumns[i]*bin + k*bin + bin
					l = l+1
					w1[l] =j*numberofcolumns[i]*bin + k*bin + bin
					w2[l] = j*numberofcolumns[i]*bin + k*bin
					l= l+1
				Endfor
			Endfor
	
	
	
			if(logarithmiccorrelation == 1)
	
				if ( LastFrame - FirstFrame < lagtime_check[ (channel1 + (channel2-1)*channel1/2)-1])
					print "The suggested number of frames is not sufficient to carry out correlations for the chosen number of channels in file numbered", i
					continue
				endif
	
				tif_program(FolderFileList[i], output_corr[i], output_int[i], FirstFrame, LastFrame, Background_for_program, Bin, channel1, channel2,w1,w2)
				GBLoadWave/Q/B/A=corr/T={2,2}/W=(floor(numberofrows[i]/bin) * (floor(numberofcolumns[i]/bin)-1)*2)/U=(channel1 + (channel2-1)*channel1/2) output_corr[i]
				DeleteFile output_int[i]
				DeleteFile  output_corr[i]
			else
	
				print "linearmode of correlation" 
				if ( LastFrame - FirstFrame < linearpoints)
					print "The suggested number of frames is not sufficient to carry out correlations for the chosen number of points in file numbered " ,i 
					continue
				endif
	
				linear_acf(FolderFileList[i], output_corr[i], output_int[i], FirstFrame, LastFrame, Background_for_program, Bin, linearpoints,w1,w2)
				GBLoadWave/Q/B/A=corr/T={2,2}/W=(floor(numberofrows[i]/bin) * (floor(numberofcolumns[i]/bin)-1)*2)/U=(linearpoints) output_corr[i]
				DeleteFile output_int[i]
				DeleteFile  output_corr[i]
			endif
	
			display_counter = 0
	
	
			for ( 	m =0; m <(floor(numberofrows[i]/bin) * (floor(numberofcolumns[i]/bin)-1)*2); m= m+1)
				graph_name = "corr" + num2str(m)
				graph_rename =basename + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m])
				//Rename $graph_name, $graph_rename
				Make/O $graph_rename
				Duplicate/O $graph_name, $graph_rename
				killwaves $graph_name
				if(display_counter==0)
					Display/I/W = (7,0.5, 10,3.3) $graph_rename vs lagtime
					display_counter = display_counter+1
				else
					AppendTograph $graph_rename vs lagtime
					display_counter = display_counter + 1
				endif
	
			endfor
			ModifyGraph log(bottom)=1
	

			newtemp1 = "area_value_hor" + num2str(i)
			Make/O/N = (floor(numberofrows[i]/bin) , floor(numberofcolumns[i]/bin)-1) wave_temp_area


	
			if(logarithmiccorrelation == 1)
	
				for ( 	m =0; m <(floor(numberofrows[i]/bin) * (floor(numberofcolumns[i]/bin)-1)*2); m= m+2)
					temp1_2=basename + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m])
					temp2_2=basename + "_" + num2str(i) + "_" + num2str(w1[m+1]) + "_" +num2str(w2[m+1])
					temp3_2 = "sub" + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m]) + "_______" +  num2str(w1[m+1]) + "_" +num2str(w2[m+1]) 
					Make/O/D/N =(channel1 + (channel2-1)*8) w1_2
					Wave w1_2 = $temp1_2
					Make/O/D/N = (channel1 + (channel2-1)*8) w2_2
					Wave w2_2 = $temp2_2
					Make/O/D/N=(channel1 + (channel2-1)*8) $temp3_2
					Wave w3_2 = $temp3_2
					w3_2 = (w1_2- w2_2)/(w1_2[1] + w2_2[1]-2)
					wave_temp_area[floor(w1[m]/bin/numberofcolumns[i])][floor(w1[m]/bin) -floor(w1[m]/bin/numberofcolumns[i])*numberofcolumns[i] ] = areaXY(lagtime, w3_2,lagtime[1 ], lagtime[area_calc ])
				ENDfor
	
			else
	
				for ( 	m =0; m <(floor(numberofrows[i]/bin) * (floor(numberofcolumns[i]/bin)-1)*2); m= m+2)
					temp1_2=basename + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m])
					temp2_2=basename + "_" + num2str(i) + "_" + num2str(w1[m+1]) + "_" +num2str(w2[m+1])
					temp3_2 = "sub" + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m]) + "_______" +  num2str(w1[m+1]) + "_" +num2str(w2[m+1]) 
					Make/O/D/N =(channel1 + (channel2-1)*8) w1_2
					Wave w1_2 = $temp1_2
					Make/O/D/N = (channel1 + (channel2-1)*8) w2_2
					Wave w2_2 = $temp2_2
					Make/O/D/N=(channel1 + (channel2-1)*8) $temp3_2
					Wave w3_2 = $temp3_2
					w3_2 = (w1_2- w2_2)
					wave_temp_area[floor(w1[m]/bin/numberofcolumns[i])][floor(w1[m]/bin) -floor(w1[m]/bin/numberofcolumns[i])*numberofcolumns[i] ] = areaXY(lagtime, w3_2,0, lagtime[linearpoints-1 ])
				ENDfor 

			endif 

			Make/O $firstpixel
			Duplicate/O w1, $firstpixel
			killwaves w1
			//rename w2, $secondpixel
			Make/O $secondpixel
			Duplicate/O w2, $secondpixel
			killwaves w2
			//Rename wave_temp_area, $newtemp1
			Make/O $newtemp1
			Duplicate/O wave_temp_area, $newtemp1
			killwaves wave_temp_area
				
			Display/I/W = (0,5, 3,8.5); AppendImage $newtemp1
			ModifyGraph width=151.2,height={Aspect,1}
			ModifyGraph swapXY=1
			SetAxis/A/R left
					
			ColorScale/C/N=text0/F=0/A=MB/E vert=0,lowTrip=0.01, width=87
			ColorScale/C/N=text0 nticks=3	

			firstpixel = "firstpixel_ver" + num2str(i)
			secondpixel = "secondpixel_ver" + num2str(i)
	
			Make/N = ((floor(numberofrows[i]/bin) -1)* (floor(numberofcolumns[i]/bin))*2)/O/D w1
			Make/N = ((floor(numberofrows[i]/bin)-1) * (floor(numberofcolumns[i]/bin))*2)/O/D w2
			l= 0
			for (j = 0; j<(floor(numberofrows[i]/bin)-1); j= j+1)
				for (k = 0; k<(floor(numberofcolumns[i]/bin)); k= k+1)
					w1[l] = j*numberofcolumns[i]*bin + k*bin
					w2[l] = (j+1)*numberofcolumns[i]*bin + k*bin 
					l = l+1
					w1[l] =(j+1)*numberofcolumns[i]*bin + k*bin 
					w2[l] = j*numberofcolumns[i]*bin + k*bin
					l= l+1
				Endfor
			Endfor
	
	
	
			if(logarithmiccorrelation == 1)
	
				if ( LastFrame - FirstFrame < lagtime_check[ (channel1 + (channel2-1)*channel1/2)-1])
					print "The suggested number of frames is not sufficient to carry out correlations for the chosen number of channels in file numbered", i
					continue
				endif
	
				tif_program(FolderFileList[i], output_corr[i], output_int[i], FirstFrame, LastFrame, Background_for_program, Bin, channel1, channel2,w1,w2)
				GBLoadWave/Q/B/A=corr/T={2,2}/W=((floor(numberofrows[i]/bin) -1)* (floor(numberofcolumns[i]/bin))*2)/U=(channel1 + (channel2-1)*channel1/2) output_corr[i]
				DeleteFile output_int[i]
				DeleteFile  output_corr[i]
			else
	
				print "linearmode of correlation" 
				if ( LastFrame - FirstFrame < linearpoints)
					print "The suggested number of frames is not sufficient to carry out correlations for the chosen number of points in file numbered " ,i 
					continue
				endif
	
				linear_acf(FolderFileList[i], output_corr[i], output_int[i], FirstFrame, LastFrame, Background_for_program, Bin, linearpoints,w1,w2)
				GBLoadWave/Q/B/A=corr/T={2,2}/W=((floor(numberofrows[i]/bin)-1) * (floor(numberofcolumns[i]/bin))*2)/U=(linearpoints) output_corr[i]
				DeleteFile output_int[i]
				DeleteFile  output_corr[i]
			endif
	
			display_counter = 0
	
	
			for ( 	m =0; m <((floor(numberofrows[i]/bin) -1)* (floor(numberofcolumns[i]/bin))*2); m= m+1)
				graph_name = "corr" + num2str(m)
				graph_rename =basename + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m])
				//Rename $graph_name, $graph_rename
				Make/O $graph_rename
				Duplicate/O $graph_name, $graph_rename
				killwaves $graph_name
				
				if(display_counter==0)
					Display/I/W = (3.5, 5,6.5, 7.8) $graph_rename vs lagtime
					display_counter = display_counter+1
				else
					AppendTograph $graph_rename vs lagtime
					display_counter = display_counter + 1
				endif
	
			endfor
			ModifyGraph log(bottom)=1
	

			newtemp1 = "area_value_ver" + num2str(i)
			Make/O/N = (floor(numberofrows[i]/bin)-1 , floor(numberofcolumns[i]/bin)) wave_temp_area
			//	Wave wave_temp_area = $newtemp1

	
			if(logarithmiccorrelation == 1)
	
				for ( 	m =0; m <((floor(numberofrows[i]/bin)-1) * (floor(numberofcolumns[i]/bin))*2); m= m+2)
					temp1_2=basename + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m])
					temp2_2=basename + "_" + num2str(i) + "_" + num2str(w1[m+1]) + "_" +num2str(w2[m+1])
					temp3_2 = "sub" + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m]) + "_______" +  num2str(w1[m+1]) + "_" +num2str(w2[m+1]) 
					Make/O/D/N =(channel1 + (channel2-1)*8) w1_2
					Wave w1_2 = $temp1_2
					Make/O/D/N = (channel1 + (channel2-1)*8) w2_2
					Wave w2_2 = $temp2_2
					Make/O/D/N=(channel1 + (channel2-1)*8) $temp3_2
					Wave w3_2 = $temp3_2
					w3_2 = (w1_2- w2_2)/(w1_2[1] + w2_2[1]-2)
					wave_temp_area[floor(w1[m]/bin/numberofcolumns[i])][floor(w1[m]/bin) -floor(w1[m]/bin/numberofcolumns[i])*numberofcolumns[i] ] = areaXY(lagtime, w3_2,lagtime[1 ], lagtime[area_calc ])
				ENDfor
	
			else
	
				for ( 	m =0; m <((floor(numberofrows[i]/bin)-1) * (floor(numberofcolumns[i]/bin))*2); m= m+2)
					temp1_2=basename + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m])
					temp2_2=basename + "_" + num2str(i) + "_" + num2str(w1[m+1]) + "_" +num2str(w2[m+1])
					temp3_2 = "sub" + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m]) + "_______" +  num2str(w1[m+1]) + "_" +num2str(w2[m+1]) 
					Make/O/D/N =(channel1 + (channel2-1)*8) w1_2
					Wave w1_2 = $temp1_2
					Make/O/D/N = (channel1 + (channel2-1)*8) w2_2
					Wave w2_2 = $temp2_2
					Make/O/D/N=(channel1 + (channel2-1)*8) $temp3_2
					Wave w3_2 = $temp3_2
					w3_2 = (w1_2- w2_2)
					wave_temp_area[floor(w1[m]/bin/numberofcolumns[i])][floor(w1[m]/bin) -floor(w1[m]/bin/numberofcolumns[i])*numberofcolumns[i] ] = areaXY(lagtime, w3_2,0, lagtime[linearpoints-1 ])
				ENDfor 
	
			endif
	
			Make/O $firstpixel
			Duplicate/O w1, $firstpixel
			killwaves w1
			//rename w2, $secondpixel
			Make/O $secondpixel
			Duplicate/O w2, $secondpixel
			killwaves w2
			//Rename wave_temp_area, $newtemp1
			Make/O $newtemp1
			Duplicate/O wave_temp_area, $newtemp1
			killwaves wave_temp_area
				
			Display/I/W = (7,5,10,8.5); AppendImage $newtemp1
			ModifyGraph width=151.2,height={Aspect,1}
			ModifyGraph swapXY=1
			SetAxis/A/R left
					
			ColorScale/C/N=text0/F=0/A=MB/E vert=0,lowTrip=0.01, width=87
			ColorScale/C/N=text0 nticks=3	
		endif
	
	
		if(V_value_ ==5)
		
			area_calc = 40
			Prompt area_calc, "Enter area_calc"
			DoPrompt "area_calc", area_calc
	
			Make/N = ((floor(numberofrows[i]/bin) -1)* (floor(numberofcolumns[i]/bin)-1)*2)/O/D w1
			Make/N = ((floor(numberofrows[i]/bin)-1) * (floor(numberofcolumns[i]/bin)-1)*2)/O/D w2
			l= 0
			for (j = 0; j<(floor(numberofrows[i]/bin)-1); j= j+1)
				for (k = 1; k<(floor(numberofcolumns[i]/bin)); k= k+1)
					w1[l] = j*numberofcolumns[i]*bin + k*bin
					w2[l] = (j)*numberofcolumns[i]*bin + k*bin + (numberofcolumns[i]-1)*bin
					l = l+1
					w1[l] =(j)*numberofcolumns[i]*bin + k*bin + (numberofcolumns[i]-1)*bin
					w2[l] = j*numberofcolumns[i]*bin + k*bin
					l= l+1
				Endfor
			Endfor
	
	
	
			if(logarithmiccorrelation == 1)
	
				if ( LastFrame - FirstFrame < lagtime_check[ (channel1 + (channel2-1)*channel1/2)-1])
					print "The suggested number of frames is not sufficient to carry out correlations for the chosen number of channels in file numbered", i
					continue
				endif
	
				tif_program(FolderFileList[i], output_corr[i], output_int[i], FirstFrame, LastFrame, Background_for_program, Bin, channel1, channel2,w1,w2)
				GBLoadWave/Q/B/A=corr/T={2,2}/W=((floor(numberofrows[i]/bin) -1)* (floor(numberofcolumns[i]/bin)-1)*2)/U=(channel1 + (channel2-1)*channel1/2) output_corr[i]
				DeleteFile output_int[i]
				DeleteFile  output_corr[i]
			else
	
				print "linearmode of correlation" 
				if ( LastFrame - FirstFrame < linearpoints)
					print "The suggested number of frames is not sufficient to carry out correlations for the chosen number of points in file numbered " ,i 
					continue
				endif
	
				linear_acf(FolderFileList[i], output_corr[i], output_int[i], FirstFrame, LastFrame, Background_for_program, Bin, linearpoints,w1,w2)
				GBLoadWave/Q/B/A=corr/T={2,2}/W=((floor(numberofrows[i]/bin)-1) * (floor(numberofcolumns[i]/bin)-1)*2)/U=(linearpoints) output_corr[i]
				DeleteFile output_int[i]
				DeleteFile  output_corr[i]
			endif
	
			display_counter = 0
	
	
			for ( 	m =0; m <((floor(numberofrows[i]/bin) -1)* (floor(numberofcolumns[i]/bin)-1)*2); m= m+1)
				graph_name = "corr" + num2str(m)
				graph_rename =basename + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m])
				//Rename $graph_name, $graph_rename
				Make/O $graph_rename
				Duplicate/O $graph_name, $graph_rename
				killwaves $graph_name
				if(display_counter==0)
					Display/I/W = (7,0.5, 10,3.3) $graph_rename vs lagtime
					display_counter = display_counter+1
				else
					AppendTograph $graph_rename vs lagtime
					display_counter = display_counter + 1
				endif
	
			endfor
			ModifyGraph log(bottom)=1
	

			newtemp1 = "area_value" + num2str(i)
			Make/O/N = (floor(numberofrows[i]/bin)-1 , floor(numberofcolumns[i]/bin)-1) wave_temp_area
			Wave wave_temp_area = $newtemp1

	
			if(logarithmiccorrelation == 1)
	
				for ( 	m =0; m <((floor(numberofrows[i]/bin)-1) * (floor(numberofcolumns[i]/bin)-1)*2); m= m+2)
					temp1_2=basename + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m])
					temp2_2=basename + "_" + num2str(i) + "_" + num2str(w1[m+1]) + "_" +num2str(w2[m+1])
					temp3_2 = "sub" + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m]) + "_______" +  num2str(w1[m+1]) + "_" +num2str(w2[m+1]) 
					Make/O/D/N =(channel1 + (channel2-1)*8) w1_2
					Wave w1_2 = $temp1_2
					Make/O/D/N = (channel1 + (channel2-1)*8) w2_2
					Wave w2_2 = $temp2_2
					Make/O/D/N=(channel1 + (channel2-1)*8) $temp3_2
					Wave w3_2 = $temp3_2
					w3_2 = (w1_2- w2_2)/(w1_2[1] + w2_2[1]-2)
					wave_temp_area[floor(w1[m]/bin/numberofcolumns[i])][floor(w1[m]/bin) -floor(w1[m]/bin/numberofcolumns[i])*numberofcolumns[i]-1 ] = areaXY(lagtime, w3_2,0, lagtime[area_calc ])
				ENDfor
	
			else
	
				for ( 	m =0; m <((floor(numberofrows[i]/bin)-1) * (floor(numberofcolumns[i]/bin)-1)*2); m= m+2)
					temp1_2=basename + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m])
					temp2_2=basename + "_" + num2str(i) + "_" + num2str(w1[m+1]) + "_" +num2str(w2[m+1])
					temp3_2 = "sub" + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m]) + "_______" +  num2str(w1[m+1]) + "_" +num2str(w2[m+1]) 
					Make/O/D/N =(channel1 + (channel2-1)*8) w1_2
					Wave w1_2 = $temp1_2
					Make/O/D/N = (channel1 + (channel2-1)*8) w2_2
					Wave w2_2 = $temp2_2
					Make/O/D/N=(channel1 + (channel2-1)*8) $temp3_2
					Wave w3_2 = $temp3_2
					w3_2 = (w1_2- w2_2)
					wave_temp_area[floor(w1[m]/bin/numberofcolumns[i])][floor(w1[m]/bin) -floor(w1[m]/bin/numberofcolumns[i])*numberofcolumns[i]-1 ] = areaXY(lagtime, w3_2,0, lagtime[linearpoints-1 ])
				ENDfor 
	
			endif
			
			Display/I/W = (0,5, 3,8.5); AppendImage wave_temp_area
			ModifyGraph width=151.2,height={Aspect,1}
			ModifyGraph swapXY=1
			SetAxis/A/R left
					
			ColorScale/C/N=text0/F=0/A=MB/E vert=0,lowTrip=0.01, width=87
			ColorScale/C/N=text0 nticks=3	
	
			make/o $firstpixel
			Duplicate/O w1,$firstpixel
			KillWaves w1	 
			//rename w2, $secondpixel
			make/o $secondpixel
			Duplicate/O w2,$secondpixel
			KillWaves w2
			Rename wave_temp_area, $newtemp1
			
		endif
	
		if(V_value_ ==6)
	
			area_calc = 40
			Prompt area_calc, "Enter area_calc"
			DoPrompt "area_calc", area_calc
	
			firstpixel = "firstpixel_135_" + num2str(i)
			secondpixel = "secondpixel_135_" + num2str(i)
	
			Make/N = ((floor(numberofrows[i]/bin) -1)* (floor(numberofcolumns[i]/bin)-1)*2)/O/D w1
			Make/N = ((floor(numberofrows[i]/bin)-1) * (floor(numberofcolumns[i]/bin)-1)*2)/O/D w2
			l= 0
			for (j = 0; j<(floor(numberofrows[i]/bin)-1); j= j+1)
				for (k = 0; k<(floor(numberofcolumns[i]/bin)-1); k= k+1)
					w1[l] = j*numberofcolumns[i]*bin + k*bin
					w2[l] = (j)*numberofcolumns[i]*bin + k*bin + (numberofcolumns[i]+1)*bin
					l = l+1
					w1[l] =(j)*numberofcolumns[i]*bin + k*bin + (numberofcolumns[i]+1)*bin
					w2[l] = j*numberofcolumns[i]*bin + k*bin
					l= l+1
				Endfor
			Endfor
	
	
	
			if(logarithmiccorrelation == 1)
	
				if ( LastFrame - FirstFrame < lagtime_check[ (channel1 + (channel2-1)*channel1/2)-1])
					print "The suggested number of frames is not sufficient to carry out correlations for the chosen number of channels in file numbered", i
					continue
				endif
	
				tif_program(FolderFileList[i], output_corr[i], output_int[i], FirstFrame, LastFrame, Background_for_program, Bin, channel1, channel2,w1,w2)
				GBLoadWave/Q/B/A=corr/T={2,2}/W=((floor(numberofrows[i]/bin) -1)* (floor(numberofcolumns[i]/bin)-1)*2)/U=(channel1 + (channel2-1)*channel1/2) output_corr[i]
				DeleteFile output_int[i]
				DeleteFile  output_corr[i]
			else
	
				print "linearmode of correlation" 
				if ( LastFrame - FirstFrame < linearpoints)
					print "The suggested number of frames is not sufficient to carry out correlations for the chosen number of points in file numbered " ,i 
					continue
				endif
	
				linear_acf(FolderFileList[i], output_corr[i], output_int[i], FirstFrame, LastFrame, Background_for_program, Bin, linearpoints,w1,w2)
				GBLoadWave/Q/B/A=corr/T={2,2}/W=((floor(numberofrows[i]/bin)-1) * (floor(numberofcolumns[i]/bin)-1)*2)/U=(linearpoints) output_corr[i]
				DeleteFile output_int[i]
				DeleteFile  output_corr[i]
			endif
	
			display_counter = 0
	
	
			for ( 	m =0; m <((floor(numberofrows[i]/bin) -1)* (floor(numberofcolumns[i]/bin)-1)*2); m= m+1)
				graph_name = "corr" + num2str(m)
				graph_rename =basename + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m])
				Rename $graph_name, $graph_rename
				if(display_counter==0)
					Display/I/W = (7,0.5, 10,3.3) $graph_rename vs lagtime
					display_counter = display_counter+1
				else
					AppendTograph $graph_rename vs lagtime
					display_counter = display_counter + 1
				endif
	
			endfor
			ModifyGraph log(bottom)=1
	

			newtemp1 = "area_value_135_" + num2str(i)
			Make/O/N = (floor(numberofrows[i]/bin)-1 , floor(numberofcolumns[i]/bin)-1) wave_temp_area_135
			Wave wave_temp_area_135 = $newtemp1

	
			if(logarithmiccorrelation == 1)
	
				for ( 	m =0; m <((floor(numberofrows[i]/bin)-1) * (floor(numberofcolumns[i]/bin)-1)*2); m= m+2)
					temp1_2=basename + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m])
					temp2_2=basename + "_" + num2str(i) + "_" + num2str(w1[m+1]) + "_" +num2str(w2[m+1])
					temp3_2 = "sub" + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m]) + "_______" +  num2str(w1[m+1]) + "_" +num2str(w2[m+1]) 
					Make/O/D/N =(channel1 + (channel2-1)*8) w1_2
					Wave w1_2 = $temp1_2
					Make/O/D/N = (channel1 + (channel2-1)*8) w2_2
					Wave w2_2 = $temp2_2
					Make/O/D/N=(channel1 + (channel2-1)*8) $temp3_2
					Wave w3_2 = $temp3_2
					w3_2 = (w1_2- w2_2)/(w1_2[1] + w2_2[1]-2)
					wave_temp_area_135[floor(w1[m]/bin/numberofcolumns[i])][floor(w1[m]/bin) -floor(w1[m]/bin/numberofcolumns[i])*numberofcolumns[i] ] = areaXY(lagtime, w3_2,0, lagtime[area_calc ])
				ENDfor
	
			else
	
				for ( 	m =0; m <((floor(numberofrows[i]/bin)-1) * (floor(numberofcolumns[i]/bin)-1)*2); m= m+2)
					temp1_2=basename + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m])
					temp2_2=basename + "_" + num2str(i) + "_" + num2str(w1[m+1]) + "_" +num2str(w2[m+1])
					temp3_2 = "sub" + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m]) + "_______" +  num2str(w1[m+1]) + "_" +num2str(w2[m+1]) 
					Make/O/D/N =(channel1 + (channel2-1)*8) w1_2
					Wave w1_2 = $temp1_2
					Make/O/D/N = (channel1 + (channel2-1)*8) w2_2
					Wave w2_2 = $temp2_2
					Make/O/D/N=(channel1 + (channel2-1)*8) $temp3_2
					Wave w3_2 = $temp3_2
					w3_2 = (w1_2- w2_2)
					wave_temp_area_135[floor(w1[m]/bin/numberofcolumns[i])][floor(w1[m]/bin) -floor(w1[m]/bin/numberofcolumns[i])*numberofcolumns[i] ] = areaXY(lagtime, w3_2,0, lagtime[linearpoints-1 ])
				ENDfor 
	
			endif
		
			Display/I/W = (0,5, 3,8.5); AppendImage wave_temp_area_135
			ModifyGraph width=151.2,height={Aspect,1}
			ModifyGraph swapXY=1
			SetAxis/A/R left
					
			ColorScale/C/N=text0/F=0/A=MB/E vert=0,lowTrip=0.01, width=87
			ColorScale/C/N=text0 nticks=3	
	
	
			rename w1, $firstpixel
			rename w2, $secondpixel
			Rename wave_temp_area_135, $newtemp1
		endif
	
		if(V_value_ ==7)
	
			area_calc = 40
			Prompt area_calc, "Enter area_calc"
			DoPrompt "area_calc", area_calc
	
			firstpixel = "firstpixel_45_" + num2str(i)
			secondpixel = "secondpixel_45_" + num2str(i)
	
			Make/N = ((floor(numberofrows[i]/bin) -1)* (floor(numberofcolumns[i]/bin)-1)*2)/O/D w1
			Make/N = ((floor(numberofrows[i]/bin)-1) * (floor(numberofcolumns[i]/bin)-1)*2)/O/D w2
			l= 0
			for (j = 0; j<(floor(numberofrows[i]/bin)-1); j= j+1)
				for (k = 1; k<(floor(numberofcolumns[i]/bin)); k= k+1)
					w1[l] = j*numberofcolumns[i]*bin + k*bin
					w2[l] = (j)*numberofcolumns[i]*bin + k*bin + (numberofcolumns[i]-1)*bin
					l = l+1
					w1[l] =(j)*numberofcolumns[i]*bin + k*bin + (numberofcolumns[i]-1)*bin
					w2[l] = j*numberofcolumns[i]*bin + k*bin
					l= l+1                                                                                       
				Endfor
			Endfor
	
	
	
			if(logarithmiccorrelation == 1)
	
				if ( LastFrame - FirstFrame < lagtime_check[ (channel1 + (channel2-1)*channel1/2)-1])
					print "The suggested number of frames is not sufficient to carry out correlations for the chosen number of channels in file numbered", i
					continue
				endif
	
				tif_program(FolderFileList[i], output_corr[i], output_int[i], FirstFrame, LastFrame, Background_for_program, Bin, channel1, channel2,w1,w2)
				GBLoadWave/Q/B/A=corr/T={2,2}/W=((floor(numberofrows[i]/bin) -1)* (floor(numberofcolumns[i]/bin)-1)*2)/U=(channel1 + (channel2-1)*channel1/2) output_corr[i]
				DeleteFile output_int[i]
				DeleteFile  output_corr[i]
			else
	
				print "linearmode of correlation" 
				if ( LastFrame - FirstFrame < linearpoints)
					print "The suggested number of frames is not sufficient to carry out correlations for the chosen number of points in file numbered " ,i 
					continue
				endif
	
				linear_acf(FolderFileList[i], output_corr[i], output_int[i], FirstFrame, LastFrame, Background_for_program, Bin, linearpoints,w1,w2)
				GBLoadWave/Q/B/A=corr/T={2,2}/W=((floor(numberofrows[i]/bin)-1) * (floor(numberofcolumns[i]/bin)-1)*2)/U=(linearpoints) output_corr[i]
				DeleteFile output_int[i]
				DeleteFile  output_corr[i]
			endif
	
			display_counter = 0 
	
	
			for ( 	m =0; m <((floor(numberofrows[i]/bin) -1)* (floor(numberofcolumns[i]/bin)-1)*2); m= m+1)
				graph_name = "corr" + num2str(m)
				graph_rename =basename + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m])
				Rename $graph_name, $graph_rename
				if(display_counter==0)
					Display/I/W = (7,0.5, 10,3.3) $graph_rename vs lagtime
					display_counter = display_counter+1
				else
					AppendTograph $graph_rename vs lagtime
					display_counter = display_counter + 1
				endif
	
			endfor
			ModifyGraph log(bottom)=1
	

			newtemp1 = "area_value_45_" + num2str(i)
			Make/O/N = (floor(numberofrows[i]/bin)-1 , floor(numberofcolumns[i]/bin)-1) wave_temp_area_45
			Wave wave_temp_area_45 = $newtemp1

	
			if(logarithmiccorrelation == 1)
	
				for ( 	m =0; m <((floor(numberofrows[i]/bin)-1) * (floor(numberofcolumns[i]/bin)-1)*2); m= m+2)
					temp1_2=basename + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m])
					temp2_2=basename + "_" + num2str(i) + "_" + num2str(w1[m+1]) + "_" +num2str(w2[m+1])
					temp3_2 = "sub" + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m]) + "_______" +  num2str(w1[m+1]) + "_" +num2str(w2[m+1]) 
					Make/O/D/N =(channel1 + (channel2-1)*8) w1_2
					Wave w1_2 = $temp1_2
					Make/O/D/N = (channel1 + (channel2-1)*8) w2_2
					Wave w2_2 = $temp2_2
					Make/O/D/N=(channel1 + (channel2-1)*8) $temp3_2
					Wave w3_2 = $temp3_2
					w3_2 = (w1_2- w2_2)/(w1_2[1] + w2_2[1]-2)
					wave_temp_area_45[floor(w1[m]/bin/numberofcolumns[i])][floor(w1[m]/bin) -floor(w1[m]/bin/numberofcolumns[i])*numberofcolumns[i]-1 ] = areaXY(lagtime, w3_2,0, lagtime[area_calc])
				ENDfor
	
			else
	
				for ( 	m =0; m <((floor(numberofrows[i]/bin)-1) * (floor(numberofcolumns[i]/bin)-1)*2); m= m+2)
					temp1_2=basename + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m])
					temp2_2=basename + "_" + num2str(i) + "_" + num2str(w1[m+1]) + "_" +num2str(w2[m+1])
					temp3_2 = "sub" + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m]) + "_______" +  num2str(w1[m+1]) + "_" +num2str(w2[m+1]) 
					Make/O/D/N =(channel1 + (channel2-1)*8) w1_2
					Wave w1_2 = $temp1_2
					Make/O/D/N = (channel1 + (channel2-1)*8) w2_2
					Wave w2_2 = $temp2_2
					Make/O/D/N=(channel1 + (channel2-1)*8) $temp3_2
					Wave w3_2 = $temp3_2
					w3_2 = (w1_2- w2_2)
					wave_temp_area_45[floor(w1[m]/bin/numberofcolumns[i])][floor(w1[m]/bin) -floor(w1[m]/bin/numberofcolumns[i])*numberofcolumns[i]-1 ] = areaXY(lagtime, w3_2,0, lagtime[linearpoints-1 ])
				ENDfor 
	
			endif
	
			Display/I/W = (0,5, 3,8.5); AppendImage wave_temp_area_45
			ModifyGraph width=151.2,height={Aspect,1}
			ModifyGraph swapXY=1
			SetAxis/A/R left
					
			ColorScale/C/N=text0/F=0/A=MB/E vert=0,lowTrip=0.01, width=87
			ColorScale/C/N=text0 nticks=3	
	
			rename w1, $firstpixel
			rename w2, $secondpixel
			Rename wave_temp_area_45, $newtemp1
	
			firstpixel = "firstpixel_135_" + num2str(i)
			secondpixel = "secondpixel_135_" + num2str(i)
	
			Make/N = ((floor(numberofrows[i]/bin) -1)* (floor(numberofcolumns[i]/bin)-1)*2)/O/D w1
			Make/N = ((floor(numberofrows[i]/bin)-1) * (floor(numberofcolumns[i]/bin)-1)*2)/O/D w2
			l= 0
			for (j = 0; j<(floor(numberofrows[i]/bin)-1); j= j+1)
				for (k = 0; k<(floor(numberofcolumns[i]/bin)-1); k= k+1)
					w1[l] = j*numberofcolumns[i]*bin + k*bin
					w2[l] = (j)*numberofcolumns[i]*bin + k*bin + (numberofcolumns[i]+1)*bin
					l = l+1
					w1[l] =(j)*numberofcolumns[i]*bin + k*bin + (numberofcolumns[i]+1)*bin
					w2[l] = j*numberofcolumns[i]*bin + k*bin
					l= l+1
				Endfor
			Endfor
	
	
	
			if(logarithmiccorrelation == 1)
	
				if ( LastFrame - FirstFrame < lagtime_check[ (channel1 + (channel2-1)*channel1/2)-1])
					print "The suggested number of frames is not sufficient to carry out correlations for the chosen number of channels in file numbered", i
					continue
				endif
	
				tif_program(FolderFileList[i], output_corr[i], output_int[i], FirstFrame, LastFrame, Background_for_program, Bin, channel1, channel2,w1,w2)
				GBLoadWave/Q/B/A=corr/T={2,2}/W=((floor(numberofrows[i]/bin) -1)* (floor(numberofcolumns[i]/bin)-1)*2)/U=(channel1 + (channel2-1)*channel1/2) output_corr[i]
				DeleteFile output_int[i]
				DeleteFile  output_corr[i]
			else
	
				print "linearmode of correlation" 
				if ( LastFrame - FirstFrame < linearpoints)
					print "The suggested number of frames is not sufficient to carry out correlations for the chosen number of points in file numbered " ,i 
					continue
				endif
	
				linear_acf(FolderFileList[i], output_corr[i], output_int[i], FirstFrame, LastFrame, Background_for_program, Bin, linearpoints,w1,w2)
				GBLoadWave/Q/B/A=corr/T={2,2}/W=((floor(numberofrows[i]/bin)-1) * (floor(numberofcolumns[i]/bin)-1)*2)/U=(linearpoints) output_corr[i]
				DeleteFile output_int[i]
				DeleteFile  output_corr[i]
			endif
	
			display_counter = 0
	
	
			for ( 	m =0; m <((floor(numberofrows[i]/bin) -1)* (floor(numberofcolumns[i]/bin)-1)*2); m= m+1)
				graph_name = "corr" + num2str(m)
				graph_rename =basename + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m])
				Rename $graph_name, $graph_rename
				if(display_counter==0)
					Display/I/W = (3.5, 5,6.5, 7.8) $graph_rename vs lagtime
					display_counter = display_counter+1
				else
					AppendTograph $graph_rename vs lagtime
					display_counter = display_counter + 1
				endif
	
			endfor
			ModifyGraph log(bottom)=1
	

			newtemp1 = "area_value_135_" + num2str(i)
			Make/O/N = (floor(numberofrows[i]/bin)-1 , floor(numberofcolumns[i]/bin)-1) wave_temp_area_135
			Wave wave_temp_area_135 = $newtemp1

	
			if(logarithmiccorrelation == 1)
	
				for ( 	m =0; m <((floor(numberofrows[i]/bin)-1) * (floor(numberofcolumns[i]/bin)-1)*2); m= m+2)
					temp1_2=basename + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m])
					temp2_2=basename + "_" + num2str(i) + "_" + num2str(w1[m+1]) + "_" +num2str(w2[m+1])
					temp3_2 = "sub" + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m]) + "_______" +  num2str(w1[m+1]) + "_" +num2str(w2[m+1]) 
					Make/O/D/N =(channel1 + (channel2-1)*8) w1_2
					Wave w1_2 = $temp1_2
					Make/O/D/N = (channel1 + (channel2-1)*8) w2_2
					Wave w2_2 = $temp2_2
					Make/O/D/N=(channel1 + (channel2-1)*8) $temp3_2
					Wave w3_2 = $temp3_2
					w3_2 = (w1_2- w2_2)/(w1_2[1] + w2_2[1]-2)
					wave_temp_area_135[floor(w1[m]/bin/numberofcolumns[i])][floor(w1[m]/bin) -floor(w1[m]/bin/numberofcolumns[i])*numberofcolumns[i] ] = areaXY(lagtime, w3_2,0, lagtime[area_calc ])
				ENDfor
	
			else
	
				for ( 	m =0; m <((floor(numberofrows[i]/bin)-1) * (floor(numberofcolumns[i]/bin)-1)*2); m= m+2)
					temp1_2=basename + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m])
					temp2_2=basename + "_" + num2str(i) + "_" + num2str(w1[m+1]) + "_" +num2str(w2[m+1])
					temp3_2 = "sub" + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m]) + "_______" +  num2str(w1[m+1]) + "_" +num2str(w2[m+1]) 
					Make/O/D/N =(channel1 + (channel2-1)*8) w1_2
					Wave w1_2 = $temp1_2
					Make/O/D/N = (channel1 + (channel2-1)*8) w2_2
					Wave w2_2 = $temp2_2
					Make/O/D/N=(channel1 + (channel2-1)*8) $temp3_2
					Wave w3_2 = $temp3_2
					w3_2 = (w1_2- w2_2)
					wave_temp_area_135[floor(w1[m]/bin/numberofcolumns[i])][floor(w1[m]/bin) -floor(w1[m]/bin/numberofcolumns[i])*numberofcolumns[i] ] = areaXY(lagtime, w3_2,0, lagtime[linearpoints-1 ])
				ENDfor 
	
			endif
	
			Display/I/W = (7,5,10,8.5); AppendImage wave_temp_area_135
			ModifyGraph width=151.2,height={Aspect,1}
			ModifyGraph swapXY=1
			SetAxis/A/R left
					
			ColorScale/C/N=text0/F=0/A=MB/E vert=0,lowTrip=0.01, width=87
			ColorScale/C/N=text0 nticks=3	
	
	
			rename w1, $firstpixel
			rename w2, $secondpixel
			Rename wave_temp_area_135, $newtemp1
	
	
	
		endif
	
		if(V_Value_ ==8)
		
			area_calc = 40
			Prompt area_calc, "Enter area_calc"
			DoPrompt "area_calc", area_calc
	
			firstpixel = "firstpixel_45_" + num2str(i)
			secondpixel = "secondpixel_45_" + num2str(i)
	
			Make/N = ((floor(numberofrows[i]/bin) -1)* (floor(numberofcolumns[i]/bin)-1)*2)/O/D w1
			Make/N = ((floor(numberofrows[i]/bin)-1) * (floor(numberofcolumns[i]/bin)-1)*2)/O/D w2
			l= 0
			for (j = 0; j<(floor(numberofrows[i]/bin)-1); j= j+1)
				for (k = 1; k<(floor(numberofcolumns[i]/bin)); k= k+1)
					w1[l] = j*numberofcolumns[i]*bin + k*bin
					w2[l] = (j)*numberofcolumns[i]*bin + k*bin + (numberofcolumns[i]-1)*bin
					l = l+1
					w1[l] =(j)*numberofcolumns[i]*bin + k*bin + (numberofcolumns[i]-1)*bin
					w2[l] = j*numberofcolumns[i]*bin + k*bin
					l= l+1
				Endfor
			Endfor
	
	
	
			if(logarithmiccorrelation == 1)
	
				if ( LastFrame - FirstFrame < lagtime_check[ (channel1 + (channel2-1)*channel1/2)-1])
					print "The suggested number of frames is not sufficient to carry out correlations for the chosen number of channels in file numbered", i
					continue
				endif
	
				tif_program(FolderFileList[i], output_corr[i], output_int[i], FirstFrame, LastFrame, Background_for_program, Bin, channel1, channel2,w1,w2)
				GBLoadWave/Q/B/A=corr/T={2,2}/W=((floor(numberofrows[i]/bin) -1)* (floor(numberofcolumns[i]/bin)-1)*2)/U=(channel1 + (channel2-1)*channel1/2) output_corr[i]
				DeleteFile output_int[i]
				DeleteFile  output_corr[i]
			else
	
				print "linearmode of correlation" 
				if ( LastFrame - FirstFrame < linearpoints)
					print "The suggested number of frames is not sufficient to carry out correlations for the chosen number of points in file numbered " ,i 
					continue
				endif
	
				linear_acf(FolderFileList[i], output_corr[i], output_int[i], FirstFrame, LastFrame, Background_for_program, Bin, linearpoints,w1,w2)
				GBLoadWave/Q/B/A=corr/T={2,2}/W=((floor(numberofrows[i]/bin)-1) * (floor(numberofcolumns[i]/bin)-1)*2)/U=(linearpoints) output_corr[i]
				DeleteFile output_int[i]
				DeleteFile  output_corr[i]
			endif
	
			display_counter = 0
	
	
			for ( 	m =0; m <((floor(numberofrows[i]/bin) -1)* (floor(numberofcolumns[i]/bin)-1)*2); m= m+1)
				graph_name = "corr" + num2str(m)
				graph_rename =basename + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m])
				Rename $graph_name, $graph_rename
				if(display_counter==0)
					Display/I/W = (7,0.5, 10,3.3) $graph_rename vs lagtime
					display_counter = display_counter+1
				else
					AppendTograph $graph_rename vs lagtime
					display_counter = display_counter + 1
				endif
	
			endfor
			ModifyGraph log(bottom)=1
	
			MoveWindow 0, 0, 0, 0

			newtemp1 = "area_value_45_" + num2str(i)
			Make/O/N = (floor(numberofrows[i]/bin)-1 , floor(numberofcolumns[i]/bin)-1) wave_temp_area_45
			Wave wave_temp_area_45 = $newtemp1

	
			if(logarithmiccorrelation == 1)
	
				for ( 	m =0; m <((floor(numberofrows[i]/bin)-1) * (floor(numberofcolumns[i]/bin)-1)*2); m= m+2)
					temp1_2=basename + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m])
					temp2_2=basename + "_" + num2str(i) + "_" + num2str(w1[m+1]) + "_" +num2str(w2[m+1])
					temp3_2 = "sub" + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m]) + "_______" +  num2str(w1[m+1]) + "_" +num2str(w2[m+1]) 
					Make/O/D/N =(channel1 + (channel2-1)*8) w1_2
					Wave w1_2 = $temp1_2
					Make/O/D/N = (channel1 + (channel2-1)*8) w2_2
					Wave w2_2 = $temp2_2
					Make/O/D/N=(channel1 + (channel2-1)*8) $temp3_2
					Wave w3_2 = $temp3_2
					w3_2 = (w1_2- w2_2)/(w1_2[1] + w2_2[1]-2)
					wave_temp_area_45[floor(w1[m]/bin/numberofcolumns[i])][floor(w1[m]/bin) -floor(w1[m]/bin/numberofcolumns[i])*numberofcolumns[i]-1 ] = areaXY(lagtime, w3_2,0, lagtime[area_calc ])
				ENDfor
	
			else
	
				for ( 	m =0; m <((floor(numberofrows[i]/bin)-1) * (floor(numberofcolumns[i]/bin)-1)*2); m= m+2)
					temp1_2=basename + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m])
					temp2_2=basename + "_" + num2str(i) + "_" + num2str(w1[m+1]) + "_" +num2str(w2[m+1])
					temp3_2 = "sub" + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m]) + "_______" +  num2str(w1[m+1]) + "_" +num2str(w2[m+1]) 
					Make/O/D/N =(channel1 + (channel2-1)*8) w1_2
					Wave w1_2 = $temp1_2
					Make/O/D/N = (channel1 + (channel2-1)*8) w2_2
					Wave w2_2 = $temp2_2
					Make/O/D/N=(channel1 + (channel2-1)*8) $temp3_2
					Wave w3_2 = $temp3_2
					w3_2 = (w1_2- w2_2)
					wave_temp_area_45[floor(w1[m]/bin/numberofcolumns[i])][floor(w1[m]/bin) -floor(w1[m]/bin/numberofcolumns[i])*numberofcolumns[i]-1 ] = areaXY(lagtime, w3_2,0, lagtime[linearpoints-1 ])
				ENDfor 
	
			endif
	
			Display/I/W = (0,5, 3,8.5); AppendImage wave_temp_area_45
			ModifyGraph width=151.2,height={Aspect,1}
			ModifyGraph swapXY=1
			SetAxis/A/R left
					
			ColorScale/C/N=text0/F=0/A=MB/E vert=0,lowTrip=0.01, width=87
			ColorScale/C/N=text0 nticks=3	
			MoveWindow 0, 0, 0, 0

	
			rename w1, $firstpixel
			rename w2, $secondpixel
			Rename wave_temp_area_45, $newtemp1
	
			firstpixel = "firstpixel_135_" + num2str(i)
			secondpixel = "secondpixel_135_" + num2str(i)
	
			Make/N = ((floor(numberofrows[i]/bin) -1)* (floor(numberofcolumns[i]/bin)-1)*2)/O/D w1
			Make/N = ((floor(numberofrows[i]/bin)-1) * (floor(numberofcolumns[i]/bin)-1)*2)/O/D w2
			l= 0
			for (j = 0; j<(floor(numberofrows[i]/bin)-1); j= j+1)
				for (k = 0; k<(floor(numberofcolumns[i]/bin)-1); k= k+1)
					w1[l] = j*numberofcolumns[i]*bin + k*bin
					w2[l] = (j)*numberofcolumns[i]*bin + k*bin + (numberofcolumns[i]+1)*bin
					l = l+1
					w1[l] =(j)*numberofcolumns[i]*bin + k*bin + (numberofcolumns[i]+1)*bin
					w2[l] = j*numberofcolumns[i]*bin + k*bin
					l= l+1
				Endfor
			Endfor
	
	
	
			if(logarithmiccorrelation == 1)
	
				if ( LastFrame - FirstFrame < lagtime_check[ (channel1 + (channel2-1)*channel1/2)-1])
					print "The suggested number of frames is not sufficient to carry out correlations for the chosen number of channels in file numbered", i
					continue
				endif
	
				tif_program(FolderFileList[i], output_corr[i], output_int[i], FirstFrame, LastFrame, Background_for_program, Bin, channel1, channel2,w1,w2)
				GBLoadWave/Q/B/A=corr/T={2,2}/W=((floor(numberofrows[i]/bin) -1)* (floor(numberofcolumns[i]/bin)-1)*2)/U=(channel1 + (channel2-1)*channel1/2) output_corr[i]
				DeleteFile output_int[i]
				DeleteFile  output_corr[i]
			else
	
				print "linearmode of correlation" 
				if ( LastFrame - FirstFrame < linearpoints)
					print "The suggested number of frames is not sufficient to carry out correlations for the chosen number of points in file numbered " ,i 
					continue
				endif
	
				linear_acf(FolderFileList[i], output_corr[i], output_int[i], FirstFrame, LastFrame, Background_for_program, Bin, linearpoints,w1,w2)
				GBLoadWave/Q/B/A=corr/T={2,2}/W=((floor(numberofrows[i]/bin)-1) * (floor(numberofcolumns[i]/bin)-1)*2)/U=(linearpoints) output_corr[i]
				DeleteFile output_int[i]
				DeleteFile  output_corr[i]
			endif
	
			display_counter = 0
	
	
			for ( 	m =0; m <((floor(numberofrows[i]/bin) -1)* (floor(numberofcolumns[i]/bin)-1)*2); m= m+1)
				graph_name = "corr" + num2str(m)
				graph_rename =basename + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m])
				Rename $graph_name, $graph_rename
				if(display_counter==0)
					Display/I/W = (3.5, 5,6.5, 7.8) $graph_rename vs lagtime
					display_counter = display_counter+1
				else
					AppendTograph $graph_rename vs lagtime
					display_counter = display_counter + 1
				endif
	
			endfor
			ModifyGraph log(bottom)=1
			MoveWindow 0, 0, 0, 0


			newtemp1 = "area_value_135_" + num2str(i)
			Make/O/N = (floor(numberofrows[i]/bin)-1 , floor(numberofcolumns[i]/bin)-1) wave_temp_area_135
			Wave wave_temp_area_135 = $newtemp1

	
			if(logarithmiccorrelation == 1)
	
				for ( 	m =0; m <((floor(numberofrows[i]/bin)-1) * (floor(numberofcolumns[i]/bin)-1)*2); m= m+2)
					temp1_2=basename + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m])
					temp2_2=basename + "_" + num2str(i) + "_" + num2str(w1[m+1]) + "_" +num2str(w2[m+1])
					temp3_2 = "sub" + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m]) + "_______" +  num2str(w1[m+1]) + "_" +num2str(w2[m+1]) 
					Make/O/D/N =(channel1 + (channel2-1)*8) w1_2
					Wave w1_2 = $temp1_2
					Make/O/D/N = (channel1 + (channel2-1)*8) w2_2
					Wave w2_2 = $temp2_2
					Make/O/D/N=(channel1 + (channel2-1)*8) $temp3_2
					Wave w3_2 = $temp3_2
					w3_2 = (w1_2- w2_2)/(w1_2[1] + w2_2[1]-2)
					wave_temp_area_135[floor(w1[m]/bin/numberofcolumns[i])][floor(w1[m]/bin) -floor(w1[m]/bin/numberofcolumns[i])*numberofcolumns[i] ] = areaXY(lagtime, w3_2,0, lagtime[area_calc])
				ENDfor
	
			else
	
				for ( 	m =0; m <((floor(numberofrows[i]/bin)-1) * (floor(numberofcolumns[i]/bin)-1)*2); m= m+2)
					temp1_2=basename + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m])
					temp2_2=basename + "_" + num2str(i) + "_" + num2str(w1[m+1]) + "_" +num2str(w2[m+1])
					temp3_2 = "sub" + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m]) + "_______" +  num2str(w1[m+1]) + "_" +num2str(w2[m+1]) 
					Make/O/D/N =(channel1 + (channel2-1)*8) w1_2
					Wave w1_2 = $temp1_2
					Make/O/D/N = (channel1 + (channel2-1)*8) w2_2
					Wave w2_2 = $temp2_2
					Make/O/D/N=(channel1 + (channel2-1)*8) $temp3_2
					Wave w3_2 = $temp3_2
					w3_2 = (w1_2- w2_2)
					wave_temp_area_135[floor(w1[m]/bin/numberofcolumns[i])][floor(w1[m]/bin) -floor(w1[m]/bin/numberofcolumns[i])*numberofcolumns[i] ] = areaXY(lagtime, w3_2,0, lagtime[linearpoints-1 ])
				ENDfor 
	
			endif
	
			Display/I/W = (7,5, 10,8.5); AppendImage wave_temp_area_135
			ModifyGraph width=151.2,height={Aspect,1}
			ModifyGraph swapXY=1
			SetAxis/A/R left
					
			ColorScale/C/N=text0/F=0/A=MB/E vert=0,lowTrip=0.01, width=87
			ColorScale/C/N=text0 nticks=3	
			MoveWindow 0, 0, 0, 0

			rename w1, $firstpixel
			rename w2, $secondpixel
			Rename wave_temp_area_135, $newtemp1
	
	
			firstpixel = "firstpixel_hor" + num2str(i)
			secondpixel = "secondpixel_hor" + num2str(i)
	
			Make/N = (floor(numberofrows[i]/bin) * (floor(numberofcolumns[i]/bin)-1)*2)/O/D w1
			Make/N = (floor(numberofrows[i]/bin) * (floor(numberofcolumns[i]/bin)-1)*2)/O/D w2
			l= 0
			for (j = 0; j<(floor(numberofrows[i]/bin)); j= j+1)
				for (k = 0; k<(floor(numberofcolumns[i]/bin)-1); k= k+1)
					w1[l] = j*numberofcolumns[i]*bin + k*bin
					w2[l] = j*numberofcolumns[i]*bin + k*bin + bin
					l = l+1
					w1[l] =j*numberofcolumns[i]*bin + k*bin + bin
					w2[l] = j*numberofcolumns[i]*bin + k*bin
					l= l+1
				Endfor
			Endfor
	
	
	
			if(logarithmiccorrelation == 1)
	
				if ( LastFrame - FirstFrame < lagtime_check[ (channel1 + (channel2-1)*channel1/2)-1])
					print "The suggested number of frames is not sufficient to carry out correlations for the chosen number of channels in file numbered", i
					continue
				endif
	
				tif_program(FolderFileList[i], output_corr[i], output_int[i], FirstFrame, LastFrame, Background_for_program, Bin, channel1, channel2,w1,w2)
				GBLoadWave/Q/B/A=corr/T={2,2}/W=(floor(numberofrows[i]/bin) * (floor(numberofcolumns[i]/bin)-1)*2)/U=(channel1 + (channel2-1)*channel1/2) output_corr[i]
				DeleteFile output_int[i]
				DeleteFile  output_corr[i]
			else
	
				print "linearmode of correlation" 
				if ( LastFrame - FirstFrame < linearpoints)
					print "The suggested number of frames is not sufficient to carry out correlations for the chosen number of points in file numbered " ,i 
					continue
				endif
	
				linear_acf(FolderFileList[i], output_corr[i], output_int[i], FirstFrame, LastFrame, Background_for_program, Bin, linearpoints,w1,w2)
				GBLoadWave/Q/B/A=corr/T={2,2}/W=(floor(numberofrows[i]/bin) * (floor(numberofcolumns[i]/bin)-1)*2)/U=(linearpoints) output_corr[i]
				DeleteFile output_int[i]
				DeleteFile  output_corr[i]
			endif
	
			display_counter = 0
	
	
			for ( 	m =0; m <(floor(numberofrows[i]/bin) * (floor(numberofcolumns[i]/bin)-1)*2); m= m+1)
				graph_name = "corr" + num2str(m)
				graph_rename =basename + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m])
				Rename $graph_name, $graph_rename
				if(display_counter==0)
					Display/I/W =(7,0.5, 10,3.3)$graph_rename vs lagtime
					display_counter = display_counter+1
				else
					AppendTograph $graph_rename vs lagtime
					display_counter = display_counter + 1
				endif
	
			endfor
			ModifyGraph log(bottom)=1
	

			newtemp1 = "area_value_hor" + num2str(i)
			Make/O/N = (floor(numberofrows[i]/bin) , floor(numberofcolumns[i]/bin)-1) wave_temp_area


	
			if(logarithmiccorrelation == 1)
	
				for ( 	m =0; m <(floor(numberofrows[i]/bin) * (floor(numberofcolumns[i]/bin)-1)*2); m= m+2)
					temp1_2=basename + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m])
					temp2_2=basename + "_" + num2str(i) + "_" + num2str(w1[m+1]) + "_" +num2str(w2[m+1])
					temp3_2 = "sub" + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m]) + "_______" +  num2str(w1[m+1]) + "_" +num2str(w2[m+1]) 
					Make/O/D/N =(channel1 + (channel2-1)*8) w1_2
					Wave w1_2 = $temp1_2
					Make/O/D/N = (channel1 + (channel2-1)*8) w2_2
					Wave w2_2 = $temp2_2
					Make/O/D/N=(channel1 + (channel2-1)*8) $temp3_2
					Wave w3_2 = $temp3_2
					w3_2 = (w1_2- w2_2)/(w1_2[1] + w2_2[1]-2)
					wave_temp_area[floor(w1[m]/bin/numberofcolumns[i])][floor(w1[m]/bin) -floor(w1[m]/bin/numberofcolumns[i])*numberofcolumns[i] ] = areaXY(lagtime, w3_2,0, lagtime[area_calc ])
				ENDfor
	
			else
	
				for ( 	m =0; m <(floor(numberofrows[i]/bin) * (floor(numberofcolumns[i]/bin)-1)*2); m= m+2)
					temp1_2=basename + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m])
					temp2_2=basename + "_" + num2str(i) + "_" + num2str(w1[m+1]) + "_" +num2str(w2[m+1])
					temp3_2 = "sub" + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m]) + "_______" +  num2str(w1[m+1]) + "_" +num2str(w2[m+1]) 
					Make/O/D/N =(channel1 + (channel2-1)*8) w1_2
					Wave w1_2 = $temp1_2
					Make/O/D/N = (channel1 + (channel2-1)*8) w2_2
					Wave w2_2 = $temp2_2
					Make/O/D/N=(channel1 + (channel2-1)*8) $temp3_2
					Wave w3_2 = $temp3_2
					w3_2 = (w1_2- w2_2)
					wave_temp_area[floor(w1[m]/bin/numberofcolumns[i])][floor(w1[m]/bin) -floor(w1[m]/bin/numberofcolumns[i])*numberofcolumns[i] ] = areaXY(lagtime, w3_2,0, lagtime[linearpoints-1 ])
				ENDfor 

			endif
	
			Display/I/W = (0,5, 3,8.5); AppendImage wave_temp_area
			ModifyGraph width=151.2,height={Aspect,1}
			ModifyGraph swapXY=1
			SetAxis/A/R left
					
			ColorScale/C/N=text0/F=0/A=MB/E vert=0,lowTrip=0.01, width=87
			ColorScale/C/N=text0 nticks=3
	
			rename w1, $firstpixel
			rename w2, $secondpixel
			Rename wave_temp_area, $newtemp1


			firstpixel = "firstpixel_ver" + num2str(i)
			secondpixel = "secondpixel_ver" + num2str(i)
	
			Make/N = ((floor(numberofrows[i]/bin) -1)* (floor(numberofcolumns[i]/bin))*2)/O/D w1
			Make/N = ((floor(numberofrows[i]/bin)-1) * (floor(numberofcolumns[i]/bin))*2)/O/D w2
			l= 0
			for (j = 0; j<(floor(numberofrows[i]/bin)-1); j= j+1)
				for (k = 0; k<(floor(numberofcolumns[i]/bin)); k= k+1)
					w1[l] = j*numberofcolumns[i]*bin + k*bin
					w2[l] = (j+1)*numberofcolumns[i]*bin + k*bin 
					l = l+1
					w1[l] =(j+1)*numberofcolumns[i]*bin + k*bin 
					w2[l] = j*numberofcolumns[i]*bin + k*bin
					l= l+1
				Endfor
			Endfor
	
	
	
			if(logarithmiccorrelation == 1)
	
				if ( LastFrame - FirstFrame < lagtime_check[ (channel1 + (channel2-1)*channel1/2)-1])
					print "The suggested number of frames is not sufficient to carry out correlations for the chosen number of channels in file numbered", i
					continue
				endif
	
				tif_program(FolderFileList[i], output_corr[i], output_int[i], FirstFrame, LastFrame, Background_for_program, Bin, channel1, channel2,w1,w2)
				GBLoadWave/Q/B/A=corr/T={2,2}/W=((floor(numberofrows[i]/bin) -1)* (floor(numberofcolumns[i]/bin))*2)/U=(channel1 + (channel2-1)*channel1/2) output_corr[i]
				DeleteFile output_int[i]
				DeleteFile  output_corr[i]
			else
	
				print "linearmode of correlation" 
				if ( LastFrame - FirstFrame < linearpoints)
					print "The suggested number of frames is not sufficient to carry out correlations for the chosen number of points in file numbered " ,i 
					continue
				endif
	
				linear_acf(FolderFileList[i], output_corr[i], output_int[i], FirstFrame, LastFrame, Background_for_program, Bin, linearpoints,w1,w2)
				GBLoadWave/Q/B/A=corr/T={2,2}/W=((floor(numberofrows[i]/bin)-1) * (floor(numberofcolumns[i]/bin))*2)/U=(linearpoints) output_corr[i]
				DeleteFile output_int[i]
				DeleteFile  output_corr[i]
			endif
	
			display_counter = 0
	
	
			for ( 	m =0; m <((floor(numberofrows[i]/bin) -1)* (floor(numberofcolumns[i]/bin))*2); m= m+1)
				graph_name = "corr" + num2str(m)
				graph_rename =basename + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m])
				Rename $graph_name, $graph_rename
				if(display_counter==0)
					Display/I/W = (3.5, 5,6.5, 7.8) $graph_rename vs lagtime
					display_counter = display_counter+1
				else
					AppendTograph $graph_rename vs lagtime
					display_counter = display_counter + 1
				endif
	
			endfor
			ModifyGraph log(bottom)=1
	

			newtemp1 = "area_value_ver" + num2str(i)
			Make/O/N = (floor(numberofrows[i]/bin)-1 , floor(numberofcolumns[i]/bin)) wave_temp_area
			Wave wave_temp_area = $newtemp1

	
			if(logarithmiccorrelation == 1)
	
				for ( 	m =0; m <((floor(numberofrows[i]/bin)-1) * (floor(numberofcolumns[i]/bin))*2); m= m+2)
					temp1_2=basename + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m])
					temp2_2=basename + "_" + num2str(i) + "_" + num2str(w1[m+1]) + "_" +num2str(w2[m+1])
					temp3_2 = "sub" + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m]) + "_______" +  num2str(w1[m+1]) + "_" +num2str(w2[m+1]) 
					Make/O/D/N =(channel1 + (channel2-1)*8) w1_2
					Wave w1_2 = $temp1_2
					Make/O/D/N = (channel1 + (channel2-1)*8) w2_2
					Wave w2_2 = $temp2_2
					Make/O/D/N=(channel1 + (channel2-1)*8) $temp3_2
					Wave w3_2 = $temp3_2
					w3_2 = (w1_2- w2_2)/(w1_2[1] + w2_2[1]-2)
					wave_temp_area[floor(w1[m]/bin/numberofcolumns[i])][floor(w1[m]/bin) -floor(w1[m]/bin/numberofcolumns[i])*numberofcolumns[i] ] = areaXY(lagtime, w3_2,0, lagtime[area_calc])
				ENDfor
	
			else
	
				for ( 	m =0; m <((floor(numberofrows[i]/bin)-1) * (floor(numberofcolumns[i]/bin))*2); m= m+2)
					temp1_2=basename + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m])
					temp2_2=basename + "_" + num2str(i) + "_" + num2str(w1[m+1]) + "_" +num2str(w2[m+1])
					temp3_2 = "sub" + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m]) + "_______" +  num2str(w1[m+1]) + "_" +num2str(w2[m+1]) 
					Make/O/D/N =(channel1 + (channel2-1)*8) w1_2
					Wave w1_2 = $temp1_2
					Make/O/D/N = (channel1 + (channel2-1)*8) w2_2
					Wave w2_2 = $temp2_2
					Make/O/D/N=(channel1 + (channel2-1)*8) $temp3_2
					Wave w3_2 = $temp3_2
					w3_2 = (w1_2- w2_2)
					wave_temp_area[floor(w1[m]/bin/numberofcolumns[i])][floor(w1[m]/bin) -floor(w1[m]/bin/numberofcolumns[i])*numberofcolumns[i] ] = areaXY(lagtime, w3_2,0, lagtime[linearpoints-1 ])
				ENDfor 
	
			endif
	
			Display/I/W =(7,5, 10,8.5); AppendImage wave_temp_area
			ModifyGraph width=151.2,height={Aspect,1}
			ModifyGraph swapXY=1
			SetAxis/A/R left
					
			ColorScale/C/N=text0/F=0/A=MB/E vert=0,lowTrip=0.01, width=87
			ColorScale/C/N=text0 nticks=3
			rename w1, $firstpixel
			rename w2, $secondpixel
			Rename wave_temp_area, $newtemp1
		endif
	
	
		if (V_value_ ==10)     
	
			if (numberofcolumns[i] < 15)
				print "Insufficient number of columns. Needs at least 15 columns for the file numbered ", i
				continue
			endif
	
			if (ceil(numberofcolumns[i]/2)+7+(Bin-1)>=numberofcolumns[i])
				print "Insufficient number of columns at the suggested bin for file numbered", i
				continue
			endif
	
			cp = ceil(numberofcolumns[i]/2) + numberofcolumns[i]*(ceil(numberofrows[i]/2)-1)  - 1
			Make/N = 15/O/D w1
			Make/N = 15/O/D w2


			for (j = 0; j<15; j= j+1)
				w1[j] = cp
				w2[j] = cp-7+j
			Endfor
	
			if(logarithmiccorrelation == 1)
	
				if ( LastFrame - FirstFrame < lagtime_check[ (channel1 + (channel2-1)*channel1/2)-1])
					print "The suggested number of frames is not sufficient to carry out correlations for the chosen number of channels in file numbered", i
					continue
				endif
	
				tif_program(FolderFileList[i], output_corr[i], output_int[i], FirstFrame, LastFrame, Background_for_program, Bin, channel1, channel2,w1,w2)
				GBLoadWave/Q/B/A=corr/T={2,2}/W=15/U=(channel1 + (channel2-1)*channel1/2) output_corr[i]
				DeleteFile output_int[i]
				DeleteFile  output_corr[i]
			else
	
				print "linearmode of correlation" 
				if ( LastFrame - FirstFrame < linearpoints)
					print "The suggested number of frames is not sufficient to carry out correlations for the chosen number of points in file numbered " ,i 
					continue
				endif
	
				linear_acf(FolderFileList[i], output_corr[i], output_int[i], FirstFrame, LastFrame, Background_for_program, Bin, linearpoints,w1,w2)
				GBLoadWave/Q/B/A=corr/T={2,2}/W=15/U=(linearpoints) output_corr[i]
				DeleteFile output_int[i]
				DeleteFile  output_corr[i]
			endif
	
			display_counter = 0
	
			for ( 	m =0; m <15; m= m+1)
				graph_name = "corr" + num2str(m)
				graph_rename =basename + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m])
				Rename $graph_name, $graph_rename
				if(display_counter==0)
					Display/N = newstring/I/W = (7,0.5, 10,3.3) $graph_rename vs lagtime
					display_counter = display_counter+1
				else
					AppendTograph $graph_rename vs lagtime
					display_counter = display_counter + 1
				endif
			endfor
			ModifyGraph log(bottom)=1
			SetAxis/A=2 left
			rename w1, $firstpixel
			rename w2, $secondpixel
		endif 
	
		if (V_value_ ==11)
	
			if (numberofrows[i] < 15)
				print "Insufficient number of rows. Needs at least 15 rows for the file numbered ", i
				continue
			endif
	
			if (ceil(numberofrows[i]/2)+7+(Bin-1)>=numberofrows[i])
				print "Insufficient number of rows at the suggested bin for file numbered", i
				continue
			endif
	
			cp = ceil(numberofcolumns[i]/2) + numberofcolumns[i]*(ceil(numberofrows[i]/2)-1)  - 1
			Make/N = 15/O/D w1
			Make/N = 15/O/D w2

	
	
			for (j = 0; j<15; j= j+1)
				w1[j] = cp
				w2[j] = ceil(numberofcolumns[i]/2) + numberofcolumns[i]*(ceil(numberofrows[i]/2)-7+j)  - 1
			Endfor
	
			if(logarithmiccorrelation == 1)
	
				if ( LastFrame - FirstFrame <lagtime_check[ (channel1 + (channel2-1)*channel1/2)-1])
					print "The suggested number of frames is not sufficient to carry out correlations for the chosen number of channels in file numbered", i
					continue
				endif
	
				tif_program(FolderFileList[i], output_corr[i], output_int[i], FirstFrame, LastFrame, Background_for_program, Bin, channel1, channel2,w1,w2)
				GBLoadWave/Q/B/A=corr/T={2,2}/W=15/U=(channel1 + (channel2-1)*channel1/2) output_corr[i]
				DeleteFile output_int[i]
				DeleteFile  output_corr[i]
			else
	
				print "linearmode of correlation" 
				if ( LastFrame - FirstFrame < linearpoints)
					print "The suggested number of frames is not sufficient to carry out correlations for the chosen number of points in file numbered " ,i 
					continue
				endif
	
				linear_acf(FolderFileList[i], output_corr[i], output_int[i], FirstFrame, LastFrame, Background_for_program, Bin, linearpoints,w1,w2)
				GBLoadWave/Q/B/A=corr/T={2,2}/W=15/U=(linearpoints) output_corr[i]
	
			endif
	
			display_counter = 0
	
			for ( 	m =0; m <15; m= m+1)
				graph_name = "corr" + num2str(m)
				graph_rename =basename + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m])
				Rename $graph_name, $graph_rename
				if(display_counter==0)
					Display/I/W = (7,0.5, 10,3.3) $graph_rename vs lagtime
					display_counter = display_counter+1
				else
					AppendTograph $graph_rename vs lagtime
					display_counter = display_counter + 1
				endif
			endfor
			ModifyGraph log(bottom)=1
			SetAxis/A=2 left
			rename w1, $firstpixel
			rename w2, $secondpixel
		endif 	
		if (V_value_ ==12)
	
	
			if (numberofrows[i] < 15)
				print "Insufficient number of rows. Needs at least 15 rows for the file numbered ", i
				continue
			endif
	
			if (ceil(numberofrows[i]/2)+7+(Bin-1)>=numberofrows[i])
				print "Insufficient number of rows at the suggested bin for file numbered", i
				continue
			endif
	
	
			if (numberofcolumns[i] < 15)
				print "Insufficient number of columns. Needs at least 15 columns for the file numbered ", i
				continue
			endif
	
			if (ceil(numberofcolumns[i]/2)+7+(Bin-1)>=numberofcolumns[i])
				print "Insufficient number of columns at the suggested bin for file numbered", i
				continue
			endif
	
			cp = ceil(numberofcolumns[i]/2) + numberofcolumns[i]*(ceil(numberofrows[i]/2)-1)  - 1
			Make/N = 15/O/D w1
			Make/N = 15/O/D w2

	
	
			for (j = 0; j<15; j= j+1)
				w1[j] = cp
				w2[j] = ceil(numberofcolumns[i]/2) + numberofcolumns[i]*(ceil(numberofrows[i]/2)+7-j-1)  - 7+j-1
			Endfor
	
			if(logarithmiccorrelation == 1)
	
				if ( LastFrame - FirstFrame <lagtime_check[ (channel1 + (channel2-1)*channel1/2)-1])
					print "The suggested number of frames is not sufficient to carry out correlations for the chosen number of channels in file numbered", i
					continue
				endif
	
				tif_program(FolderFileList[i], output_corr[i], output_int[i], FirstFrame, LastFrame, Background_for_program, Bin, channel1, channel2,w1,w2)
				GBLoadWave/Q/B/A=corr/T={2,2}/W=15/U=(channel1 + (channel2-1)*channel1/2) output_corr[i]
				DeleteFile output_int[i]
				DeleteFile  output_corr[i]
			else 
	
				print "linearmode of correlation" 
				if ( LastFrame - FirstFrame < linearpoints)
					print "The suggested number of frames is not sufficient to carry out correlations for the chosen number of points in file numbered " ,i 
					continue
				endif
	
				linear_acf(FolderFileList[i], output_corr[i], output_int[i], FirstFrame, LastFrame, Background_for_program, Bin, linearpoints,w1,w2)
				GBLoadWave/Q/B/A=corr/T={2,2}/W=15/U=(linearpoints) output_corr[i]
				DeleteFile output_int[i]
				DeleteFile  output_corr[i]
			endif
	
			display_counter = 0
	
			for ( 	m =0; m <15; m= m+1)
				graph_name = "corr" + num2str(m)
				graph_rename =basename + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m])
				Rename $graph_name, $graph_rename
				if(display_counter==0)
					Display/I/W = (7,0.5, 10,3.3) $graph_rename vs lagtime
					display_counter = display_counter+1
				else
					AppendTograph $graph_rename vs lagtime
					display_counter = display_counter + 1
				endif
			endfor
			ModifyGraph log(bottom)=1
			SetAxis/A=2 left
			rename w1, $firstpixel
			rename w2, $secondpixel
		endif 	
	
	
		if (V_value_ ==13)
	
	
			if (numberofrows[i] < 15)
				print "Insufficient number of rows. Needs at least 15 rows for the file numbered ", i
				continue
			endif
	
			if (ceil(numberofrows[i]/2)+7+(Bin-1)>=numberofrows[i])
				print "Insufficient number of rows at the suggested bin for file numbered", i
				continue
			endif
	
	
			if (numberofcolumns[i] < 15)
				print "Insufficient number of columns. Needs at least 15 columns for the file numbered ", i
				continue
			endif
	
			if (ceil(numberofcolumns[i]/2)+7+(Bin-1)>=numberofcolumns[i])
				print "Insufficient number of columns at the suggested bin for file numbered", i
				continue
			endif
	
			cp = ceil(numberofcolumns[i]/2) + numberofcolumns[i]*(ceil(numberofrows[i]/2)-1)  - 1
			Make/N = 15/O/D w1
			Make/N = 15/O/D w2

	
	
			for (j = 0; j<15; j= j+1)
				w1[j] = cp
				w2[j] = ceil(numberofcolumns[i]/2) + numberofcolumns[i]*(ceil(numberofrows[i]/2)-7+j-1) -7+j-1
				//w2[j] = ceil(numberofcolumns[i]/2) + numberofcolumns[i]*(ceil(numberofrows[i]/2)+7-j)  - 7+j
			Endfor
	
			if(logarithmiccorrelation == 1)
	
				if ( LastFrame - FirstFrame <lagtime_check[ (channel1 + (channel2-1)*channel1/2)-1])
					print "The suggested number of frames is not sufficient to carry out correlations for the chosen number of channels in file numbered", i
					continue
				endif
	
				tif_program(FolderFileList[i], output_corr[i], output_int[i], FirstFrame, LastFrame, Background_for_program, Bin, channel1, channel2,w1,w2)
				GBLoadWave/Q/B/A=corr/T={2,2}/W=15/U=(channel1 + (channel2-1)*channel1/2) output_corr[i]
				DeleteFile output_int[i]
				DeleteFile  output_corr[i]
			else
	
				print "linearmode of correlation" 
				if ( LastFrame - FirstFrame < linearpoints)
					print "The suggested number of frames is not sufficient to carry out correlations for the chosen number of points in file numbered " ,i 
					continue
				endif
	
				linear_acf(FolderFileList[i], output_corr[i], output_int[i], FirstFrame, LastFrame, Background_for_program, Bin, linearpoints,w1,w2)
				GBLoadWave/Q/B/A=corr/T={2,2}/W=15/U=(linearpoints) output_corr[i]
				DeleteFile output_int[i]
				DeleteFile  output_corr[i]
			endif
	
			display_counter = 0
	
			for ( 	m =0; m <15; m= m+1)
				graph_name = "corr" + num2str(m)
				graph_rename =basename + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m])
				Rename $graph_name, $graph_rename
				if(display_counter==0)
					Display/I/W = (7,0.5, 10,3.3) $graph_rename vs lagtime
					display_counter = display_counter+1
				else
					AppendTograph $graph_rename vs lagtime
					display_counter = display_counter + 1
				endif
			endfor
			ModifyGraph log(bottom)=1
			SetAxis/A=2 left
			rename w1, $firstpixel
			rename w2, $secondpixel
		endif
	
		if (V_value_ ==14)
	
			if (numberofrows[i] < 15)
				print "Insufficient number of rows. Needs at least 15 rows for the file numbered ", i
				continue
			endif
	
			if (ceil(numberofrows[i]/2)+7+(Bin-1)>=numberofrows[i])
				print "Insufficient number of rows at the suggested bin for file numbered", i
				continue
			endif
	
	
			if (numberofcolumns[i] < 15)
				print "Insufficient number of columns. Needs at least 15 columns for the file numbered ", i
				continue
			endif
	
			if (ceil(numberofcolumns[i]/2)+7+(Bin-1)>=numberofcolumns[i])
				print "Insufficient number of columns at the suggested bin for file numbered", i
				continue
			endif 
	
			cp = ceil(numberofcolumns[i]/2) + numberofcolumns[i]*(ceil(numberofrows[i]/2)-1)  - 1
			Make/N = 225/O/D w1
			Make/N = 225/O/D w2

	
			for (i= 0;i<15;i=i+1)
				for (j = 0; j<15; j= j+1)
					w1[i*15+j] = cp
					w2[i*15+j] = ceil(numberofcolumns[i]/2) + numberofcolumns[i]*(ceil(numberofrows[i]/2)-7+i)  - 7+j
				Endfor
			Endfor
	

	
			if(logarithmiccorrelation == 1)
	
				if ( LastFrame - FirstFrame <lagtime_check[ (channel1 + (channel2-1)*channel1/2)-1])
					print "The suggested number of frames is not sufficient to carry out correlations for the chosen number of channels in file numbered", i
					continue
				endif
	
				tif_program(FolderFileList[i], output_corr[i], output_int[i], FirstFrame, LastFrame, Background_for_program, Bin, channel1, channel2,w1,w2)
				GBLoadWave/Q/B/A=corr/T={2,2}/W=225/U=(channel1 + (channel2-1)*channel1/2) output_corr[i]
				DeleteFile output_int[i]
				DeleteFile  output_corr[i]
			else 
	
				print "linearmode of correlation" 
				if ( LastFrame - FirstFrame < linearpoints)
					print "The suggested number of frames is not sufficient to carry out correlations for the chosen number of points in file numbered " ,i 
					continue
				endif
	
				linear_acf(FolderFileList[i], output_corr[i], output_int[i], FirstFrame, LastFrame, Background_for_program, Bin, linearpoints,w1,w2)
				GBLoadWave/Q/B/A=corr/T={2,2}/W=225/U=(linearpoints) output_corr[i]
				DeleteFile output_int[i]
				DeleteFile  output_corr[i]
			endif
	
			display_counter = 0
	
			for ( 	m =0; m <225; m= m+1)
				graph_name = "corr" + num2str(m)
				graph_rename =basename + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m])
				Rename $graph_name, $graph_rename
				if(display_counter==0)
					Display/I/W = (7,0.5, 10,3.3) $graph_rename vs lagtime
					display_counter = display_counter+1
				else
					AppendTograph $graph_rename vs lagtime
					display_counter = display_counter + 1
				endif
			endfor
			ModifyGraph log(bottom)=1
			SetAxis/A=2 left
			rename w1, $firstpixel
			rename w2, $secondpixel
		endif 	

		if (V_value_ ==15)
	

		
	
			String temp1 = "Intensity" + num2str(i)
			LoadWave/O/A= wave/J /N/Q output_minimum[i]
			DeletePoints 0,4, wave0
			Redimension/N=(numberofcolumns[i], numberofrows[i]) wave0
			MatrixTranspose wave0
			Button marquee pos={170,370}, disable = 0,size={110,24}, fsize=10, font="Arial", title="Area Chosen",proc=  UserCursorAdjust_ContButtonProc
	
			
			Display/I/W = (0,5, 3,8);AppendImage wave0
			ModifyGraph width=151.2,height={Aspect,1}
			//Display/N = Choose_Pixel/I/W = (0,0.5, 3,3.5); AppendImage dis_intensity0
			
			ModifyGraph swapXY=1
			SetAxis/A/R left
			//ModifyGraph width=288,height={Aspect,1}
			Rename wave0, $temp1 
			//DoWindow/F ITIRFCCSMainControl_new
			PauseForUser Graph0, ITIRFCCSMainControl_new
	
			NVAR  mar_top = root:ITIRFCCS:mar_top
			NVAR mar_bottom = root:ITIRFCCS:mar_bottom
			NVAR mar_left = root:ITIRFCCS:mar_left
			NVAR mar_right = root:ITIRFCCS:mar_right
	

			Make/N =((mar_bottom+1-mar_top)*(mar_right-mar_left +1))/O/D w1
			Make/N = ((mar_bottom+1-mar_top)*(mar_right-mar_left +1))/O/D w2

		
			if (mar_top < 1)
				mar_top =0
			endif
	
			if (mar_bottom <1)
				mar_bottom =0
			endif
	
			if(mar_left < 1)
				mar_left = 0
			endif
	
			if(mar_right <1)
				mar_right = 0
			endif
	
			if (mar_top > numberofrows[i]-bin)
				mar_top = numberofrows[i]-bin
			endif
	
			if(mar_bottom > numberofrows[i]-bin)
				mar_bottom = numberofrows[i]-bin
			endif
	
			if(mar_left > numberofcolumns[i]-bin)
				mar_left = numberofcolumns[i]-bin
			endif
	
			if(mar_right > numberofcolumns[i]-bin)
				mar_right = numberofcolumns[i]-bin
			endif
	
			l = 0
	
			for (j = mar_top; j<=mar_bottom; j= j+1)
				for (k = mar_left; k<=mar_right; k= k+1)
					w1[l] = j*numberofcolumns[i] + k
					w2[l] = w1[l]
					l = l+ 1
				Endfor
			Endfor
	
		
			if(logarithmiccorrelation == 1)
				tif_program(FolderFileList[i], output_corr[i], output_int[i], FirstFrame, LastFrame, Background_for_program, Bin, channel1, channel2,w1,w2)
				GBLoadWave/Q/B/A=corr/T={2,2}/W=((mar_bottom+1-mar_top)*(mar_right-mar_left +1))/U=(channel1 + (channel2-1)*channel1/2) output_corr[i]
				DeleteFile output_int[i]
				DeleteFile  output_corr[i]
			else
	
				print "linearmode of correlation" 
				if ( LastFrame - FirstFrame < linearpoints)
					print "The suggested number of frames is not sufficient to carry out correlations for the chosen number of points in file numbered " ,i 
					continue
				endif
	
				linear_acf(FolderFileList[i], output_corr[i], output_int[i], FirstFrame, LastFrame, Background_for_program, Bin, linearpoints,w1,w2)
				GBLoadWave/Q/B/A=corr/T={2,2}/W=((mar_bottom+1-mar_top)*(mar_right-mar_left +1))/U=(linearpoints) output_corr[i]
				DeleteFile output_int[i]
				DeleteFile  output_corr[i]
			endif
	
			display_counter = 0
	
			for ( 	m =0; m <((mar_bottom+1-mar_top)*(mar_right-mar_left +1)); m= m+1)
				graph_name = "corr" + num2str(m)
				graph_rename =basename + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m])
				Rename $graph_name, $graph_rename
				if(display_counter==0)
					Display/N=newstring/I/W = (7,0.5, 10,3.3) $graph_rename vs lagtime
					display_counter = display_counter+1
				else
					AppendTograph $graph_rename vs lagtime
					display_counter = display_counter + 1
				endif
			endfor
			ModifyGraph log(bottom)=1
			SetAxis/A=2 left
			rename w1, $firstpixel
			rename w2, $secondpixel
			//Button marquee pos={170,370}, disable = 1,size={110,24}, fsize=10, font="Arial", title="Area Chosen",proc=  UserCursorAdjust_ContButtonProc
	
			KillControl/W= ITIRFCCSmaincontrol_new marquee
		endif 	
		
		if (V_Value_ == 16)
			String temp2= "Intensity" + num2str(i)
			LoadWave/O/A=wave_dis/J /N/Q output_minimum[i]
			DeletePoints 0,4, wave_dis0
			Redimension/N=(numberofcolumns[i], numberofrows[i]) wave_dis0
			MatrixTranspose wave_dis0
			Display/N = select_area/I/W = (7,0.5, 10,3.3); AppendImage wave_dis0
			ModifyGraph width=151.2,height={Aspect,1}
			ModifyGraph swapXY=1
			SetAxis/A/R left
			//ModifyGraph width=288,height={Aspect,1}
			Display/N = tokill1/I/W = (7,0.5, 10,3.3);AppendImage wave_dis0
			Display/N = tokill2/I/W = (7,0.5, 10,3.3);AppendImage wave_dis0
			//Rename wave_dis0, $temp2
			DoWindow/F select_area0
	
			Variable i2, j2
			String xwave_area = "column" + "_file_" + num2str(i)
			String ywave_area = "row" + "_file_" + num2str(i)
			String row_selected_s = "row_selected_file_" + num2str(i)
			String col_selected_s = "col_selected_file_" + num2str(i)
			String row_selected_s_1= "row_selected_1_file_" + num2str(i)
			String col_selected_s_1 = "col_selected_1_file_" + num2str(i)
			String pos_s_1 = "pos_1_" + num2str(i)
			String pos_s_2 = "pos_2_" + num2str(i) 
		
			String consolidated_wave_s_1 = "consolidated_wave_file_" + num2str(i)
			Make/N = (numberofrows[i]*numberofcolumns[i])/O w1_ccf
			Make/N = (numberofrows[i]*numberofcolumns[i])/O w2_ccf
		
			for (i2 = 0; i2< numberofrows[i]; i2= i2+1)
				for (j2 = 0; j2<numberofcolumns[i]; j2= j2+1)
					w1_ccf[i2*numberofcolumns[i] +j2]= j2
					w2_ccf[i2*numberofcolumns[i] +j2]= i2
				endfor
			endfor
			
			
			DoWindow/F ITIRFCCSMainControl_new
			Button abc pos={170,370}, disable = 0,size={110,24}, fsize=10, font="Arial",title="area 1 chosen",proc=  UserCursorAdjust_Proc1
			DoWindow/F select_area
			graphwavedraw/w=select_area/O yyyy, xxxx
			//DoWindow/F ITIRFCCSMainControl_new
			//Pauseforuser  ITIRFCCSMainControl_new,select_area
			Pauseforuser select_area, ITIRFCCSMainControl_new
			DoWindow/F ITIRFCCSMainControl_new
			Button abc1 pos={170,370}, disable =0,size={110,24}, fsize=10, font="Arial", title="Area 2 chosen",proc=  UserCursorAdjust_Proc2
			Display/N = select_area/I/W = (7,0.5, 10,3.3); AppendImage wave_dis0
			ModifyGraph swapXY=1
			SetAxis/A/R left
			ModifyGraph width=151.2,height={Aspect,1}
			//ModifyGraph width=288,height={Aspect,1}
			DoWindow/F select_area
			graphwavedraw/w=select_area/O yyyy1, xxxx1 
			//Pauseforuser  ITIRFCCSMainControl_new,select_area	
			Pauseforuser  select_area, ITIRFCCSMainControl_new
			Rename wave_dis0, $temp2
			wave poly_1 = root:ITIRFCCS:poly_1
			wavestats/Q poly_1
			Make/N = (V_sum) row_1
			Make/N = (V_sum) column_1
			mAKE/n = (V_sum) position_1
			variable p,q, r= 0
			for (p= 0; p<numberofrows[i]*numberofcolumns[i]; p=p+1)

				if (poly_1[p]==1)
					row_1[r] = w2_ccf[p]
					column_1[r]=w1_ccf[p]
					position_1[r] = row_1[r]*numberofcolumns[i] + column_1[r]
					r= r+1
				endif
			endfor
	
			poly_1 = poly_1*10
			wave poly_2 = root:ITIRFCCS:poly_2
			wavestats/Q poly_2
			make/N = (V_sum) row_2
			make/N = (V_sum) column_2
			make/N = (V_sum) position_2
			r= 0
			for (p= 0; p<numberofrows[i]*numberofcolumns[i]; p=p+1)
				if (poly_2[p]==1)
					row_2[r] = w2_ccf[p]
					column_2[r]=w1_ccf[p]
					position_2[r] = row_2[r]*numberofcolumns[i] + column_2[r]
					r= r+1
				endif
	
			endfor
			if(logarithmiccorrelation == 1)
				randomshape_program(FolderFileList[i], output_corr[i], output_int[i], FirstFrame, LastFrame, Background_for_program,  channel1, channel2,position_1,position_2)
				GBLoadWave/Q/B/A=corr/T={2,2}/W=1/U=(channel1 + (channel2-1)*8) output_corr[i]
				DeleteFile output_int[i]
				DeleteFile  output_corr[i]
			else
	
				print "linearmode of correlation" 
				if ( LastFrame - FirstFrame < linearpoints)
					print "The suggested number of frames is not sufficient to carry out correlations for the chosen number of points in file numbered " ,i 
					continue
				endif
				linear_acf_random(FolderFileList[i], output_corr[i], output_int[i], FirstFrame, LastFrame, Background_for_program, Bin, linearpoints,position_1,position_2)
				GBLoadWave/Q/B/A=corr/T={2,2}/W=1/U=(linearpoints) output_corr[i]
				DeleteFile output_int[i]
				DeleteFile  output_corr[i]
			endif
		
		
			poly_2 = poly_2 *20
		
			poly_1 = poly_1 + poly_2
			redimension/N = (numberofcolumns[i], numberofrows[i]) poly_1
			matrixtranspose polY_1
		
			String polY_name_1 = "selected_1_" + num2str(i)
			String polY_name_2 = "selected_2_" + num2str(i)
			String row_1_s = "row_1_" + num2str(i)
			String col_1_s = "col_1_" + num2str(i)
			String row_2_s = "row_2_" + num2str(i)
			String col_2_s = "col_2_" + num2str(i)
			Display/I/W = (0,5, 3,8.5);AppendImage poly_1
			ModifyGraph swapXY=1
			SetAxis/A/R left
			ModifyImage poly_1 ctab= {*,*,Relief19,0}
			ModifyGraph width=151.2,height={Aspect,1}
			//ModifyGraph width=288,height={Aspect,1}
			graph_name = "corr" + num2str(m)
			graph_rename ="corr" + num2str(i)
			Rename $graph_name, $graph_rename
			Display/N=newstring/I/W = (7,0.5, 10,3.3) $graph_rename vs lagtime
			ModifyGraph log(bottom)=1
			Rename poly_1, $poly_name_1
			Rename poly_2, $poly_name_2
			Rename row_1, $row_1_s
			Rename row_2, $row_2_s
			Rename column_1, $col_1_s
			Rename column_2, $col_2_s
			Rename position_1, $pos_s_1
			Rename position_2, $pos_s_2	
			//DoWindow/k select_area
		endif
		if(v_value_ ==17)
			area_calc = 40
			Prompt area_calc, "Enter area_calc"
			DoPrompt "area_calc", area_calc
		
		
			firstpixel = "firstpixel_ab_bc" + num2str(i)
			secondpixel = "secondpixel_ab_bc" + num2str(i) 
			Make/N = (floor(numberofrows[i]/bin) * (floor(numberofcolumns[i]/bin)-2)*2)/O/D w1
			Make/N = (floor(numberofrows[i]/bin) * (floor(numberofcolumns[i]/bin)-2)*2)/O/D w2
			l= 0
			for (j = 0; j<(floor(numberofrows[i]/bin)); j= j+1)
				for (k = 1; k<(floor(numberofcolumns[i]/bin)-1); k= k+1)
					w1[l] = j*numberofcolumns[i]*bin + k*bin
					w2[l] = j*numberofcolumns[i]*bin + k*bin + bin
					l = l+1
					w1[l] =j*numberofcolumns[i]*bin + k*bin 
					w2[l] = j*numberofcolumns[i]*bin + k*bin-bin
					l= l+1
				Endfor
			Endfor
	
	
	
			if(logarithmiccorrelation == 1)
	
				if ( LastFrame - FirstFrame < lagtime_check[ (channel1 + (channel2-1)*channel1/2)-1])
					print "The suggested number of frames is not sufficient to carry out correlations for the chosen number of channels in file numbered", i
					continue
				endif
	
				tif_program(FolderFileList[i], output_corr[i], output_int[i], FirstFrame, LastFrame, Background_for_program, Bin, channel1, channel2,w1,w2)
				GBLoadWave/Q/B/A=corr/T={2,2}/W=(floor(numberofrows[i]/bin) * (floor(numberofcolumns[i]/bin)-2)*2)/U=(channel1 + (channel2-1)*channel1/2) output_corr[i]
				DeleteFile output_int[i]
				DeleteFile  output_corr[i]
			else
	
				print "linearmode of correlation" 
				if ( LastFrame - FirstFrame < linearpoints)
					print "The suggested number of frames is not sufficient to carry out correlations for the chosen number of points in file numbered " ,i 
					continue
				endif
	
				linear_acf(FolderFileList[i], output_corr[i], output_int[i], FirstFrame, LastFrame, Background_for_program, Bin, linearpoints,w1,w2)
				GBLoadWave/Q/B/A=corr/T={2,2}/W=(floor(numberofrows[i]/bin) * (floor(numberofcolumns[i]/bin)-2)*2)/U=(linearpoints) output_corr[i]
				DeleteFile output_int[i]
				DeleteFile  output_corr[i]
			endif
	
			display_counter = 0
	
	
			for ( 	m =0; m <(floor(numberofrows[i]/bin) * (floor(numberofcolumns[i]/bin)-2)*2); m= m+1)
				graph_name = "corr" + num2str(m)
				graph_rename =basename + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m])
				Rename $graph_name, $graph_rename
				if(display_counter==0)
					Display $graph_rename vs lagtime
					display_counter = display_counter+1
				else
					AppendTograph $graph_rename vs lagtime
					display_counter = display_counter + 1
				endif
	
			endfor
			ModifyGraph log(bottom)=1
	

			newtemp1 = "area_value_ab_bc" + num2str(i)
			Make/O/N = (floor(numberofrows[i]/bin) , floor(numberofcolumns[i]/bin)-2) wave_temp_area

			//string temp1_2 , temp2_2, temp3_2
	
			if(logarithmiccorrelation == 1)
	
				for ( 	m =0; m <(floor(numberofrows[i]/bin) * (floor(numberofcolumns[i]/bin)-2)*2); m= m+2)
					temp1_2=basename + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m])
					temp2_2=basename + "_" + num2str(i) + "_" + num2str(w1[m+1]) + "_" +num2str(w2[m+1])
					temp3_2 = "sub" + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m]) + "_______" +  num2str(w1[m+1]) + "_" +num2str(w2[m+1]) 
					Make/O/D/N =(channel1 + (channel2-1)*8) w1_2
					Wave w1_2 = $temp1_2
					Make/O/D/N = (channel1 + (channel2-1)*8) w2_2
					Wave w2_2 = $temp2_2
					Make/O/D/N=(channel1 + (channel2-1)*8) $temp3_2
					Wave w3_2 = $temp3_2
					w3_2 = (w1_2- w2_2)/(w1_2[1] + w2_2[1]-2)
					wave_temp_area[floor(w1[m]/bin/numberofcolumns[i])][floor(w1[m]/bin) -floor(w1[m]/bin/numberofcolumns[i])*numberofcolumns[i] -1] = areaXY(lagtime, w3_2,0, lagtime[area_calc])
				ENDfor
	
			else
	
				for ( 	m =0; m <(floor(numberofrows[i]/bin) * (floor(numberofcolumns[i]/bin)-2)*2); m= m+2)
					temp1_2=basename + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m])
					temp2_2=basename + "_" + num2str(i) + "_" + num2str(w1[m+1]) + "_" +num2str(w2[m+1])
					temp3_2 = "sub" + "_" + num2str(i) + "_" + num2str(w1[m]) + "_" +num2str(w2[m]) + "_______" +  num2str(w1[m+1]) + "_" +num2str(w2[m+1]) 
					Make/O/D/N =(linearpoints-1) w1_2
					Wave w1_2 = $temp1_2
					Make/O/D/N = (linearpoints-1) w2_2
					Wave w2_2 = $temp2_2
					Make/O/D/N=(linearpoints-1) $temp3_2
					Wave w3_2 = $temp3_2
					w3_2 = (w1_2- w2_2)
					wave_temp_area[floor(w1[m]/bin/numberofcolumns[i])][floor(w1[m]/bin) -floor(w1[m]/bin/numberofcolumns[i])*numberofcolumns[i]-1] = areaXY(lagtime, w3_2,0, lagtime[linearpoints-1 ])
				ENDfor 

			endif
	
			Display;AppendImage wave_temp_area
			ModifyGraph swapXY=1
			SetAxis/A/R left
			
			
			ModifyGraph width=151.2,height={Aspect,1}
			ModifyGraph swapXY=1
			SetAxis/A/R left
					
			ColorScale/C/N=text0/F=0/A=MB/E vert=0,lowTrip=0.01, width=87
			ColorScale/C/N=text0 nticks=3	
	
			rename w1, $firstpixel
			rename w2, $secondpixel
			Rename wave_temp_area, $newtemp1

		endif

	endfor
	
	ControlInfo/W=ITIRFCCSMainControl_new sd_display1
	NVAR sd_display = root:ITIRFCCS:sd_display
	sd_display = V_Value
	ControlInfo/W=ITIRFCCSMainControl_new koppel
	variable koppel_t = v_value
	if (sd__ == 1)
		if(changer_cha ==1)
			print "hello"
			autocorr_sd()
		endif
		if(koppel_t ==1)
			print "koppel"
			FCSKoppelWeightWave1()
		endif
	endif
	//DeleteFile output_minimum[i]
	//doupdate
	CursorGlobalsForGraph()
	CursorDependencyForGraph()
	CursorMoved( "corr_dis", 0)
End

Function UserCursorAdjust_Proc1(ctrlName) : ButtonControl
	String ctrlName  
	wave numberofrows = root:ITIRFCCS:numberofrows
	wave numberofcolumns = root:ITIRFCCS:numberofcolumns
	NVAR i = root:ITIRFCCS:i
	KillControl abc
	FindPointsinPoly w2_ccf, w1_ccf,xxxx,yyyy  
	//print w_inpoly
	//Display;AppendImage W_inPoly
	//SetAxis/A/R left
	
	Rename w_inpoly, poly_1
	DoWindow/F select_area
	DoWindow/K select_area

End



Function UserCursorAdjust_Proc2(ctrlName) : ButtonControl
	String ctrlName 
	NVAR i = root:ITIRFCCS:i
	KillControl abc1 
	wave numberofrows = root:ITIRFCCS:numberofrows
	wave numberofcolumns = root:ITIRFCCS:numberofcolumns
	FindPointsinPoly  w2_ccf,w1_ccf,xxxx1, yyyy1

	Rename w_inpoly, poly_2
	DoWindow/F select_area
	DoWindow/K select_area
	
	//print "lll"
end
Function algorithm_choose(name, value)

	String name
	Variable value
	
	strswitch(name)
			NVAR logarithmiccorrelation= root:ITIRFCCS:logarithmiccorrelation

		case "linearcorrelator":
			NVAR logarithmiccorrelation= root:ITIRFCCS:logarithmiccorrelation
			logarithmiccorrelation = 0
			//CheckBox linearcorrelator, value = 1
			//CheckBox logarithmiccorrelator, value = 0
			SetVariable channel1, disable = 1,title="Group1_ch_n ", fsize=10, font="Arial", pos={170,160},size={110,25},frame=1, limits={1,99,1},value = Channel1
			SetVariable channel2, disable = 1, title="Group_n          ", fsize=10, font="Arial", pos={170,190},size={110,25},frame=1, limits={1,99,1},value = Channel2
			
			
			SetVariable linearpoints, disable = 0, title="Points", fsize=10, font="Arial", pos={170,160},size={110,25},frame=1, limits={1,10000,1},value = linearpoints
			break
	
		Case "logarithmiccorrelator":
			NVAR logarithmiccorrelation= root:ITIRFCCS:logarithmiccorrelation
			logarithmiccorrelation = 1
			//CheckBox linearcorrelator, value = 0 
			//CheckBox logarithmiccorrelator, value = 1

			SetVariable channel1, disable = 0,title="Group1_ch_n ", fsize=10, font="Arial", pos={170,160},size={120,25},frame=1, limits={1,99,1},value = Channel1
			SetVariable channel2, disable = 0,title="Group_n          ", fsize=10, font="Arial", pos={170,190},size={120,25},frame=1, limits={1,99,1},value = Channel2
			SetVariable linearpoints, disable = 1, title="Points", fsize=10, font="Arial", pos={170,160},size={110,25},frame=1, limits={1,10000,1},value = linearpoints
			break
			
			
	EndSwitch


End
Function fitmodel_choose(name, value)

	String name
	Variable value
	NVAR ITIRFCCS_mod = root:ITIRFCCS:ITIRFCCS_mod
	NVAR spim_mod = root:ITIRFCCS:spim_mod
	NVAR sigz_hold = root:ITIRFCCS:sigz_hold
	strswitch(name)
			//	NVAR logarithmiccorrelation= root:ITIRFCCS: logarithmiccorrelation

		case "ITIRFCCS_model":
			
			spim_mod = 0
			ITIRFCCS_mod = 1 
			CheckBox ITIRFCCS_model, value = 1
			CheckBox spim_model, value = 0
			//SetVariable sigz, disable = 0,title="sig z", fsize=10, font="Arial", pos={490,160},size={110,25},frame=1, limits={0.1,1,0.01},value = sigz
			//SetVariable channel2, disable = 1, title="Group_n          ", fsize=10, font="Arial", pos={170,190},size={110,25},frame=1, limits={1,99,1},value = Channel2
			SetVariable  sigz, disable = 1,title = "sig z ", fsize = 12, font  = "Arial", pos = {160,445}, size = {80,25}, frame = 1, limits = {0,1, 0.01},value = sigz

	
			CheckBox sigz_hold title="Fix", disable = 1, pos={250,445}, size={14,14}, mode=0, value=sigz_hold
			
			
			SetVariable  lambda_exc, title = "WL Exc", disable = 1, fsize = 12, font  = "Arial", pos = {160, 535}, size = {120,25}, frame = 1, limits = {1e-8,1e-6, 1e-8},value = lambda_exc
			SetVariable NA_exc, title = "NA Exc", disable = 1, fsize = 12, font  = "Arial", pos = {10,535}, size = {90,25}, frame = 1, limits = {0.1,2, 0.1},value = NA_exc
	
			//SetVariable linearpoints, disable = 0, title="Points", fsize=10, font="Arial", pos={170,160},size={110,25},frame=1, limits={1,10000,1},value = linearpoints
			break
	
		Case "spim_model":
			//NVAR logarithmiccorrelation= root:ITIRFCCS: logarithmiccorrelation
			//logarithmiccorrelation = 1
			CheckBox ITIRFCCS_model, value = 0
			CheckBox spim_model, value = 1
			spim_mod = 1
			ITIRFCCS_mod = 0
			
			SetVariable  sigz, disable = 0,title = "sig z ", fsize = 12, font  = "Arial", pos = {160,445}, size = {80,25}, frame = 1, limits = {0,1, 0.01},value = sigz
			CheckBox sigz_hold title="Fix", disable = 0, pos={250, 445}, size={14,14}, mode=0, value=sigz_hold
			SetVariable  lambda_exc, title = "WL Exc", disable = 0, fsize = 12, font  = "Arial", pos = {160, 535}, size = {120,25}, frame = 1, limits = {1e-8,1e-6, 1e-8},value = lambda_exc
			SetVariable NA_exc, title = "NA Exc", disable = 0, fsize = 12, font  = "Arial", pos = {10,535}, size = {90,25}, frame = 1, limits = {0.1,2, 0.1},value = NA_exc
	
			break
			
			
	EndSwitch


End



Function MyCheckProc_new(name,value)

	String name
	Variable value
	
	NVAR FirstFrame= root:ITIRFCCS:FirstFrame
	NVAR LastFrame = root:ITIRFCCS:LastFrame
	NVAR Background = root:ITIRFCCS:Background
	NVAR gRadioVal= root:ITIRFCCS:gRadioVal

	strswitch (name)

		case "BGRFile":

			gRadioVal= 1
			CheckBox BGRFile,value= gRadioVal==1
			CheckBox BGRConstant,value= gRadioVal==2

			String outputPath, outputpath1, outputpathtxt, outputpathwithextension, outputpathwithextensiontime
			String filepath
			Variable position
			Open/D/R/M="Select a file" refNum
			outputPath1 = S_fileName
			outputPath = ParseFilePath(5, outputpath1, "\\", 1, 0)
			position = strsearch(outputPath, ".tif", 0)
			if(position ==-1)
				print "Choose a tif file"
				CheckBox BGRConstant,value= 1
				CheckBox BGRFile,value= 0
				return -1
			endif
			filepath = ParseFilePath(1, outputpath, "\\", 1, 0)
			outputpathtxt = RemoveEnding(outputpath, ".tif")
			outputpathwithextension =  outputpathtxt + ".txt"
	
			Variable nooffiles_background

			if (FirstFrame > LastFrame)
				print "The firstframe cannot be greater than the last frame"
				CheckBox BGRConstant,value= 1
				CheckBox BGRFile,value= 0
				return -1
			endif
	
			Background=all_tif_corr(outputpath, outputpathwithextension)
			CheckBox BGRConstant,value= 1
			CheckBox BGRFile,value= 0
			Print "The background was updated to ", Background
			break

		case "BGRConstant":
			gRadioVal= 2
			//minimum_for_program = Background 
			//print minimum_for_program
			//print TimeLag
			CheckBox BGRFile,value= gRadioVal==1
			CheckBox BGRConstant,value= gRadioVal==2
			break
	endswitch
	CheckBox BGRConstant,value= 1
	//TitleBox tb1,title=outputpath1,disable = 0,pos={323,70},size={260,30}
End

Function UserCursorAdjust_ContButtonProc(ctrlName) : ButtonControl
	String ctrlName 
	String format
	Variable/G mar_left, mar_top, mar_right, mar_bottom

	GetMarquee/K left, bottom
	mar_left =  floor(V_left)
	mar_top = floor(V_top)
	mar_right = floor(V_right) 
	mar_bottom= floor(V_bottom)
	//DoWindow/F Graph0
	DoWindow/K Graph0
	
End

Function bleach_corr(ctrlName) : ButtonControl
	String ctrlname
	NVAR bleachexpov = root:ITIRFCCS:bleachexpov
	if (bleachexpov ==1)
		exp_fit()
	else
		sliding_window()
	endif
end


//////*******************************************************
//////The correlation curves are fitted here in this function
Function CurveFitting(ctrlName) : ButtonControl
	String ctrlName
	String dfSave=GetDataFolder(1) 
	SetDataFolder root:ITIRFCCS 
	//Make/O/D/N = 12 W_coef
	NVAR D = root:ITIRFCCS:D
	NVAR D1 = root:ITIRFCCS:D1
	NVAR q = root:ITIRFCCS:q
	NVAR lambda = root:ITIRFCCS:lambda
	NVAR sigma = root:ITIRFCCS:sigma 
	NVAR channel1 = root:ITIRFCCS:channel1 
	NVAR channel2 = root:ITIRFCCS:channel2
	NVAR linearpoints = root:ITIRFCCS:linearpoints
	NVAR N = root:ITIRFCCS:N
	NVAR pixel = root:ITIRFCCS:pixel
	NVAR NA = root:ITIRFCCS:NA
	NVAR Bin = root:ITIRFCCS:Bin
	NVAR vx = root:ITIRFCCS:vx
	NVAR vy = root:ITIRFCCS:vy
	NVAR fit_check = root:ITIRFCCS:fit_check
	fit_check = fit_check + 1
	NVAR xwave_scale = root:ITIRFCCS:xwave_scale
	NVAR PanelPosL= root:ITIRFCCS:PanelPosL
	NVAR PanelPosT= root:ITIRFCCS:PanelPosT
	NVAR PanelPosR= root:ITIRFCCS:PanelPosR
	NVAR PanelPosB= root:ITIRFCCS:PanelPosB
	//Dowindow/F Corr_Dis
	
	Button fit_pixel pos={170,295}, size={50, 24}, fsize=10, font="Arial", title="Fit Pixel", proc=fit_Pixel
	SetVariable Bin disable = 2
	PopupMenu SelectCor disable = 2
	SetVariable basename, disable = 1
	SetVariable background, disable = 2

	//GroupBox Background_BOX title="Background ", pos={5,215},size={285,80}
	CheckBox BGRFile disable = 2
	CheckBox BGRConstant disable = 2

	Button Correlate disable = 2
		
	NVAR logarithmiccorrelation = root:ITIRFCCS:logarithmiccorrelation
	SVAR basename = root:ITIRFCCS:basename
	
	ControlInfo fittingparameter
	variable fit_value  = V_Value
	Variable V_FitQuitReason = 0
	
	ControlInfo fittingparameter_D
	variable D_fit_value = V_Value
	
	ControlInfo fittingparameter_vx
	variable vx_fit_value = V_value
	
	ControlInfo fittingparameter_vy
	variable vy_fit_value = V_value
	
	ControlInfo fittingparameter_N
	variable N_fit_value = V_value
	ControlInfo sigz_hold
	variable/G sigz_hold1 =V_value
	//Controlinfo
		
	wave lagtime = root:ITIRFCCS:lagtime
	wave successfulfiles = root:ITIRFCCS:successfulfiles
	wave numberofrows = root:ITIRFCCS:numberofrows
	wave numberofcolumns = root:ITIRFCCS:numberofcolumns
	NVAR particle = root:ITIRFCCS:particle

	if(particle==1)
		Make/O/D/N = 12 W_coef
	endif
	if(particle==2)
		Make/O/D/N = 14 W_coef
		//	Variable D1 = 7e-14
		//	Variable N1= 0.025 
	endif

	wavestats/Q Successfulfiles
	variable success_files =V_npnts
	String Diff_co, Number, sig, DC, chisq, fir_pix_fit_str, sec_pix_fit_str, wave_fit_name, reason1, vel_x, vel_y, sigz_s
	If(particle==2)
		String diff_co1, number1
	endif
	variable i, m, loop1
	variable num_each_file, corr_type
	ControlInfo/W=ITIRFCCSMainControl_new SelectCor
	corr_type = V_Value
	
	String graphname
	Variable chosenfile
	Variable V_fitoptions = 4
	//String graphnamestr = corr_dis
	//print xcsr(A,"corr_dis")+100
	Dowindow/F corr_dis
	variable/G fitrange_begin=xcsr(A)
	//	print fitrange_begin
	variable/G fitrange_end=xcsr(B)
	//	Print fitrange_end
	variable temp_new
	if (fitrange_end < fitrange_begin)
		temp_new = fitrange_begin
		fitrange_begin = fitrange_end
		fitrange_end = temp_new
	endif
	
	
	 
	for (i = 0; i< success_files; i=i+1)
	
		vel_x = "vel_x_" + num2str(successfulfiles[i])
		vel_y = "vel_y_" + num2str(successfulfiles[i])
		Diff_co = "Diff_co_"+num2str(successfulfiles[i])
		Number = "Number_" + num2str(successfulfiles[i])
		sig = "sig_" + num2str(successfulfiles[i])
		sigz_s = "sigz_" + num2str(successfulfiles[i])
		DC= "DC_" + num2str(successfulfiles[i])
		chisq = "chisq_" + num2str(successfulfiles[i])
		reason1 = "reason1_" + num2str(successfulfiles[i])
		if(particle==2)
			Diff_co1 = "Diff_co_1_"+num2str(successfulfiles[i])
			Number1 = "Number_1_" + num2str(successfulfiles[i])
		endif
		

		fir_pix_fit_str = "firstpixel" + num2str(successfulfiles[i])
		Wave fir_pixelfit = root:ITIRFCCS:$fir_pix_fit_str

		sec_pix_fit_str = "secondpixel" + num2str(successfulfiles[i])
		Wave sec_pixelfit = root:ITIRFCCS:$sec_pix_fit_str
	
		Wavestats/Q sec_pixelfit
		num_each_file = V_npnts
	
		Make/N=(num_each_file)/O w_diff_co
		Make/N =(num_each_file)/O w_number
		Make/N = (num_each_file)/O w_sig 
		Make/N = (num_each_file)/O w_dc 
		Make/N = (num_each_file)/O w_chisq 
		Make/N = (num_each_file)/O w_reason1 
		Make/N = (num_each_file)/O w_vel_x
		Make/N = (num_each_file)/O w_vel_y
				
		NVAR itirfccs_mod = root:ITIRFCCS:itirfccs_mod
		NVAR spim_mod = root:ITIRFCCS:spim_mod
		NVAR sigz = root:ITIRFCCS:sigz
		NVAR lambda_exc = root:ITIRFCCS:lambda_exc
		NVAR NA_exc = root:ITIRFCCS:NA_exc
		//NVAR sigz_hold = root:ITIRFCCS:sigz_hold
		if (spim_mod ==1)
			Make/N = (num_each_file)/O w_sigz
		endif
		if(particle==2)
			Make/N=(num_each_file)/O w_diff_co1
			Make/N =(num_each_file)/O w_number1
		endif
		String fitted_name
		Nvar sd__ =  root:ITIRFCCS:sd__
		//print "fittin1"
		//print time()
		ControlInfo/W=ITIRFCCSMainControl_new split_frame
		variable new_spl = V_value
		//Variable V_FitNumIters=100 
		if(corr_type ==1)
	
			variable display_counter = 0
	
			for ( 	m =0; m <(floor(numberofrows[successfulfiles[i]]/bin) * floor(numberofcolumns[successfulfiles[i]]/bin)); m= m+1)
				//fitted_name = "fit_" + basename + "_" + num2str(successfulfiles[i]) + "_" + num2str(fir_pixelfit[m]) + "_" +num2str(sec_pixelfit[m])
				wave_fit_name =basename + "_" + num2str(successfulfiles[i]) + "_" + num2str(fir_pixelfit[m]) + "_" +num2str(sec_pixelfit[m])
				//make/N = (channel1 + (channel2-1)*8)/O $fittedname
				//wave w1_fit = $fitted_name
				Wave w1 = root:ITIRFCCS:$wave_fit_name
				if(sd__==1)
					if(new_spl==1)
						wave_fit_name ="av_file_0_pixel_" + num2str(fir_pixelfit[m])  
					endif
				endif
				if(display_counter==0)
				
					Display/N =newstring $wave_fit_name[fitrange_begin,fitrange_end] vs lagtime[fitrange_begin,fitrange_end]
					display_counter = display_counter+1
				else
					AppendTograph $wave_fit_name[fitrange_begin,fitrange_end] vs lagtime[fitrange_begin,fitrange_end]
					//display_counter = display_counter + 1
				endif
			endfor
			ModifyGraph log(bottom)=1
			
			String weight_name
			if (spim_mod ==1)
				//print sigz_hold1  
				if (particle==1)
					Make/O/D/N = 15 W_coef
					W_coef=  {0,0,vx,vy, Bin, D, lambda,  NA,  N,1,sigma,pixel, SIGZ, lambda_exc, NA_exc}
				endif
				if(particle==2)
					Make/O/D/N = 17 W_coef
					W_coef=  {0,0,vx,vy, Bin, D, lambda,  NA,  N,1,sigma,pixel, SIGZ, lambda_exc, NA_exc, D1, q}
				endif
			endif
			//print winname(0,1)
			wave w_coef
			NewPanel /N=ProgressPanel /W=(285,711,739,793)
			ValDisplay valdisp0,pos={18,32},size={342,18}
			ValDisplay valdisp0,limits={0,(floor(numberofrows[successfulfiles[i]]/bin) * floor(numberofcolumns[successfulfiles[i]]/bin)),0},barmisc={0,0}
			ValDisplay valdisp0,value= _NUM:0
			Button bStop,pos={375,32},size={50,20},title="Stop" 
			DoUpdate /W=ProgressPanel /E=1// mark this as our progress window

			
			
			for ( 	m =0; m <(floor(numberofrows[successfulfiles[i]]/bin) * floor(numberofcolumns[successfulfiles[i]]/bin)); m= m+1)
				
				ValDisplay valdisp0,value= _NUM:m+1,win=ProgressPanel
				//endif
				DoUpdate /W=ProgressPanel
				//print m
				//		dowindow/B newstring
				//Dowindow/F Choose_pixel
				wave_fit_name =basename + "_" + num2str(successfulfiles[i]) + "_" + num2str(fir_pixelfit[m]) + "_" +num2str(sec_pixelfit[m])
				String fit_wave_fit_name ="fit_" + basename + "_" + num2str(successfulfiles[i]) + "_" + num2str(fir_pixelfit[m]) + "_" +num2str(sec_pixelfit[m])
				//	print fit_wave_fit_name
				
				Wave w1 = root:ITIRFCCS:$wave_fit_name

				 	
				if (itirfccs_mod ==1)
					if(particle==1)
						W_coef=  {0,0,vx,vy, Bin/2, D, lambda, NA, N,1,sigma,pixel}
					endif
					if(particle==2)
						W_coef=  {0,0,vx,vy, Bin/2, D, lambda, NA, N,1,sigma,pixel, D1, q}
						Make/O/T/N=2 T_Constraints
						T_Constraints[0] = {"K13 > 0","K13 < 1"}
						ControlInfo/W=ITIRFCCSMainControl_new fittingparameter_D1
						Variable hold_D1= V_value
						Controlinfo/W=ITIRFCCSMainControl_new fittingparameter_q
						Variable hold_q= V_value
						//print "11" + num2str(vx_fit_value) + num2str(vy_fit_value) + "1" + num2str(D_fit_value) + "11"+num2str(N_fit_value)+"0" + num2str(fit_value) +"1" + num2str(hold_d1) + num2str(hold_q)
					endif
					if(logarithmiccorrelation ==1)  
						if(particle==1)
							if(sd__ ==1)
								weight_name = "SD_file_0_pixel_" + num2str(fir_pixelfit[m])
								Wave w2 = root:ITIRFCCS:$weight_name
								if(new_spl==1)
									wave_fit_name ="av_file_0_pixel_" + num2str(fir_pixelfit[m])  
								endif
								Wave w1 = root:ITIRFCCS:$wave_fit_name
								FuncFit /N=1 /q/H="11" + num2str(vx_fit_value) + num2str(vy_fit_value) + "1" + num2str(D_fit_value) + "11" +num2str(N_fit_value)+"0" + num2str(fit_value) +"1"  ITIRFCCS_fit W_coef  w1[fitrange_begin,fitrange_end]/X=lagtime/w=w2/D/R/A=0/I=1;  
							
							else
								try
									FuncFit /N=1 /q/H="11" + num2str(vx_fit_value) + num2str(vy_fit_value) + "1" + num2str(D_fit_value) + "11" +num2str(N_fit_value)+"0" + num2str(fit_value) +"1"  ITIRFCCS_fit W_coef  w1[fitrange_begin,fitrange_end]/X=lagtime/D/R/A=0; AbortonRTE
									//FuncFit/H="111110110011"/N=1/x=1/q ITIRFCCS_fit W_coef  w1[10,60] /X=lagtime /D /R /A=0
								catch
									if (V_AbortCode == -4)
										//Print "Error during curve fit:"
										Variable CFerror = GetRTError(1) // 1 to clear the error
										//Print GetErrMessage(CFerror)
										w_coef = nan
									endif
								endtry
								//endif
							endif 
						endif
						if(particle==2) 
							//print 
							FuncFit /N=1/q/H="11" + num2str(vx_fit_value) + num2str(vy_fit_value) + "1" + num2str(D_fit_value) + "11"+num2str(N_fit_value)+"0" + num2str(fit_value) +"1" + num2str(hold_d1) + num2str(hold_q)  ITIRFCCS_fit_2 W_coef  w1[fitrange_begin,fitrange_end]/X=lagtime/D/R/A=0/C=T_Constraints 
							//	FuncFit /N=1 /H="11" + num2str(vx_fit_value) + num2str(vy_fit_value) + "1" + num2str(D_fit_value) + "11"+num2str(N_fit_value)+"0" + num2str(fit_value) +"1" + num2str(hold_d1) + num2str(hold_q)  ITIRFCCS_fit_2 W_coef  w1[1,channel1 + (channel2-1)*channel1/2-1]/X=lagtime/D/R/A=0/C=T_Constraints 
					
						endif
					else 
						print "linear"
						FuncFit /x=1/q /H="11" + num2str(vx_fit_value) + num2str(vy_fit_value)  +"1" + num2str(D_fit_value) + "1100" + num2str(fit_value) +"1" ITIRFCCS_fit W_coef  w1[1,linearpoints-1]/X=lagtime/D
					endif
	
				endif
			
				if (spim_mod ==1)
					if (particle==1)
						if(sd__ ==1)
							weight_name = "SD_file_0_pixel_" + num2str(fir_pixelfit[m])
							Wave w2 = root:ITIRFCCS:$weight_name
							wave_fit_name ="av_file_0_pixel_" + num2str(fir_pixelfit[m])  
							Wave w1 = root:ITIRFCCS:$wave_fit_name
							FuncFit/N=1 /q/H="11" + num2str(vx_fit_value) + num2str(vy_fit_value) + "1" + num2str(D_fit_value) + "11"+num2str(N_fit_value)+"0" + num2str(fit_value) +"1"+ num2str(sigz_hold1) + "11"  ITIRFCCS_spim W_coef   w1[fitrange_begin,fitrange_end]/X=lagtime/w=w2/D/R/A=0/I=1
						
							
						else
							FuncFit/N=1 /q/H="11" + num2str(vx_fit_value) + num2str(vy_fit_value) + "1" + num2str(D_fit_value) + "11"+num2str(N_fit_value)+"0" + num2str(fit_value) +"1"+ num2str(sigz_hold1) + "11"  ITIRFCCS_spim W_coef   w1[fitrange_begin,fitrange_end]/X=lagtime/D/R/A=0
						endif
					endif
					if (particle==2)
							
				
						Make/O/T/N=2 T_Constraints
						T_Constraints[0] = {"K16 > 0","K16 < 1"}
						ControlInfo/W=ITIRFCCSMainControl_new fittingparameter_D1
						hold_D1= V_value
						Controlinfo/W=ITIRFCCSMainControl_new fittingparameter_q
						hold_q= V_value 
						//print "11" + num2str(vx_fit_value) + num2str(vy_fit_value) + "1" + num2str(D_fit_value) + "11"+num2str(N_fit_value)+"0" + num2str(fit_value) +"1" + num2str(hold_d1) + num2str(hold_q)
						FuncFit/N=1 /q/H="11" + num2str(vx_fit_value) + num2str(vy_fit_value) + "1" + num2str(D_fit_value) + "11"+num2str(N_fit_value)+"0" + num2str(fit_value) +"1"+ num2str(sigz_hold1) + "11"+ num2str(hold_d1) + num2str(hold_q)  ITIRFCCS_spim_2 W_coef   w1[fitrange_begin,fitrange_end]/X=lagtime/D/R/A=0
						
					endif
											
				endif

				if(m==0)
					if(sd__==1)
						if(new_spl==1)
							String yaxis_name= "fit_av_file_0_pixel_" + num2str(fir_pixelfit[m])  
						else
							yaxis_name = "fit_" + basename + "_" + num2str(successfulfiles[i]) + "_" + num2str(fir_pixelfit[m]) + "_" +num2str(sec_pixelfit[m])
						endif
					else
						yaxis_name = "fit_" + basename + "_" + num2str(successfulfiles[i]) + "_" + num2str(fir_pixelfit[m]) + "_" +num2str(sec_pixelfit[m])
					endif
					wave wave_fittedyaxis= root:ITIRFCCS:$yaxis_name
					//print wave_fittedyaxis
				
					wavestats/q wave_fittedyaxis 
					if(V_Sum ==0)
						w_coef[8] = w_coef[8] + 0.1
						if(itirfccs_mod ==1)
							if(particle==2) 
								//print 
								FuncFit /N=1/q/H="11" + num2str(vx_fit_value) + num2str(vy_fit_value) + "1" + num2str(D_fit_value) + "11"+num2str(N_fit_value)+"0" + num2str(fit_value) +"1" + num2str(hold_d1) + num2str(hold_q)  ITIRFCCS_fit_2 W_coef  w1[1,channel1 + (channel2-1)*channel1/2-1]/X=lagtime/D/R/A=0/C=T_Constraints 
							else
								//FuncFit /x=1/q/H="11" + num2str(vx_fit_value) + num2str(vy_fit_value) + "1" + num2str(D_fit_value) + "11" +num2str(N_fit_value)+"0" + num2str(fit_value) +"1"  ITIRFCCS_fit W_coef  w1[1,channel1 + (channel2-1)*channel1/2-1]/X=lagtime/D
								FuncFit /N=1 /q/H="11" + num2str(vx_fit_value) + num2str(vy_fit_value) + "1" + num2str(D_fit_value) + "11" +num2str(N_fit_value)+"0" + num2str(fit_value) +"1"  ITIRFCCS_fit W_coef  w1[fitrange_begin,fitrange_end]/X=lagtime/D/R/A=0; 
							endif
						else
							FuncFit/N=1 /q/H="11" + num2str(vx_fit_value) + num2str(vy_fit_value) + "1" + num2str(D_fit_value) + "1100" + num2str(fit_value) +"1"+ num2str(sigz_hold1) + "11"  ITIRFCCS_spim W_coef  w1[1,channel1 + (channel2-1)*channel1/2-1]/X=lagtime/D/R/A=0
						endif
					endif
					//variable V_fiterror
					//				if (V_fiterror == 8)
					//				W_coef= nan
					//				endif
					if(sd__==1)
						if(new_spl==1)
							
							String xaxis_name= "fitx_av_file_0_pixel_" + num2str(fir_pixelfit[m])  
						endif
					else
						xaxis_name = "fitX_" + basename + "_" + num2str(successfulfiles[i]) + "_" + num2str(fir_pixelfit[m]) + "_" +num2str(sec_pixelfit[m]) 
					endif
					wave wave_fittedxaxis= root:ITIRFCCS:$xaxis_name
					//print wave_fittedxaxis
					//				//RemoveFromGraph  $wave_fit_name, $fit_wave_fit_name
				endif 
				//				If(m>0)
				//				RemoveFromGraph  $wave_fit_name, $fit_wave_fit_name
				//				endif 

				w_reason1[m] = V_FitQuitReason
  
				if(V_FitQuitReason == 0 && w_coef[5] >= 0 &&  w_coef[8] > 0 && w_coef[10]  >=0)
					if (itirfccs_mod ==1)
						w_diff_co[m] = W_coef[5]
						w_sig[m] = w_coef[10]
						w_chisq[m] = V_chisq
						w_number[m] = w_coef[8]
						w_dc[m] = w_coef[9]
						w_vel_x[m] = w_coef[2]
						w_vel_y[m] = w_coef[3]
						if(particle==2)
							w_diff_co1[m] = W_coef[12]
							w_number1[m] = w_coef[13]
						endif
					endif
					if(spim_mod==1)
						w_diff_co[m] = W_coef[5]
						w_sig[m] = w_coef[10]
						w_chisq[m] = V_chisq
						w_number[m] = w_coef[8]
						w_dc[m] = w_coef[9]
						w_vel_x[m] = w_coef[2]
						w_vel_y[m] = w_coef[3]
						w_sigz[m]=w_coef[12]
						if(particle==2)
							w_diff_co1[m] = W_coef[15]
							w_number1[m] = w_coef[16]
						endif
					endif
					//					if(particle==2)
					//						w_diff_co1[m] = W_coef[12]
					//						w_number1[m] = w_coef[13]
					//					endif
	
				else
	
					if (itirfccs_mod ==1)
						w_diff_co[m] = nan
						w_sig[m] = nan
						w_chisq[m] = nan
						w_number[m] = nan
						w_dc[m] = nan
						w_vel_x[m] = nan
						w_vel_y[m] = nan
						if(particle==2)
							w_diff_co1[m] = nan
							w_number1[m] = nan
						endif
					endif
					if(spim_mod==1)
						w_diff_co[m] = nan
						w_sig[m] = nan
						w_chisq[m] = nan
						w_number[m] = nan
						w_dc[m] = nan
						w_vel_x[m] =nan
						w_vel_y[m] = nan
						w_sigz[m]=nan
						if(particle==2)
							w_diff_co1[m] =nan
							w_number1[m] = nan
						endif
					endif
	
	
				endif
		
			endfor
			

			variable b
			
			//for (b = 0; b<channel1 + (channel2-1)*8; b = b+1)
			//w1_fit[i] =  ITIRFCCS_fit(W_coef, lagtime[b])
			//endfor
			/////////////////////////////////////////////////////
			NVAR fit_check = root:ITIRFCCS:fit_check
			//print "fit_check", fit_check
			if (fit_check >0)
				String fit_wave_d, fitx_wave_d
				fit_wave_d = "fit_corr_dis_" + num2str(successfulfiles[i])
				//fitx_wave_d = "fitx_corr_dis_" + num2str(successfulfiles[i])
				String residual_wave_corr
				
				residual_wave_corr = "residual_wave_corr" + "_" + num2str(successfulfiles[i])

				String graphname1
				//if (numtype(filenumber)==2)  
				//graphname1 = "corr_dis"
				//print "graphname -option10", graphname1
				//else
				if (successfulfiles[i] == 0)
					graphname1 = "corr_dis"
				else
					graphname1 = "corr_dis" + num2str(i-1)
				endif
				//print "graphname is", graphname1
				//endif
				Make/N =200/O $fit_wave_d = 0
				//Make/N =200/O $fitx_wave_d = 0
				Make/N =200/O $residual_wave_corr = 0
				String trial_xwave, xaxis_string
				//////////////////////////
				//trial_xwave= "fit_corr_" + num2str(successfulfiles[0])+ "_0_0"
			
				///////////////////////////////////////////////

				Make/N =200/O xaxis = 0
				
				for (b = 0; b<200; b =b+1)
					xaxis[b] = wave_fittedxaxis[b]
				endfor
				//////////////////////////////////
				//xwave_scale = deltax($trial_xwave)

				Appendtograph/w = $graphname1  $fit_wave_d vs xaxis
				wave qqq= root:ITIRFCCS:$fit_wave_d
				//wave rrr = root:ITIRFCCS:$xaxis_string
				//print "fdfd", rrr
				Make/N =(channel1 + (channel2-1)*channel1/2-1)/O $residual_wave_corr = 0
				//Make/N = (200)/O $display_wave_corr = 0
				Make/N =(channel1 + (channel2-1)*channel1/2-1)/O zeroline= 0
				Display/N = res_dis/I/W = (5.1,3, 7.1,4) $residual_wave_corr  vs lagtime
				ModifyGraph log(bottom)=1
				ModifyGraph rgb=(0,0,0)
				ModifyGraph width=100 
				Appendtograph zeroline vs lagtime 
			endif
			///////////////////////////////////////////////////	 	
				
			Redimension/N = (floor(numberofcolumns[successfulfiles[i]]/bin),floor(numberofrows[successfulfiles[i]]/bin)) w_diff_co
			//MatrixTranspose w_diff_co
			Redimension/N = (floor(numberofcolumns[successfulfiles[i]]/bin),floor(numberofrows[successfulfiles[i]]/bin)) w_sig
			//MatrixTranspose w_sig
			Redimension/N = (floor(numberofcolumns[successfulfiles[i]]/bin),floor(numberofrows[successfulfiles[i]]/bin)) w_DC
			//MatrixTranspose w_DC
			Redimension/N = (floor(numberofcolumns[successfulfiles[i]]/bin),floor(numberofrows[successfulfiles[i]]/bin)) w_chisq
			//MatrixTranspose w_chisq
			Redimension/N = (floor(numberofcolumns[successfulfiles[i]]/bin),floor(numberofrows[successfulfiles[i]]/bin)) w_number
			//MatrixTranspose w_number
			Redimension/N = (floor(numberofcolumns[successfulfiles[i]]/bin),floor(numberofrows[successfulfiles[i]]/bin)) w_vel_x
			//MatrixTranspose w_vel_x
			Redimension/N =(floor(numberofcolumns[successfulfiles[i]]/bin),floor(numberofrows[successfulfiles[i]]/bin)) w_vel_y
			if(spim_mod==1)
				Redimension/N = (floor(numberofcolumns[successfulfiles[i]]/bin),floor(numberofrows[successfulfiles[i]]/bin)) w_sigz
			endif
			//MatrixTranspose w_vel_y
			//Rename w_reason1, $reason1
			if(particle==2)
				Redimension/N =(floor(numberofcolumns[successfulfiles[i]]/bin),floor(numberofrows[successfulfiles[i]]/bin)) w_diff_co1
				Redimension/N =(floor(numberofcolumns[successfulfiles[i]]/bin),floor(numberofrows[successfulfiles[i]]/bin)) w_number1
			endif
			Duplicate/O w_diff_co, $Diff_co; KillWaves w_diff_co
	
			//Rename w_diff_co ,$Diff_co
			
			Duplicate/O w_sig,  $sig; KillWaves w_sig
			if(spim_mod==1)
				Duplicate/O w_sigz,  $sigz_s; KillWaves w_sigz
			endif
			//Rename w_sig, $sig
			Duplicate/O w_dc,  $DC; KillWaves w_dc
			//Rename w_dc , $DC
			Duplicate/O w_chisq, $chisq; KillWaves w_chisq
			//Rename w_chisq , $chisq
			Duplicate/O w_number, $Number; KillWaves w_number
			//Rename w_number, $Number
			Duplicate/O w_vel_x, $vel_x; KillWaves w_vel_x
			//Rename w_vel_x, $vel_x
			Duplicate/O w_vel_y,  $vel_y; KillWaves w_vel_y
			if(particle==2)
				Duplicate/O w_number1, $Number1; KillWaves w_number1
				Duplicate/O w_diff_co1, $diff_co1; KillWaves w_diff_co1
			endif
			
			
			variable bin1
			StatsQuantiles/iNaN/q Diff_co_0
			wavestats/q Diff_co_0
	
	
			StatsQuantiles/iNaN/q Number_0
			wavestats/q Number_0
			bin1 = ceil (V_npnts ^ (1/3) * (V_max - V_min)/2/V_IQR)
	
			Make/N=(Bin1)/O Number_0_Hist;

			if (V_avg - 3* V_sdev > 1e-16)
				Histogram/B={V_avg - 3* V_sdev,V_sdev*6/Bin1,Bin1} Number_0,Number_0_Hist
			else
				Histogram/B={0,V_sdev*6/Bin1,Bin1} Number_0,Number_0_Hist
			endif

			Display/I/W = (4.5, 4.35, 6.5, 6.85) Number_0_hist
			//Display/I/W = (2.5,0.5,4.5,2.5)   number_0_hist
			ModifyGraph mode=5
			ModifyGraph mirror=2
			//ModifyGraph width=151.2,height={Aspect,1}
			ModifyGraph useNegRGB=1,usePlusRGB=1,hbFill=2,rgb=(0,0,0); 
			ModifyGraph negRGB=(47872,47872,47872),plusRGB=(47872,47872,47872)
			TextBox/C/N=text0/F=0/Z=1/A=MT/E num2str(V_avg) + " +- " + num2str(V_sdev)
	

			//			StatsQuantiles/iNaN sig_0
			//			wavestats sig_0
			//			bin1 = ceil (V_npnts ^ (1/3) * (V_max - V_min)/2/V_IQR)
			//			Make/N=(Bin1)/O sig_0_Hist; 
			//			Histogram/B={V_min,(V_max-V_min)/Bin,Bin} sig_0,sig_0_Hist
			//			if (V_avg - 3* V_sdev > 1e-16)
			//				Histogram/B={V_avg - 3* V_sdev,V_sdev*6/Bin1,Bin1} sig_0,sig_0_Hist
			//			else
			//				Histogram/B={0,V_sdev*6/Bin1,Bin1} sig_0,sig_0_Hist
			//			endif
			//
			//				if (V_avg - 3* V_sdev > 1e-16)
			//				Histogram/B={V_avg - 3* V_sdev,V_sdev*6/Bin1,Bin1} sig_0,sig_0_Hist
			//				else
			//				Histogram/B={0,V_sdev*6/Bin1,Bin1} sig_0,sig_0_Hist
			//				endif
			//
			//			Display/I/W = (2.25,7.25,4.25, 9.75) sig_0_hist
			//			ModifyGraph mode=5
			//			ModifyGraph mirror=2
			//		//	ModifyGraph width=151.2,height={Aspect,1}
			//			ModifyGraph useNegRGB=1,usePlusRGB=1,hbFill=2,rgb=(0,0,0); 
			//			ModifyGraph negRGB=(47872,47872,47872),plusRGB=(47872,47872,47872)
			//			TextBox/C/N=text0/F=0/Z=1/A=MT/E num2str(V_avg) + " +- " + num2str(V_sdev)

	

	
	

			StatsQuantiles/iNaN/q DC_0 
			wavestats/q DC_0
			bin1 = ceil (V_npnts ^ (1/3) * (V_max - V_min)/2/V_IQR)
			Make/N=(Bin1)/O DC_0_Hist; 

			if (V_avg - 3* V_sdev > 1e-16)
				Histogram/B={V_avg - 3* V_sdev,V_sdev*6/Bin1,Bin1} DC_0,DC_0_Hist
			else
				Histogram/B={0,V_sdev*6/Bin1,Bin1} DC_0,DC_0_Hist
			endif

			Display/I/W = (0,7.25,2, 9.75) DC_0_hist
			//Display/W = (0,7.25,2, 9.75) sig_0_Hist
			ModifyGraph mode=5
			ModifyGraph mirror=2
			//ModifyGraph width=151.2,height={Aspect,2}
			ModifyGraph useNegRGB=1,usePlusRGB=1,hbFill=2,rgb=(0,0,0); 
			ModifyGraph negRGB=(47872,47872,47872),plusRGB=(47872,47872,47872)
			TextBox/C/N=text0/F=0/Z=1/A=MT/E num2str(V_avg) + " +- " + num2str(V_sdev)

			StatsQuantiles/iNaN/q chisq_0
			wavestats/q chisq_0
			bin1 = ceil (V_npnts ^ (1/3) * (V_max - V_min)/2/V_IQR)
			Make/N=(Bin1)/O chisq_0_Hist; 

			if (V_avg - 3* V_sdev > 1e-16)
				Histogram/B={V_avg - 3* V_sdev,V_sdev*6/Bin1,Bin1} chisq_0,chisq_0_Hist
			else
				Histogram/B={0,V_sdev*6/Bin1,Bin1} chisq_0,chisq_0_Hist
			endif
		

			Display/I/W = (2.25,4.35,4.25, 6.85)  chisq_0_hist
			//	ModifyGraph width=151.2,height={Aspect,1}
			ModifyGraph mode=5
			ModifyGraph mirror=2
			ModifyGraph useNegRGB=1,usePlusRGB=1,hbFill=2,rgb=(0,0,0); 
			ModifyGraph negRGB=(47872,47872,47872),plusRGB=(47872,47872,47872)
			TextBox/C/N=text0/F=0/Z=1/A=MT/E num2str(V_avg) + " +- " + num2str(V_sdev)

			//Rename w_vel_y, $vel_y
			if(fit_check==1)
				if(D==0)
				else
					Display/N =Dif/I/W = (0,4.35, 2,6.85); AppendImage $Diff_co
					//ModifyGraph swapXY=1
					SetAxis/A/R left
					ColorScale/C/N=text0/F=0/A=MB/E vert=0,lowTrip=0.01, width=87	
					ModifyImage $Diff_co ctab= {*,*,BlueRedGreen,0}
				
				endif
				if(particle==2)
					Display/N =Dif1/I/W = (4.5,7.25, 6.5,9.75); AppendImage $Diff_co1
					//ModifyGraph swapXY=1
					SetAxis/A/R left
					ColorScale/C/N=text0/F=0/A=MB/E vert=0,lowTrip=0.01, width=87	
					ModifyImage $Diff_co1 ctab= {*,*,BlueRedGreen,0}
					Display/N =No1/I/W = (6.75, 4.35, 8.75, 6.85); AppendImage $Number1
					//ModifyGraph swapXY=1
					SetAxis/A/R left
					ColorScale/C/N=text0/F=0/A=MB/E vert=0,lowTrip=0.01, width=87		
					ModifyImage $Number1 ctab= {*,*,BlueRedGreen,0}		
				endif
				Display/N =sig/I/W = (2.25,7.25,4.25, 9.75); AppendImage $sig
				//ModifyGraph swapXY=1
				SetAxis/A/R left
				ColorScale/C/N=text0/F=0/A=MB/E vert=0,lowTrip=0.01, width=87	
				ModifyImage $sig ctab= {*,*,BlueRedGreen,0}	
				Display/N =No/I/W = (4.5, 4.35, 6.5, 6.85); AppendImage $Number
				//ModifyGraph swapXY=1
				SetAxis/A/R left
				ColorScale/C/N=text0/F=0/A=MB/E vert=0,lowTrip=0.01, width=87		
				ModifyImage $Number ctab= {*,*,BlueRedGreen,0}		
				Display/N =chisq/I/W = (2.25,4.35,4.25, 6.85) ; AppendImage $chisq
				//ModifyGraph swapXY=1
				SetAxis/A/R left
				ModifyImage $chisq ctab= {*,*,BlueRedGreen,0}
				ColorScale/C/N=text0/F=0/A=MB/E vert=0,lowTrip=0.01, width=87			
				Display/N =DC/I/W = (0,7.25,2, 9.75); AppendImage $DC
				//ModifyGraph swapXY=1
				SetAxis/A/R left
				ColorScale/C/N=text0/F=0/A=MB/E vert=0,lowTrip=0.01, width=87	
				ModifyImage $DC ctab= {*,*,BlueRedGreen,0}	
				////				
				
				
				//histogram
				

	
	

		
				//Dowindow/F Dif
				//Dowindow/F Chisq
				//Dowindow/F No
				//Dowindow/F DC
				//Dowindow/F Sig
				
			endif
			if(vx == 0 && vy ==0)
			else
				Display/N =Dif/I/W = (4.5,7.25,6.5,9.75); AppendImage $vel_x
				//ModifyGraph swapXY=1
				SetAxis/A/R left
				ColorScale/C/N=text0/F=0/A=MB/E vert=0,lowTrip=0.01, width=87		
			endif
			Dowindow/k newstring
		endif
		//print time() 
		if(corr_type ==10)
	
			for ( 	m =0; m <15; m= m+1)

				wave_fit_name =basename + "_" + num2str(successfulfiles[i]) + "_" + num2str(fir_pixelfit[m]) + "_" +num2str(sec_pixelfit[m])
				Wave w1 = root:ITIRFCCS:$wave_fit_name
	
				W_coef= {sec_pixelfit[m]-fir_pixelfit[m],0,vx,vy, Bin/2, D, lambda, NA, N,1,sigma,pixel}
				if (spim_mod ==1)
					//print sigz_hold1  
					if (particle==1)
						Make/O/D/N = 15 W_coef
						W_coef=  {sec_pixelfit[m]-fir_pixelfit[m],0,vx,vy, Bin, D, lambda,  NA,  N,1,sigma,pixel, SIGZ, lambda_exc, NA_exc}
					endif
				
					FuncFit/N=1 /q/H="11" + num2str(vx_fit_value) + num2str(vy_fit_value) + "1" + num2str(D_fit_value) + "11"+num2str(N_fit_value)+"0" + num2str(fit_value) +"1"+ num2str(sigz_hold1) + "11"  ITIRFCCS_spim W_coef   w1[fitrange_begin,fitrange_end]/X=lagtime/D/R/A=0
				
				else
					FuncFit/N=1/q/H="11" + num2str(vx_fit_value) + num2str(vy_fit_value) + "1" + num2str(D_fit_value) + "1100" + num2str(fit_value) +"1"/Q  ITIRFCCS_fit W_coef  w1[1,channel1 + (channel2-1)*channel1/2-1]/X=lagtime /D  
			
				endif
				
				
	 
				//else
	
				//FuncFit/H="11" + num2str(vx_fit_value) + num2str(vy_fit_value)  +"1" + num2str(D_fit_value) + "1100" + num2str(fit_value) +"1"/Q  ITIRFCCS_fit W_coef  w1[1,linearpoints-1]/X=lagtime /D 
				//endif

				w_reason1[m] = V_FitQuitReason

				if(V_FitQuitReason == 0 && w_coef[5] >= 0 &&  w_coef[8] > 0 && w_coef[10]  >=0)
	 
					w_diff_co[m] = W_coef[5] 
					w_sig[m] = w_coef[10]
					w_chisq[m] = V_chisq
					w_number[m] = w_coef[8]
					w_dc[m] = w_coef[9]
					w_vel_x[m] = w_coef[2]
					w_vel_y[m] = w_coef[3]
	
				else
	
					w_diff_co[m] = nan
					w_sig[m] = nan
					w_chisq[m] = nan
					w_number[m] = nan
					w_dc[m] = nan
					w_vel_x[m] = nan
					w_vel_y[m] = nan
	
				endif
		
			endfor
			Redimension/N = (15, 1) w_diff_co
			MatrixTranspose w_diff_co
			Redimension/N =  (15, 1)  w_sig
			MatrixTranspose w_sig
			Redimension/N =  (15, 1)  w_DC
			MatrixTranspose w_DC
			Redimension/N =  (15, 1)  w_chisq
			MatrixTranspose w_chisq
			Redimension/N =  (15, 1)  w_number
			MatrixTranspose w_number
			Redimension/N =  (15, 1)  w_vel_x
			MatrixTranspose w_vel_x
			Redimension/N =  (15, 1) w_vel_y
			MatrixTranspose w_vel_y
			Rename w_reason1, $reason1
	
			Rename w_diff_co ,$Diff_co
			Rename w_sig, $sig
			Rename w_dc , $DC
			Rename w_chisq , $chisq
			Rename w_number, $Number
			Rename w_vel_x, $vel_x
			Rename w_vel_y, $vel_y
			Display/N =image_plot_D/I/W = (10,4, 12,6); AppendImage $Diff_co
			ModifyGraph swapXY=1
			SetAxis/A/R left
			Display/N =image_plot_sig; AppendImage $sig
			ModifyGraph swapXY=1
			SetAxis/A/R left
			Display/N =image_plot_N; AppendImage $Number
			ModifyGraph swapXY=1
			SetAxis/A/R left
			Display/N =image_plot_chisq; AppendImage $chisq
			ModifyGraph swapXY=1
			SetAxis/A/R left
			Display/N =image_plot_DC; AppendImage $DC
			ModifyGraph swapXY=1
			SetAxis/A/R left
			Display/N =image_plot_vx; AppendImage $vel_x
			ModifyGraph swapXY=1
			SetAxis/A/R left
			Display/N =image_plot_vy; AppendImage $vel_y
			ModifyGraph swapXY=1
			SetAxis/A/R left
		endif
	
		if(corr_type == 11)
			for ( 	m =0; m <15; m= m+1)

				wave_fit_name =basename + "_" + num2str(successfulfiles[i]) + "_" + num2str(fir_pixelfit[m]) + "_" +num2str(sec_pixelfit[m])
				Wave w1 = root:ITIRFCCS:$wave_fit_name
	
				W_coef= {0,m-7,vx,vy, Bin/2, D, lambda, NA, N,1,sigma,pixel}

				if (spim_mod ==1)
					//print sigz_hold1  
					if (particle==1)
						Make/O/D/N = 15 W_coef
						W_coef=  {0,m-7,vx,vy, Bin, D, lambda,  NA,  N,1,sigma,pixel, SIGZ, lambda_exc, NA_exc}
					endif
			
					FuncFit/N=1 /q/H="11" + num2str(vx_fit_value) + num2str(vy_fit_value) + "1" + num2str(D_fit_value) + "11"+num2str(N_fit_value)+"0" + num2str(fit_value) +"1"+ num2str(sigz_hold1) + "11"  ITIRFCCS_spim W_coef   w1[fitrange_begin,fitrange_end]/X=lagtime/D/R/A=0
				
				else
					FuncFit/N=1/q/H="11" + num2str(vx_fit_value) + num2str(vy_fit_value) + "1" + num2str(D_fit_value) + "1100" + num2str(fit_value) +"1"/Q  ITIRFCCS_fit W_coef  w1[1,channel1 + (channel2-1)*channel1/2-1]/X=lagtime /D  
			
				endif
				
				
				w_reason1[m] = V_FitQuitReason

				if(V_FitQuitReason == 0 && w_coef[5] >= 0 &&  w_coef[8] > 0 && w_coef[10]  >=0 )
	 
					w_diff_co[m] = W_coef[5]
					w_sig[m] = w_coef[10]
					w_chisq[m] = V_chisq
					w_number[m] = w_coef[8]
					w_dc[m] = w_coef[9]
					w_vel_x[m] = w_coef[2]
					w_vel_y[m] = w_coef[3]
	
				else
	
					w_diff_co[m] = nan
					w_sig[m] = nan
					w_chisq[m] = nan
					w_number[m] = nan
					w_dc[m] = nan
					w_vel_x[m] = nan
					w_vel_y[m] = nan
	
				endif
		
			endfor
			Redimension/N = (1, 15) w_diff_co
			MatrixTranspose w_diff_co
			Redimension/N =  (1, 15)  w_sig
			MatrixTranspose w_sig
			Redimension/N =  (1, 15)  w_DC
			MatrixTranspose w_DC 
			Redimension/N =  (1, 15)  w_chisq
			MatrixTranspose w_chisq
			Redimension/N =  (1, 15)  w_number
			MatrixTranspose w_number
			Redimension/N =  (1, 15)  w_vel_x
			MatrixTranspose w_vel_x
			Redimension/N =  (1, 15) w_vel_y
			MatrixTranspose w_vel_y
			Rename w_reason1, $reason1
	
			Rename w_diff_co ,$Diff_co
			Rename w_sig, $sig
			Rename w_dc , $DC
			Rename w_chisq , $chisq
			Rename w_number, $Number
			Rename w_vel_x, $vel_x
			Rename w_vel_y, $vel_y
			Display/N =image_plot_D/W = (10,4, 12,6); AppendImage $Diff_co
			ModifyGraph swapXY=1
			SetAxis/A/R left
			Display/N =image_plot_sig; AppendImage $sig
			ModifyGraph swapXY=1
			SetAxis/A/R left
			Display/N =image_plot_N; AppendImage $Number
			ModifyGraph swapXY=1
			SetAxis/A/R left
			Display/N =image_plot_chisq; AppendImage $chisq
			ModifyGraph swapXY=1
			SetAxis/A/R left
			Display/N =image_plot_DC; AppendImage $DC
			ModifyGraph swapXY=1
			SetAxis/A/R left
			Display/N =image_plot_vx; AppendImage $vel_x
			ModifyGraph swapXY=1
			SetAxis/A/R left
			Display/N =image_plot_vy; AppendImage $vel_y
			ModifyGraph swapXY=1
			SetAxis/A/R left
		endif
	
		if (corr_type == 15)
		
			NVAR  mar_top = root:ITIRFCCS:mar_top
			NVAR mar_bottom = root:ITIRFCCS:mar_bottom
			NVAR mar_left = root:ITIRFCCS:mar_left
			NVAR mar_right = root:ITIRFCCS:mar_right
	
			for ( 	m =0; m <((mar_bottom+1-mar_top)*(mar_right-mar_left +1)); m= m+1)
		
		
				wave_fit_name =basename + "_" + num2str(successfulfiles[i]) + "_" + num2str(fir_pixelfit[m]) + "_" +num2str(sec_pixelfit[m])
				Wave w1 = root:ITIRFCCS:$wave_fit_name
	
				W_coef= {0,0,vx,vy, Bin/2, D, lambda, NA, N,1,sigma,pixel}
	
				if (spim_mod ==1)
					//print sigz_hold1  
					if (particle==1)
						Make/O/D/N = 15 W_coef
						W_coef=  {0,0,vx,vy, Bin, D, lambda,  NA,  N,1,sigma,pixel, SIGZ, lambda_exc, NA_exc}
					endif
			
					FuncFit/N=1 /q/H="11" + num2str(vx_fit_value) + num2str(vy_fit_value) + "1" + num2str(D_fit_value) + "11"+num2str(N_fit_value)+"0" + num2str(fit_value) +"1"+ num2str(sigz_hold1) + "11"  ITIRFCCS_spim W_coef   w1[fitrange_begin,fitrange_end]/X=lagtime/D/R/A=0
				
				else
					FuncFit/N=1/q/H="11" + num2str(vx_fit_value) + num2str(vy_fit_value) + "1" + num2str(D_fit_value) + "1100" + num2str(fit_value) +"1"/Q  ITIRFCCS_fit W_coef  w1[1,channel1 + (channel2-1)*channel1/2-1]/X=lagtime /D  
			
				endif


				w_reason1[m] = V_FitQuitReason

	
				if(V_FitQuitReason == 0 && w_coef[5] >= 0 &&  w_coef[8] > 0 && w_coef[10]  >=0)
	 
					w_diff_co[m] = W_coef[5]
					w_sig[m] = w_coef[10] 
					w_chisq[m] = V_chisq
					w_number[m] = w_coef[8]
					w_dc[m] = w_coef[9]
					w_vel_x[m] = w_coef[2]
					w_vel_y[m] = w_coef[3]
	
				else
	
					w_diff_co[m] = nan
					w_sig[m] = nan
					w_chisq[m] = nan
					w_number[m] = nan
					w_dc[m] = nan
					w_vel_x[m] = nan
					w_vel_y[m] = nan
	
				endif
			endfor
			Redimension/N = (mar_bottom+1-mar_top, mar_right-mar_left +1) w_diff_co
			MatrixTranspose w_diff_co
			Redimension/N = (mar_bottom+1-mar_top, mar_right-mar_left +1) w_sig
			MatrixTranspose w_sig
			Redimension/N = (mar_bottom+1-mar_top, mar_right-mar_left +1) w_DC
			MatrixTranspose w_DC
			Redimension/N = (mar_bottom+1-mar_top, mar_right-mar_left +1) w_chisq
			MatrixTranspose w_chisq
			Redimension/N = (mar_bottom+1-mar_top, mar_right-mar_left +1) w_number
			MatrixTranspose w_number
			Redimension/N = (mar_bottom+1-mar_top, mar_right-mar_left +1) w_vel_x
			MatrixTranspose w_vel_x
			Redimension/N = (mar_bottom+1-mar_top, mar_right-mar_left +1) w_vel_y
			MatrixTranspose w_vel_y
			Rename w_reason1, $reason1
			Rename w_diff_co ,$Diff_co
			Rename w_sig, $sig
			Rename w_dc , $DC
			Rename w_chisq , $chisq
			Rename w_number, $Number
			Rename w_vel_x, $vel_x
			Rename w_vel_y, $vel_y
			Display/N =D; AppendImage $Diff_co
			ModifyGraph swapXY=1
			SetAxis/A/R left
			Display/N =sig; AppendImage $sig
			ModifyGraph swapXY=1
			SetAxis/A/R left
			Display/N =N; AppendImage $Number
			ModifyGraph swapXY=1
			SetAxis/A/R left
			Display/N =chisq; AppendImage $chisq
			ModifyGraph swapXY=1
			SetAxis/A/R left
			Display/N =DC; AppendImage $DC
			ModifyGraph swapXY=1
			SetAxis/A/R left

		endif
	
	
	endfor
	KillWindow ProgressPanel
	//CursorGlobalsForGraph()
	//	CursorDependencyForGraph()
	CursorMoved( "corr_dis", 0)
	//print time()
end 


Function disp_pop(ctrlName,popNum,popStr) : PopupMenuControl
	String ctrlName
	Variable popNum // which item is currently selected (1-based)
	String popStr // contents of current popup item as string
	Wave successfulfiles= root:ITIRFCCS:successfulfiles
	WaveStats/Q Successfulfiles
	Variable loop_n 
	loop_n = V_npnts
	ControlInfo display_data
	if (V_value ==1)
		Dowindow/F corr_dis
		Dowindow/F Intensity_dis
		Dowindow/F Choose_pixel
		Dowindow/F No
		Dowindow/F chisq
		Dowindow/F Dif
		Dowindow/F DC
		Dowindow/F sig
	endif
	Variable j
	String str_corr 
	String str_int
	String str_cho 
	String str_difmap
	String str_chis
	String str_no
	String str_sig
	String str_dc
	for (j=1; j<V_npnts; j=j+1)
		if(V_value == (j+1))
			str_corr= "corr_dis"+num2str(j-1)
			str_int = "Intensity_dis" + num2str(j-1)
			str_cho = "Choose_pixel" + num2str(j-1)
			str_difmap = "Dif"+ num2str(j-1)
			Str_chis = "chisq" + num2str(j-1)
			str_no = "no" + num2str(j-1)
			str_sig = "sig" + num2str(j-1)
			str_dc = "dc" + num2str(j-1)
			DoWindow/F $str_chis
			Dowindow/F $str_difmap
			Dowindow/F $str_no
			Dowindow/F $str_corr
			Dowindow/F $str_int
			Dowindow/F $str_cho
			Dowindow/F $str_sig
			Dowindow/F $str_dc

		endif
	endfor
End

	
Function CursorMoved(info, isB)


	String info
	Variable isB // 0 if A cursor, nonzero if B cursor
	Variable result= NaN // error result
	//print "already called"

	String dfSave=GetDataFolder(1) 
	SetDataFolder root:ITIRFCCS
	///Nvar sd__ = root:ITIRFCCS:sd__
	Nvar sd__ =  root:ITIRFCCS:sd__
	NVAR bin = root:ITIRFCCS:bin
	SVAR titlebox_pixel = root:ITIRFCCS:titlebox_pixel
	NVAR fit_check = root:ITIRFCCS:fit_check
	wave numberofcolumns = root:ITIRFCCS:numberofcolumns
	wave numberofrows = root:ITIRFCCS:numberofrows
	wave successfulfiles = root:ITIRFCCS:successfulfiles
	wave lagtime = root:ITIRFCCS:lagtime
	wave numberoffiles = root:ITIRFCCS:numberoffiles
	NVAR xwave_scale = root:ITIRFCCS:xwave_scale
	NVAR fit_check = root:ITIRFCCS:fit_check
	NVAR xval2 = root:ITIRFCCS:xval2
	NVAR yval2 = root:ITIRFCCS:yval2
	NVAR particle = root:ITIRFCCS:particle
	// Check that the top graph is the one in the info string.
	String topGraph= WinName(0,1)
	String graphName= StringByKey("GRAPH", info)
	//print graphname
	//print topGraph
	//print "helllo"
	if( CmpStr(graphName, topGraph) == 0 )
		//print "True"
		String tName= StringByKey("TNAME", info)
		//print "tname = ", tname
		if( strlen(tName) ) // cursor still on
			//print "ture"
			String cn
			Variable xVal, yval
			xVal= vcsr(A) 
			yval = hcsr(A)
			//Cursor /I A  xval, yval 
			//print "getting executed"
			///////////////////////////////////////////////
			cn= "Cursor A"
			
		endif
	else
		//print "notentered"
	endif
	
	String substring_num
	Variable str_length
	str_length = strlen(topgraph)
	substring_num = graphname[12, str_length-1]
	Variable filenumber
	filenumber = str2num(substring_num)



	if (numtype(filenumber)==2)  
		filenumber=0

	else

		filenumber= filenumber + 1
	endif
	//print filenumber , "is the filenumber"
	NVAR channel1 = root:ITIRFCCS:channel1
	NVAR channel2= root:ITIRFCCS:channel2
	SVAR diff_co = root:ITIRFCCS:diff_co
	
	if(fit_check >0)
		wave Diff_co_0 = root:ITIRFCCS:Diff_co_0
		wave chisq_0 = root:ITIRFCCS:chisq_0
		wave Number_0 = root:ITIRFCCS:number_0
		wave sig_0 = root:ITIRFCCS:sig_0
		Wave DC_0 = root:ITIRFCCS:DC_0
		if (particle==2)
			wave Diff_co_1_0 = root:ITIRFCCS:Diff_co_1_0
			wave Number_1_0 = root:ITIRFCCS:number_1_0
		endif
		String/G Dbox_pixel 
		String/G chibox_pixel 
		String/G Nbox_pixel 
		String/G DCbox_pixel 
		String/G sigbox_pixel 
		if (particle==2)
			String/G D2box_pixel
			String/G qbox_pixel
		endif
		//print bin
		if( CmpStr("Choose_Pixel", topGraph) == 0 )
		
			//print "choose_pixel", floor(yval2), floor(xval2)
			if(((xval2+1)> floor(numberofrows[successfulfiles[filenumber]]/bin)*bin) ||((yval2+1)> floor(numberofcolumns[successfulfiles[filenumber]]/bin)*bin))
				Dbox_pixel = "nan"
				chibox_pixel ="nan"
				Nbox_pixel = "nan"
				DCbox_pixel = "nan"
				sigbox_pixel = "nan"
				if(particle==2)
					qbox_pixel = "nan"
					D2box_pixel = "nan"
				endif
				Cursor/K/W=Dif A 
				//dOWINDOW/f No
				Cursor/K/W=No A 
				Cursor/K/W=chisq A 
				Cursor/P/W=choose_pixel/I/C=(65535,65535,0) A Display_intensity0 floor(yval2), floor(xval2)
				Cursor/K/W=DC A 
				Cursor/K/W=sig A 
				if(particle==2)
					Cursor/K/W=No1 A 
					Cursor/K/W=Dif1 A 
				endif
			else
				Dbox_pixel = num2str(Diff_co_0[(floor(yval2/bin))][(floor(xval2/bin))])
				chibox_pixel = num2str(chisq_0[floor(yval2/bin)][floor(xval2/bin)])
				Nbox_pixel = num2str(number_0[floor(yval2/bin)][floor(xval2/bin)])
				DCbox_pixel = num2str(DC_0[floor(yval2/bin)][floor(xval2/bin)])
				sigbox_pixel = num2str(sig_0[floor(yval2/bin)][floor(xval2/bin)])
				if(particle==2)
					qbox_pixel = num2str(number_1_0[floor(yval2/bin)][floor(xval2/bin)])
					D2box_pixel =num2str(Diff_co_1_0[floor(yval2/bin)][floor(xval2/bin)])
				endif
				Cursor/P/W=Dif/I/C=(65535,65535,65535) A Diff_co_0 floor(yval2/bin), floor(xval2/bin)
				//dOWINDOW/f No
				Cursor/P/W=No/I/C=(65535,65535,65535) A NUmber_0 floor(yval2/bin), floor(xval2/bin)
				Cursor/P/W=chisq/I/C=(65535,65535,65535) A chisq_0 floor(yval2/bin), floor(xval2/bin)
				Cursor/P/W=choose_pixel/I/C=(65535,65535,0) A Display_intensity0 floor(yval2), floor(xval2)
				Cursor/P/W=DC/I/C=(65535,65535,0) A DC_0 floor(yval2/bin), floor(xval2/bin)
				Cursor/P/W=sig/I/C=(65535,65535,0) A sig_0 floor(yval2/bin), floor(xval2/bin)
				if(particle==2)
					Cursor/P/W=No1/I/C=(65535,65535,0) A number_1_0 floor(yval2/bin), floor(xval2/bin)
					Cursor/P/W=Dif1/I/C=(65535,65535,0) A Diff_co_1_0 floor(yval2/bin), floor(xval2/bin)
				endif
			endif
			//		doupdate  
		else
			Cursor/P/W=Dif/I/C=(65535,65535,65535) A Diff_co_0 floor(yval2), floor(xval2)
			//dOWINDOW/f No
			Cursor/P/W=No/I/C=(65535,65535,65535) A NUmber_0 floor(yval2), floor(xval2)
			Cursor/P/W=chisq/I/C=(65535,65535,65535) A chisq_0 floor(yval2), floor(xval2)
			Cursor/P/W=choose_pixel/I/C=(65535,65535,0) A Display_intensity0 yval2*bin, xval2*bin
			//	print "othergraph", floor(yval2), floor(xval2)
			Cursor/P/W=DC/I/C=(65535,65535,0) A DC_0 floor(yval2), floor(xval2)
			Cursor/P/W=sig/I/C=(65535,65535,0) A sig_0 floor(yval2), floor(xval2)
			if(particle==2)
				Cursor/P/W=No1/I/C=(65535,65535,0) A number_1_0 floor(yval2), floor(xval2)
				Cursor/P/W=Dif1/I/C=(65535,65535,0) A Diff_co_1_0 floor(yval2), floor(xval2)
			endif
			String/G Dbox_pixel = num2str(Diff_co_0[yval2][xval2])
			String/G chibox_pixel = num2str(chisq_0[yval2][xval2])
			String/G Nbox_pixel = num2str(number_0[yval2][xval2])
			String/G DCbox_pixel = num2str(DC_0[yval2][xval2])
			String/G sigbox_pixel = num2str(sig_0[yval2][xval2])
			if(particle==2)
				String/G D2box_pixel = num2str(Diff_co_1_0[yval2][xval2])
				String/G qbox_pixel = num2str(number_1_0[yval2][xval2])
			endif
		endif
		doupdate 
		///This doupdate is responsible for the trail as the cursor is dragged. Upon activating the doupdate, the trail will vanish but the error mesage that "updtdisplay:recursion attempted" will be seen
	
		String/G titlestr2 = "D"
		String/G titlestr3 = "chisq"
		String/G titlestr4 = "N"
		STRIng/G titlestr5 = "sig"
		String/G titlestr6 = "DC"
		String/G titlestr7 = "D2"
		String/G titlestr8 = "F1"
			
		
		TitleBox  D_pos, win = ITIRFCCSMainControl_new, pos = {65,765}, size ={260,30}, fsize = 12, font = "Arial", frame = 1, variable = Dbox_pixel
		TitleBox  D_pos1, win = ITIRFCCSMainControl_new ,frame = 0, pos = {20,765}, size ={260,30}, fsize = 12, font = "Arial", variable = titlestr2
		if(particle==2)
			TitleBox  D_pos2, win = ITIRFCCSMainControl_new, pos = {215,765}, size ={260,30}, fsize = 12, font = "Arial", frame = 1, variable = D2box_pixel
			TitleBox  D_pos3, win = ITIRFCCSMainControl_new ,frame = 0, pos = {170,765}, size ={260,30}, fsize = 12, font = "Arial", variable = titlestr7

		endif

		TitleBox  chi_pos, win = ITIRFCCSMainControl_new, pos = {65,825}, size ={260,30}, fsize = 12, font = "Arial", frame = 1, variable = chibox_pixel
		TitleBox  chi_pos1, win = ITIRFCCSMainControl_new ,frame = 0, pos = {20,825}, size ={260,30}, fsize = 12, font = "Arial", variable = titlestr3

		TitleBox  N_pos, win = ITIRFCCSMainControl_new, pos = {65,795}, size ={260,30}, fsize = 12, font = "Arial", frame = 1, variable = Nbox_pixel
		TitleBox  N_pos1, win = ITIRFCCSMainControl_new ,frame = 0, pos = {20,795}, size ={260,30}, fsize = 12, font = "Arial", variable = titlestr4


		if(particle==2)
			TitleBox  N_pos2, win = ITIRFCCSMainControl_new, pos = {215,795}, size ={260,30}, fsize = 12, font = "Arial", frame = 1, variable = qbox_pixel
			TitleBox  N_pos3, win = ITIRFCCSMainControl_new ,frame = 0, pos = {170,795}, size ={260,30}, fsize = 12, font = "Arial", variable = titlestr8
		endif  
	
		
		TitleBox  DC_pos, win = ITIRFCCSMainControl_new, pos = {215,735}, size ={260,30}, fsize = 12, font = "Arial", frame = 1, variable = DCbox_pixel
		TitleBox  DC_pos1, win = ITIRFCCSMainControl_new ,frame = 0, pos = {170,735}, size ={260,30}, fsize = 12, font = "Arial", variable = titlestr6

		TitleBox  sig_pos, win = ITIRFCCSMainControl_new, pos = {215,825}, size ={260,30}, fsize = 12, font = "Arial", frame = 1, variable = sigbox_pixel
		TitleBox  sig_pos1, win = ITIRFCCSMainControl_new ,frame = 0, pos = {170,825}, size ={260,30}, fsize = 12, font = "Arial", variable = titlestr5
	endif
	if( CmpStr("Choose_Pixel", topGraph) == 0 )
		variable q_x = floor(xval/bin) * bin
		variable q_y = floor(yval/bin) * bin
	else
		q_x = xval * bin
		q_y = yval * bin
	endif
	variable/G pixel_d = q_x*numberofcolumns[successfulfiles[filenumber]] + q_y 
	variable/G x_pos = q_x
	Variable/G y_pos = q_y
	Variable int_d = xval*numberofcolumns[successfulfiles[filenumber]] + yval
	//print "Pixel", pixel_d 
	//print int_d
	String nametodisplay = "int_" + num2str(successfulfiles[filenumber])+ "_" + num2str(int_d)

	String display_w, display_w_corr
	display_w = "displaY_wave" + "_" + num2str(successfulfiles[filenumber])
	display_w_corr = "display_wave_corr" + "_" + num2str(successfulfiles[filenumber])
	variable ll 
	titlebox_pixel = ""
	ControlUpdate/W=ITIRFCCSmaincontrol_new pixel_pos
	titlebox_pixel = "  " + num2str(pixel_d)+ "  "
	ControlUpdate/W=ITIRFCCSmaincontrol_new pixel_pos
	//Make/O/D/N = (numberoffiles[filenumber]) $display_w
	setdatafolder "root:ITIRFCCS"
	Make/O/D/N = (numberoffiles[(successfulfiles[filenumber])]) $display_w
	Make/O/D/N = (numberoffiles[(successfulfiles[filenumber])]) w2_22
	wave w1_22 = $display_w
	if (exists(nametodisplay) == 0)
		//print "NO correlation was done"
		return -1
	endif
	//print nametodisplay
	Wave w2_22 = root:ITIRFCCS:$nametodisplay
	for(ll = 0; ll<numberoffiles[(successfulfiles[filenumber])]; ll= ll+1)
		////print "hi"
		//
		w1_22[ll] = w2_22[ll] 
		////print w2_22[ll]
		////print w2_22[ll] 
	endfor


	Make/O/D w4_22
	if (sd__ == 0)
		String nametodisplay_corr = "corr_" + num2str(successfulfiles[filenumber]) + "_" + num2str(pixel_d) + "_" + num2str(pixel_d)
	endif
	ControlInfo/W=ITIRFCCSMainControl_new split_frame
	variable new_spl = V_value
	//print "new_spl= ", new_spl
	if(sd__ ==1)
		if(new_spl == 1)
			nametodisplay_corr = "av_file_" + num2str(successfulfiles[filenumber]) + "_" + "pixel_"+num2str(pixel_d)
		else
			nametodisplay_corr = "corr_" + num2str(successfulfiles[filenumber]) + "_" + num2str(pixel_d) + "_" + num2str(pixel_d)
		endif
	endif



	if (exists(nametodisplay_corr) == 0)
		//print "NO correlation was done b"
		return -1
	endif

	Wave w4_22 = $nametodisplay_corr



	Wavestats/Q $nametodisplay_corr
	variable loop_run
	loop_run = V_npnts

	Make/O/D/N = (loop_run) $display_w_corr
	Wave w3_22 = $display_w_corr
	//print w3_22
	//print w1_22
	//print "ll"
	//Make/O/D/N = numberoffiles[(successfulfiles[filenumber])] $display_wa



	for ( ll =0; ll<loop_run; ll = ll+1)
		w3_22[ll] = w4_22[ll]
	endfor
	variable display_sd
	ControlInfo sd_display
	display_sd  = V_Value
	
	if (sd__ == 1)
		//print V_value
		//print "jjjdfdf"
		//if(display_sd != 0)
		//print "hi"
		String sd_w_corr, sd_errorbar
		sd_w_corr =  "sd_wave" + "_corr_" + num2str(successfulfiles[filenumber])
		variable pos_sd
		pos_sd = floor(xval/bin)*floor(numberofcolumns[successfulfiles[filenumber]]/bin) +  floor(yval/bin)
		sd_errorbar = "SD_file_" + num2str(successfulfiles[filenumber]) + "_pixel_"  + num2str(pos_sd)
		//print sd_errorbar
		Make/O/D/N = (loop_run) $sd_w_corr
		//print SD_w_corr
		Wave w10 = $sd_w_corr
		Make/O/D/N = (loop_run) w11
		Wave w11 = $sd_errorbar


		for ( ll =0; ll<loop_run; ll = ll+1)
			w10[ll] = w11[ll]
		endfor
	endif
	//endif
	//print "the value of ll",ll 
	//print "the value of successfulfiles[filenumber]", successfulfiles[filenumber], filenumber
	////////////////////////////////////////////////////////////////////////////////////////
	if(fit_check>0)
		//print "ff"
		String nametofit= "fit_corr_" + num2str(successfulfiles[filenumber]) + "_" + num2str(pixel_d) + "_" + num2str(pixel_d)
		if(sd__ ==1)
			if(new_spl == 1)
				nametofit = "fit_av_file_" + num2str(successfulfiles[filenumber]) + "_" + "pixel_"+num2str(pixel_d)
				//else
				//nametodisplay_corr = "corr_" + num2str(successfulfiles[filenumber]) + "_" + num2str(pixel_d) + "_" + num2str(pixel_d)
			endif
		endif


		String display_fit
		String nametores= "res_corr_" + num2str(successfulfiles[filenumber]) + "_" + num2str(pixel_d) + "_" + num2str(pixel_d)
		if(sd__ ==1)
			if(new_spl == 1)
				nametores = "res_av_file_" + num2str(successfulfiles[filenumber]) + "_" + "pixel_"+num2str(pixel_d)
				//else
				//nametodisplay_corr = "corr_" + num2str(successfulfiles[filenumber]) + "_" + num2str(pixel_d) + "_" + num2str(pixel_d)
			endif
		endif
		String display_res
		display_fit = "fit_corr_dis" + "_" + num2str(successfulfiles[filenumber])
		display_res="residual_wave_corr" + "_" + num2str(successfulfiles[filenumber])
		//	Make/O/D/N = (channel1 + (channel2-1)*channel1/2) $display_fit
		//	Make/O/D/N = (channel1 + (channel2-1)*channel1/2) w6_22
		Make/O/D/N = (200) $display_fit
		Make/O/D/N = (200) w6_22
		Wave w5_22 = $display_fit
		//print "fitted"
		
		Make/O/D/N =(loop_run) $display_res
		Make/O/D/N = (loop_run) w8_22
		Wave w7_22 = $display_res
		 
		
		
		if (exists(nametofit) == 0) 
			//print "Not fitted"
			return -1
		endif
		Wave w8_22 = $nametores
		Wave w6_22 = $nametofit
		//print "w6_22", w6_22
		//xwave_scale = deltax($nametofit)
		//print xwave_scale
		//for ( ll =0; ll<(channel1 + (channel2-1)*channel1/2); ll = ll+1)
		for ( ll =0; ll<200; ll = ll+1)
			w5_22[ll] = w6_22[ll]
			//w7_22[ll] = w8_22[ll]
		endfor
		w7_22 =nan
		
		NVAR fitrange_begin=root:ITIRFCCS:fitrange_begin
		//print "hi", fitrange_begin
		NVAR fitrange_end=root:ITIRFCCS:fitrange_end
		//print fitrange_begin,fitrange_end
		for ( ll =fitrange_begin; ll<fitrange_end; ll = ll+1)
			//w5_22[ll] = w6_22[ll]
			w7_22[ll] = w8_22[ll]
		endfor
	endif
	return pixel_d
End
 

//
Function CursorDependencyForGraph()

	String graphName= WinName(0,1)
	//print "graphname ==========", graphname
	if( strlen(graphName) )
		String df= GetDataFolder(1);
		NewDataFolder/O root:WinGlobals
		NewDataFolder/O/S root:WinGlobals:$graphName
		String/G S_CursorAInfo, S_CursorBInfo
		Variable/G dependentA
		SetFormula dependentA, "CursorMoved(S_CursorAInfo, 0)"
		//Variable/G dependentB
		//SetFormula dependentB,"CursorMoved(S_CursorBInfo, 1)"
		SetDataFolder df
	endif

End

Function CursorGlobalsForGraph() 

	String graphName= WinName(0,1)
	//print "graphname = ", graphname
	if( strlen(graphName) )
		String df= GetDataFolder(1);
		NewDataFolder/O root:WinGlobals
		NewDataFolder/O/S root:WinGlobals:$graphName
		String/G S_CursorAInfo, S_CursorBInfo
		SetDataFolder df
	endif
End

End

Function CursorMovedHook(info)

	String info
	
	nvar xval2 = root:ITIRFCCS:xval2
	nvar yval2 = root:ITIRFCCS:yval2
	xval2 =  vcsr(A)
	yval2 = hcsr(A) 
	//Print info  
	//print "vcsr(A) = ", vcsr(A), hcsr(A) 
	CursorMoved(info, 0)
End


Function cam_pop(ctrlName,popNum,popStr) : PopupMenuControl
	String ctrlName
	Variable popNum // which item is currently selected (1-based)
	String popStr 
	NVAR pixel = root:ITIRFCCS:pixel
	ControlInfo camera
	Variable nr, dr
	if (V_value ==1)
		nr = 24*10^-6
		//print nr
	endif
	if(V_value ==2)
		nr = 16*10^-6
		//print nr
	endif
	ControlInfo mag
	if(V_value ==1)
		dr =10
		//print dr
	elseif (V_Value ==2)
		dr = 20
		//print dr
	elseif (V_Value ==3)
		dr = 40
		//print dr
	elseif (V_value == 4)
		dr =60
		//print dr
	elseif(V_value ==5)
		dr =63
		//print dr
	elseif(V_value ==6)
		dr = 100
		//print dr
	endif
	pixel = nr /dr
end

Function autocorr_sd()

	NVAR logarithmiccorrelation = root:ITIRFCCS:logarithmiccorrelation
	NVAR linearpoints = root:ITIRFCCS:linearpoints
	NVAR bin =root:ITIRFCCS:bin
	wave numberofrows = root:ITIRFCCS:numberofrows
	wave numberofcolumns = root:ITIRFCCS:numberofcolumns
	Wave lagtime = root:ITIRFCCS:lagtime
	Wave lagtime_check = root:ITIRFCCS:lagtime_check
	wavestats lagtime_check
	Variable critical_files
	critical_files = v_npnts
	Variable jj
	NVAR firstframe = root:ITIRFCCS:firstframe
	NVAR lastframe = root:ITIRFCCS:lastframe
	variable nooftimes_final=1
	
	/////this is where I am changing
	if ( (Lastframe  - firstframe)/10> lagtime_check[critical_files]) 
		nooftimes_final = floor((LastFrame-FirstFrame)/lagtime_check[critical_files])
	endif
	
	///////////////cchanged to check for tiff_sd
	NVAR channel1 = root:ITIRFCCS:channel1
	NVAR channel2= root:ITIRFCCS:channel2
	
	Wave successfulfiles = root:ITIRFCCS:successfulfiles
	wavestats successfulfiles
	Variable numboffiles, i,j
	//Variable i,j
	
	
	numboffiles = V_npnts
	//Make/O/N = (numboffiles) std_dev_n

	wave/T Folderfilelist = root:ITIRFCCS:Folderfilelist
	wave/T output_corr = root:ITIRFCCS:output_corr
	wave/T output_int = root:ITIRFCCS:output_int

	NVAR background_for_program = root:ITIRFCCS:background_for_program
	NVAR channel1 = root:ITIRFCCS:channel1
	NVAR channel2 = root:ITIRFCCS:channel2

	String corrname
	for ( i = 0; i<numboffiles; i = i+1)
		//if(logarithmiccorrelation == 1)
		//	std_dev_n[i] = floor((lastframe - firstframe)/lagtime_check[critical_files-1])
		//endif

		//print std_dev_n[i]
		//variable hh
		for (j= 0; j < nooftimes_final; j= j+1)
			//hh = (floor(numberofrows[successfulfiles[i]]/bin) * floor(numberofcolumns[successfulfiles[i]]/bin))
			//print hh, FirstFrame + j*lagtime_check[critical_files-1] + 1, FirstFrame + (j+1)*lagtime_check[critical_files-1] 
			Make/N = (floor(numberofrows[successfulfiles[i]]/bin) * floor(numberofcolumns[successfulfiles[i]]/bin))/O/D w1
			Make/N = (floor(numberofrows[successfulfiles[i]]/bin) * floor(numberofcolumns[successfulfiles[i]]/bin))/O/D w2
	
			variable l = 0,r,k
	
	
	
			for (r = 0; r<floor(numberofrows[successfulfiles[i]]/bin); r=r+1)
				for (k = 0; k<floor(numberofcolumns[successfulfiles[i]]/bin); k= k+1)
					w1[l] = r*bin*numberofcolumns[successfulfiles[i]] + bin*k
					w2[l] = w1[l]
					//print w1,w2
					l = l+ 1
				Endfor
			Endfor
					
			//print  FirstFrame + j*lagtime_check[channel1 + (channel2-1)*channel1/2-1] , FirstFrame + (j+1)*lagtime_check[channel1 + (channel2-1)*channel1/2-1] 

			///////changed here
			print FirstFrame + j*lagtime_check[channel1 + (channel2-1)*channel1/2-1], FirstFrame + (j+1)*lagtime_check[channel1 + (channel2-1)*channel1/2-1]
			tif_program(FolderFileList[successfulfiles[i]], output_corr[successfulfiles[i]], output_int[successfulfiles[i]],FirstFrame + j*lagtime_check[channel1 + (channel2-1)*channel1/2-1], FirstFrame + (j+1)*lagtime_check[channel1 + (channel2-1)*channel1/2-1] , Background_for_program, Bin, channel1, channel2,w1,w2)
			GBLoadWave/Q/B/A=lll/T={2,2}/W=(floor(numberofrows[successfulfiles[i]]/bin) * floor(numberofcolumns[i]/bin))/U=(channel1 + (channel2-1)*channel1/2) output_corr[successfulfiles[i]]
			DeleteFile output_int[successfulfiles[i]]
			DeleteFile  output_corr[successfulfiles[i]]
		
			
			print Background_for_program			
		endfor
	endfor
	variable somecounter = 0,m,ancounter = 0 
	String point_name, some_name
	Make/N =(channel1 + (channel2-1)*channel1/2)/O/D w21
	Make/N =((floor(numberofrows[successfulfiles[j]]/bin) * floor(numberofcolumns[j]/bin)), (channel1 + (channel2-1)*channel1/2))/O/D sum_av=0
	Make/N =((floor(numberofrows[successfulfiles[j]]/bin) * floor(numberofcolumns[j]/bin)), (channel1 + (channel2-1)*channel1/2))/O/D corr_sd=0
	
	for ( j = 0; j<numboffiles; j= j+1)

			

			
		for (m = 0; m< (floor(numberofrows[successfulfiles[j]]/bin) * floor(numberofcolumns[j]/bin)); m= m+1)
			for (k = 0; k< (channel1 + (channel2-1)*channel1/2); k = k+1)
				for ( l = 0; l <nooftimes_final; l = l+1)
					some_name = "lll" +  num2str((floor(numberofrows[successfulfiles[j]]/bin) * floor(numberofcolumns[j]/bin))*l + m)
					wave w21 = $some_name
					sum_av[m][k]=sum_av[m][k] + w21[k] 
				endfor
				sum_av[m][k] = sum_av[m][k]/nooftimes_final
			endfor
		endfor
	endfor
	print nooftimes_final
	for ( j = 0; j<numboffiles; j= j+1)

	
		for (m = 0; m< (floor(numberofrows[successfulfiles[j]]/bin) * floor(numberofcolumns[successfulfiles[j]]/bin)); m= m+1)
			for (k = 0; k< (channel1 + (channel2-1)*channel1/2); k = k+1)
				for ( l = 0; l <nooftimes_final; l = l+1)
					some_name = "lll" +  num2str((floor(numberofrows[successfulfiles[j]]/bin) * floor(numberofcolumns[successfulfiles[j]]/bin))*l + m)
					if(m==0)
						//print num2str((floor(numberofrows[successfulfiles[j]]/bin) * floor(numberofcolumns[successfulfiles[j]]/bin))*l + m)
					endif
					wave w21 = $some_name
					corr_sd[m][k]=corr_sd[m][k] + (w21[k] - sum_av[m][k])*  (w21[k] - sum_av[m][k])
				endfor
				corr_sd[m][k] = sqrt(corr_sd[m][k]/nooftimes_final)
				//if(corr_sd[m][k] == 0)
				//corr_sd[m][k] = 1
				//endif
			endfor
		endfor
	endfor
	

	String waveagain
	String waveagain_av
	for ( j = 0; j<numboffiles; j= j+1)
		for (m = 0; m< (floor(numberofrows[successfulfiles[j]]/bin) * floor(numberofcolumns[j]/bin)); m= m+1)
			waveagain = "SD_file_" + num2str(j) + "_pixel_" +num2str(m)
			waveagain_av = "av_file_" + num2str(j) + "_pixel_" + num2str(m)
			Make/N = (channel1 + (channel2-1)*channel1/2)/O $waveagain
			Make/N = (channel1 + (channel2-1)*channel1/2)/O $waveagain_av
			Wave w1 = $waveagain
			Wave w3 = $waveagain_av
			for (k = 0; k< channel1 + (channel2-1)*channel1/2; k = k+1)
				//point_name = "point" + "_" + num2str(j) + "_" + num2str(lagtime[k]) + "_pixel_" + num2str(m)
				//Make/N = (nooftimes_final)/O/D w2
				//wave w2 =  $point_name
				//wavestats/Q w2
				w3[k] = sum_av[m][k]
				w1[k] = corr_sd[m][k]
			endfor
		endfor
	endfor
	print "done"

end


Function exp_fit()

	//wave trial_fit
	wave successfulfiles = root:ITIRFCCS:successfulfiles
	wave numberofrows = root:ITIRFCCS:numberofrows
	wave numberofcolumns = root:ITIRFCCS:numberofcolumns
	NVAR timelag = root:ITIRFCCS:timelag
	wave/T output_bleach = root:ITIRFCCS:output_bleach
	Wave/T FolderFileList = root:ITIRFCCS:FolderFileList
	Make/O/D/N = 5 W_coef
	make/O/D/n = (numberofcolumns[0]*numberofrows[0]) y0, a1, tau1, a2, tau2
	wave int_0_0 = root:ITIRFCCS:int_0_0
	wavestats int_0_0
	Variable no_time= V_npnts
	Make/N = (no_time)/O time_linea
	variable i,j,k,l
	for (i= 0; i< no_time; i=i+1)
		time_linea[i] = i * timelag
	endfor
	Variable V_fitoptions = 4
	String name, fitname
	Make/N = (no_time)/O temp
	Make/N = (no_time)/O fit_temp
	saveexperiment
	for (i = 0; i< numberofcolumns[0]*numberofrows[0]; i= i+1)
		name  = "int_0_" + num2str(i)
	
		CurveFit/NTHR=0/Q/L=(no_time)  dblexp_XOffset  $name/X=time_linea /D
		y0[i] = w_coef[0]
		a1[i] = W_coef[1]
		tau1[i]= w_coef[2]
		a2[i] = w_coef[3]
		tau2[i]= W_coef[4]
		fitname = "fit_int_0_" + num2str(i) 
		wave temp = $name
		wave fit_temp = $fitname
		//print "nnn", no_time
		for( j=0; j<no_time; j=j+1)

			temp[j] =  temp[j]/(fit_temp[j]/fit_temp[0])
		endfor
	endfor
	//print "nnn", no_time 
	//print numberofrows[0],numberofcolumns[0],no_time

	Make/N=(numberofrows[0],numberofcolumns[0],no_time)/D/O corrected_image 
	for (i = 0; i<numberofrows[0]; i = i+1)
		for (j = 0; j<numberofcolumns[0]; j = j+1)
			for (k =0; k<no_time; k=k+1)
				name = "int_0_" + num2str(i*numberofcolumns[0]+j)
				wave temp = $name
				corrected_image[i][j][k] = temp[k]
				//print corrected_image[i][j][k]
			endfor
		endfor
	endfor
	print "aa"
	Folderfilelist[0] = output_bleach[0]
	output_bleach[0] = parsefilepath(5, output_bleach[0], ":", 0,0)
	
	imagesave/T="tiff"/U/S/D =16/O  corrected_image as output_bleach[0]
	
	KillEverything("ctrlName") 
	
end
	
Function KillEverything(ctrlName) : ButtonControl
	String ctrlName
	String windowName
	do
		windowName = WinName(0, 1+2+4+16+64)// Get next target window
		if (CmpStr(windowName, "") == 0) // If name is ""
			break // we are done so break loop
		endif
		DoWindow/K $windowName // Kill this target window
	while (1)
	KillWaves/A // Kill all waves
	ITIRFCCSInitVariables_new();ITIRFCCSShowMainControl_new()
	//KillDataFolder root:ITIRFCCS
	//KillDataFolder root:WinGlobals
End



Function exp1_fit()

	//wave trial_fit
	wave successfulfiles = root:ITIRFCCS:successfulfiles
	wave numberofrows = root:ITIRFCCS:numberofrows
	wave numberofcolumns = root:ITIRFCCS:numberofcolumns
	NVAR timelag = root:ITIRFCCS:timelag
	wave/T output_bleach = root:ITIRFCCS:output_bleach
	Wave/T FolderFileList = root:ITIRFCCS:FolderFileList
	
	wave int_0_0 = root:ITIRFCCS:int_0_0
	wavestats/Q int_0_0
	Variable no_time= V_npnts
	Make/N = (no_time)/O time_linea
	variable i,j,k,l
	NVAR windowsize = root:ITirfccs:windowsize
	String name, fitname
	variable average_bl, average_change
	//	Make/N = (no_time)/O temp
	//	Make/N = (no_time)/O fit_temp
	for (i = 0; i< numberofcolumns[0]*numberofrows[0]; i= i+1)
		//print i
		name  = "int_0_" + num2str(i)
		average_bl = 0 
		average_change = 0
		//	CurveFit/NTHR=0/Q/L=(no_time)  dblexp_XOffset  $name/X=time_linea /D
		//	fitname = "fit_int_0_" + num2str(i) 
		wave temp = $name
		//wavestats temp
		//wave fit_temp = $fitname
		//print "nnn", no_time
		//print windowsize
		for (j =0; j<windowsize; j=j+1)
			average_bl = average_bl + temp[j]
			//print temp[j]
		endfor
		average_bl = average_bl/windowsize
		//print average_bl
	
		for (j = windowsize/2;j<no_time-windowsize/2; j=j+1)
			average_change = 0
			for (k = j-windowsize/2; k<j+windowsize/2;k= k+1)
				average_change =  average_change + temp[k];
			endfor
			average_change = average_change/windowsize;
			temp[j] =  temp[j]/(average_change/average_bl)
			//print average_change/average_bl
		endfor
	
	endfor
	//print "nnn", no_time
	//print numberofrows[0],numberofcolumns[0],no_time

	Make/N=(numberofrows[0],numberofcolumns[0],no_time)/D/O corrected_image 
	for (i = 0; i<numberofrows[0]; i = i+1)
		for (j = 0; j<numberofcolumns[0]; j = j+1)
			for (k =0; k<no_time; k=k+1)
				name = "int_0_" + num2str(i*numberofcolumns[0]+j)
				wave temp = $name
				corrected_image[i][j][k] = temp[k]
				//print corrected_image[i][j][k]
			endfor
		endfor
	endfor
	print "aa"
	Folderfilelist[0] = output_bleach[0]
	output_bleach[0] = parsefilepath(5, output_bleach[0], ":", 0,0)
	
	imagesave/T="tiff"/U/S/D =16/O  corrected_image as output_bleach[0]
end
	
	
Function SaveWavesFromCurrentDF(matchStr)
	//wave/T folderfilelist = root:ITIRFCCS:folderfilelist

	String matchStr // As for the WaveList function.
	wave/T folderfilelist = root:ITIRFCCS:folderfilelist 
	SVAR path_mac= root:ITIRFCCS:path_mac, path_real = root:ITIRFCCS:path_real
	Path_mac = ParseFilePath(5, folderfilelist[0], ":", 0, 0)
	Path_mac= ParseFilepath(1, Path_mac, ":", 1, 0)
	path_real = path_mac
	Path_mac = Path_mac + "tobefitted.txt"
	String list
	list = WaveList(matchStr, ";", "")
	list = list + "lagtime"
	//print path_mac
	Save/J/M="\r\n"/P=Igor/B/O list as Path_mac
End 

Function SaveWavesFromCurrentDF1(matchStr1)
	//wave/T folderfilelist = root:ITIRFCCS:folderfilelist

	String matchStr1 // As for the WaveList function.
	wave/T folderfilelist = root:ITIRFCCS:folderfilelist 
	SVAR  path_mac1 = root:ITIRFCCS:path_mac1, path_real = root:ITIRFCCS:path_real
	Path_mac1 = ParseFilePath(5, folderfilelist[0], ":", 0, 0)
	Path_mac1= ParseFilepath(1, Path_mac1, ":", 1, 0)
	//path_real = path_mac1
	Path_mac1 = Path_mac1 + "sd.txt"
	String list
	list = WaveList(matchStr1, ";", "")
	//list = list + "lagtime"
	//print path_mac1
	Save/J/M="\r\n"/P=Igor/B/O list as Path_mac1
End 



Function histogram_fcs(ctrlName) : ButtonControl
	String ctrlName
	NVAR fit_check = root:ITIRFCCS:fit_check
	if (fit_check>0)
	endif
	
end


Function FCSKoppelWeightWave1()
	//Variable DP
	String name
	variable value
	print "KKKOOO"
	//WAVE WeightWave=root:FCS:WeightWave
	NVAR bin = root:ITIRFCCS:bin
	NVAR firstframe = root:ITIRFCCS:firstframe
	NVAR lastframe = root:ITIRFCCS:lastframe
	NVAR channel1 = root:ITIRFCCS:channel1
	NVAR channel2 = root:ITIRFCCS:channel2
	nvar timelag= root:ITIRFCCS:timelag
	variable AcquisitionTime= timelag*(lastframe - firstframe)
	//WAVE DataNumIndex=root:FCS:DataNumIndex
	
	WAVE XDat=root:ITIRFCCS:lagtime
	
	wave m_value = root:ITIRFCCS:m_value
	
	VARiable XStart = 1
	variable XEnd=channel1 + (channel2-1)*channel1/2

	Variable j,t, mdt, N, M, nn, dt,s1,s2,Gdt,Gmdt, sig = 0.21*5.85e-7, vx = 0, vy = 0
	
	N=1	//Appoximate value of N and tau
	//	for (j=XStart;j<XEnd;j+=1) 
	//		if ((Ydat[j])<(0.5/N+1))
	//			t=Xdat[j]
	//			break
	//		endif
	//	endfor
	//D = 1e-12
	make/n = 11/O estimator = { 0,0, 0,0, 0.5,1e-12, 5.85e-7, 1.45, 1, 1, 0.21, 284e-9}  
	variable squ_dt
	Variable squ_mdt
	
	WAVE Intensity=root:ITIRFCCS:Int_0_0
	wavestats Intensity
	variable average = V_avg
	WAVE YDat=root:ITIRFCCS:display_wave_corr_0
	make/n =(channel1 + (channel2-1)*channel1/2)/o weightwave 
	for(j=XStart;j<XEnd;j+=1)
		mdt=XDat[j]
		dt=XDat[j]-XDat[j-1]
		M=AcquisitionTime/dt
		nn=average*dt/0.001
		
		//Gdt=1/(1+dt/t)
		//Gmdt=1/(1+mdt/t)
		squ_dt = (ITIRFCCS_fit(estimator, dt)-1)* (ITIRFCCS_fit(estimator,dt)-1)
		squ_mdt =  (ITIRFCCS_fit(estimator, mdt)-1)* (ITIRFCCS_fit(estimator, mdt)-1)
		
		s1 =1/M/N/N* ((1 +  squ_dt) * (1 + squ_mdt )/ (1 -squ_dt ) + 2*m_value[j]*squ_mdt)
		//s1=((1+Gdt*Gdt)*(1+Gmdt*Gmdt)/(1-Gdt*Gdt)+2*mdt/dt*Gmdt*Gmdt)/M/N/N
		//s2=(2*(1+Gmdt*Gmdt)/N/nn+(1+Gmdt/N)/nn/nn)/M
		s2 = 1/M *(2/N/nn*(1+ squ_mdt) + 1/nn/nn*(1+  (ITIRFCCS_fit(estimator, mdt)-1)/N))
		WeightWave[j]=sqrt(s1+s2)
		
		if(j>XStart&&(WeightWave[j]>WeightWave[j-1]))
			WeightWave[j]=WeightWave[j-1]
		endif
	endfor	
	variable m1, k1
	wave numberofrows = root:ITIRFCCS:numberofrows
	wave numberofcolumns = root:ITIRFCCS:numberofcolumns
	print "hilll"
	for (m1 = 0; m1< (floor(numberofrows[0]/bin) * floor(numberofcolumns[0]/bin)); m1= m1+1)
		string waveagain = "SD_file_0" +  "_pixel_" +num2str(m1)
		string waveagain_av = "av_file_0"  + "_pixel_" + num2str(m1)
		string an_file_name = "corr_0_" + num2str(m1) + "_" + num2str(m1)
		print waveagain
		Make/N = (channel1 + (channel2-1)*channel1/2)/O $waveagain
		Make/N = (channel1 + (channel2-1)*channel1/2)/O $waveagain_av
		Wave w1 = $waveagain
		Wave w3 = $waveagain_av
		wave w4 = $an_file_name
		for (k1 = 0; k1< channel1 + (channel2-1)*channel1/2; k1 = k1+1)
			//point_name = "point" + "_" + num2str(j) + "_" + num2str(lagtime[k]) + "_pixel_" + num2str(m)
			//Make/N = (nooftimes_final)/O/D w2
			//wave w2 =  $point_name
			//wavestats/Q w2
			w3[k1] = w4[k1]
			w1[k1] = weightwave[k1]
		endfor
	endfor
		
	
End	

Function sd_ca(name,value)

	String name 
	Variable value

	NVAR koppel_display = root:ITIRFCCS:koppel_display
	NVAR sig_it_display = root:ITIRFCCS:sig_it_display 
	NVAR split_frame_display = root:ITIRFCCS:split_frame_display
	ControlInfo/W=ITIRFCCSMainControl_new sd_display1
	print "V_value", V_value
	if(V_Value ==1)
		CheckBox koppel title="koppel", pos={105, 255}, size={14,14}, mode=1, value=koppel_display, proc =  sd_choose, disable = 0
		CheckBox sig_it title="algo", pos={175, 255}, size={14,14}, mode=1, value=sig_it_display, disable = 0, proc= sd_choose
		Checkbox split_frame title = "split", pos = { 225, 255}, size = { 14,14}, mode =1, value = split_frame_display, disable = 0, proc = sd_choose
	else
		CheckBox koppel title="koppel", disable = 1,pos={105,255}, size={14,14}, mode=1, value=koppel_display, proc =  FCSKoppelWeightWave1
		CheckBox sig_it title="algo", disable = 1,pos={135, 255}, size={14,14}, mode=1, value=sig_it_display
		Checkbox split_frame title = "split", disable = 1, pos = { 165, 255}, size = { 14,14}, mode = 1, value = split_frame_display
				
	endif
end		
Function  sd_choose(name,value)

	String name
	Variable value
	strswitch(name)
		case "koppel":
			CheckBox koppel value = 1
			CheckBox sig_it value = 0
			Checkbox split_frame value = 0
			break
				
		case "sig_it":
			checkbox koppel value = 0
			checkbox sig_it value = 1
			checkbox split_frame value = 0
			break
				
				
		case "split_frame":
			checkbox koppel value = 0
			checkbox sig_it value = 0
			checkbox split_frame value = 1
			break
				
				
	endswitch
end
				
Function his_pop(ctrlName,popNum,popStr) : PopupMenuControl
	String ctrlName
	Variable popNum // which item is currently selected (1-based)
	String popStr 
	Nvar fit_check = root:ITIRFCCS:fit_check
	//v_value_ decides the value of the type of correlation in
	nvar v_value_ = root:ITIRFCCS:v_value_
	//NVAR pixel = root:ITIRFCCS:pixel
	NVar auto_bin = root:ITIRFCCS:auto_bin
	
	NVAR v_size = root:ITIRFCCS:v_size
	NVAR v_start = root:ITIRFCCS:v_start
	NVAR v_end = root:ITIRFCCS:v_end
	if (fit_check>0)
		wave Diff_co_0 = root:ITIRFCCS:Diff_co_0
		wave DC_0 = root:ITIRFCCS:DC_0
		wave Number_0 = root:ITIRFCCS:number_0
		wave chisq_0 = root:ITIRFCCS:chisq_0
		wave sig_0 = root:ITIRFCCS:sig_0
		Variable bin
		ControlInfo/w =ITIRFCCSmaincontrol_new  histo
		if(v_value == 1)
	
	

			StatsQuantiles/iNaN Diff_co_0
			wavestats Diff_co_0
			bin = ceil (V_npnts ^ (1/3) * (V_max - V_min)/2/V_IQR)
			print V_npnts
			print V_max, V_min, V_IQR
			Make/N=(Bin)/O Diff_co_0_Hist;
			//			//Histogram/B={V_min,(V_max-V_min)/Bin,Bin} Diff_co_0,Diff_co_0_Hist
			//			//if (V_avg - 3* V_sdev > 1e-16)
			//				Histogram/B={V_avg - 3* V_sdev,V_sdev*6/Bin,Bin} Diff_co_0,Diff_co_0_Hist
			//			//else
			//				//Histogram/B={0,V_sdev*6/Bin,Bin} Diff_co_0,Diff_co_0_Hist
			//			//endif
			if (auto_bin ==1)
				//Histogram/B={V_avg - 3* V_sdev,V_sdev*6/Bin,Bin} area_value_hor0,area_value_hor0_hist
				//print V_avg - 3* V_sdev, V_sdev*6/Bin,Bin
				if (V_avg - 3* V_sdev > 1e-16)
					Histogram/B={V_avg - 3* V_sdev,V_sdev*6/Bin,Bin} Diff_co_0,Diff_co_0_Hist
				else
					Histogram/B={0,V_sdev*6/Bin,Bin} Diff_co_0,Diff_co_0_Hist
				endif
			else
				Histogram/B={v_start,v_size,floor((v_end - v_start)/v_size)} Diff_co_0,Diff_co_0_Hist
				//print v_start,v_size,ceil((v_end - v_start)/v_size)
			endif
			Display/I/W = (0,4.35, 2,6.85) Diff_co_0_hist
			ModifyGraph mode=5
			ModifyGraph mirror=2
			//ModifyGraph width=151.2,height={Aspect,1}
			ModifyGraph useNegRGB=1,usePlusRGB=1,hbFill=2,rgb=(0,0,0);DelayUpdate
			ModifyGraph negRGB=(47872,47872,47872),plusRGB=(47872,47872,47872)
			TextBox/C/N=text0/F=0/Z=1/A=MT/E num2str(V_avg) + " +- " + num2str(V_sdev)
		endif
	
		if(v_value == 2)
	
	
	
			StatsQuantiles/iNaN Number_0
			wavestats Number_0
			bin = ceil (V_npnts ^ (1/3) * (V_max - V_min)/2/V_IQR)
	
			Make/N=(Bin)/O Number_0_Hist;DelayUpdate
			//Histogram/B={V_min,(V_max-V_min)/Bin,Bin} Number_0,Number_0_Hist
			//if (V_avg - 3* V_sdev > 1e-16)
			//Histogram/B={V_avg - 3* V_sdev,V_sdev*6/Bin,Bin} Number_0,Number_0_Hist
			//else
			//Histogram/B={0,V_sdev*6/Bin,Bin} Number_0,Number_0_Hist
			//endif
			if (auto_bin ==1)
				//Histogram/B={V_avg - 3* V_sdev,V_sdev*6/Bin,Bin} area_value_hor0,area_value_hor0_hist
				//print V_avg - 3* V_sdev, V_sdev*6/Bin,Bin
				if (V_avg - 3* V_sdev > 1e-16)
					Histogram/B={V_avg - 3* V_sdev,V_sdev*6/Bin,Bin} Number_0,Number_0_Hist
				else
					Histogram/B={0,V_sdev*6/Bin,Bin} Number_0,Number_0_Hist
				endif
			else
				Histogram/B={v_start,v_size,floor((v_end - v_start)/v_size)} Number_0,Number_0_Hist
				//print v_start,v_size,ceil((v_end - v_start)/v_size)
			endif
			Display/I/W = (4.5, 4.35, 6.5, 6.85) Number_0_hist
			//Display/I/W = (2.5,0.5,4.5,2.5)   number_0_hist
			ModifyGraph mode=5
			ModifyGraph mirror=2
			//ModifyGraph width=151.2,height={Aspect,1}
			ModifyGraph useNegRGB=1,usePlusRGB=1,hbFill=2,rgb=(0,0,0);DelayUpdate
			ModifyGraph negRGB=(47872,47872,47872),plusRGB=(47872,47872,47872)
			TextBox/C/N=text0/F=0/Z=1/A=MT/E num2str(V_avg) + " +- " + num2str(V_sdev)
		endif
	
		if(v_value == 3)
		endif
	
		if(v_value == 4)
	
	

			StatsQuantiles/iNaN DC_0 
			wavestats DC_0
			bin = ceil (V_npnts ^ (1/3) * (V_max - V_min)/2/V_IQR)
			Make/N=(Bin)/O DC_0_Hist;DelayUpdate
			//Histogram/B={V_min,(V_max-V_min)/Bin,Bin} DC_0,DC_0_Hist
			//			if (V_avg - 3* V_sdev > 1e-16)
			//				Histogram/B={V_avg - 3* V_sdev,V_sdev*6/Bin,Bin} DC_0,DC_0_Hist
			//			else
			//				Histogram/B={0,V_sdev*6/Bin,Bin} DC_0,DC_0_Hist
			//			endif
			if (auto_bin ==1)
				//Histogram/B={V_avg - 3* V_sdev,V_sdev*6/Bin,Bin} area_value_hor0,area_value_hor0_hist
				//print V_avg - 3* V_sdev, V_sdev*6/Bin,Bin
				if (V_avg - 3* V_sdev > 1e-16)
					Histogram/B={V_avg - 3* V_sdev,V_sdev*6/Bin,Bin} DC_0,DC_0_Hist
				else
					Histogram/B={0,V_sdev*6/Bin,Bin} DC_0,DC_0_Hist
				endif
			else
				Histogram/B={v_start,v_size,floor((v_end - v_start)/v_size)} DC_0,DC_0_Hist
				//print v_start,v_size,ceil((v_end - v_start)/v_size)
			endif
			Display/I/W = (0,7.25,2, 9.75) DC_0_hist
			//Display/W = (0,7.25,2, 9.75) sig_0_Hist
			ModifyGraph mode=5
			ModifyGraph mirror=2
			//ModifyGraph width=151.2,height={Aspect,2}
			ModifyGraph useNegRGB=1,usePlusRGB=1,hbFill=2,rgb=(0,0,0);DelayUpdate
			ModifyGraph negRGB=(47872,47872,47872),plusRGB=(47872,47872,47872)
			TextBox/C/N=text0/F=0/Z=1/A=MT/E num2str(V_avg) + " +- " + num2str(V_sdev)
		endif
	
		if(v_value == 5)
	
	
	
			StatsQuantiles/iNaN chisq_0
			wavestats chisq_0
			bin = ceil (V_npnts ^ (1/3) * (V_max - V_min)/2/V_IQR)
			Make/N=(Bin)/O chisq_0_Hist;DelayUpdate
			if (auto_bin ==1)
				//Histogram/B={V_avg - 3* V_sdev,V_sdev*6/Bin,Bin} area_value_hor0,area_value_hor0_hist
				//print V_avg - 3* V_sdev, V_sdev*6/Bin,Bin
				if (V_avg - 3* V_sdev > 1e-16)
					Histogram/B={V_avg - 3* V_sdev,V_sdev*6/Bin,Bin} chisq_0,chisq_0_Hist
				else
					Histogram/B={0,V_sdev*6/Bin,Bin} chisq_0,chisq_0_Hist
				endif
			else
				Histogram/B={v_start,v_size,floor((v_end - v_start)/v_size)} chisq_0,chisq_0_Hist
				//print v_start,v_size,ceil((v_end - v_start)/v_size)
			endif
			Display/I/W = (2.25,4.35,4.25, 6.85)  chisq_0_hist
			//	ModifyGraph width=151.2,height={Aspect,1}
			ModifyGraph mode=5
			ModifyGraph mirror=2
			ModifyGraph useNegRGB=1,usePlusRGB=1,hbFill=2,rgb=(0,0,0);DelayUpdate
			ModifyGraph negRGB=(47872,47872,47872),plusRGB=(47872,47872,47872)
			TextBox/C/N=text0/F=0/Z=1/A=MT/E num2str(V_avg) + " +- " + num2str(V_sdev)
		endif
		

	
	
	
	endif 
	
	if(v_value_ ==2 || v_value_ ==4 || v_value ==8)
	
		wave area_value_hor0 = root:ITIRFCCS:area_value_hor0
		ControlInfo/w =ITIRFCCSmaincontrol_new  histo
		if(v_value == 6)
			StatsQuantiles/iNaN area_value_hor0
			wavestats area_value_hor0
			bin = ceil (V_npnts ^ (1/3) * (V_max - V_min)/2/V_IQR)
			Make/N=(Bin)/O area_value_hor0_Hist;DelayUpdate
			if (auto_bin ==1)
				Histogram/B={V_avg - 3* V_sdev,V_sdev*6/Bin,Bin} area_value_hor0,area_value_hor0_hist
				//print V_avg - 3* V_sdev, V_sdev*6/Bin,Bin
			else
				Histogram/B={v_start,v_size,floor((v_end - v_start)/v_size)} area_value_hor0,area_value_hor0_hist
				//print v_start,v_size,floor((v_end - v_start)/v_size)
			endif
			Display/W = (0,0.5, 3,3.5)  area_value_hor0_hist
			ModifyGraph width=151.2,height={Aspect,1}
			ModifyGraph mode=5
			ModifyGraph mirror=2
			ModifyGraph useNegRGB=1,usePlusRGB=1,hbFill=2,rgb=(0,0,0);DelayUpdate
			ModifyGraph negRGB=(47872,47872,47872),plusRGB=(47872,47872,47872)
		endif
	endif
	
	if(v_value_ ==3 || v_value_ == 4 || v_value == 8)
		wave area_value_ver0 = root:ITIRFCCS:area_value_ver0
		ControlInfo/w =ITIRFCCSmaincontrol_new  histo
		if(v_value == 7)
			StatsQuantiles/iNaN area_value_ver0
			wavestats area_value_ver0
			bin = ceil (V_npnts ^ (1/3) * (V_max - V_min)/2/V_IQR)
			Make/N=(Bin)/O area_value_ver0_Hist;DelayUpdate

			if (auto_bin ==1)
				Histogram/B={V_avg - 3* V_sdev,V_sdev*6/Bin,Bin} area_value_ver0,area_value_ver0_hist
				//print V_avg - 3* V_sdev, V_sdev*6/Bin,Bin
			else
				Histogram/B={v_start,v_size,floor((v_end - v_start)/v_size)} area_value_ver0,area_value_ver0_hist
				//print v_start,v_size,floor((v_end - v_start)/v_size)
			endif
			Display/W = (0,0.5, 3,3.5)  area_value_ver0_hist
			ModifyGraph width=151.2,height={Aspect,1}
			ModifyGraph mode=5
			ModifyGraph mirror=2
			ModifyGraph useNegRGB=1,usePlusRGB=1,hbFill=2,rgb=(0,0,0);DelayUpdate
			ModifyGraph negRGB=(47872,47872,47872),plusRGB=(47872,47872,47872)
		endif
	endif
	
	
end
	
Function MyCheckProc_histogram(name,value)
	
	String name
	Variable value
	NVAR v_start = root:ITIRFCCS:v_start
	NVAR v_end = root:ITIRFCCS:v_end
	NVAR v_size = root:ITIRFCCS:v_size
	NVAR auto_bin= root:ITIRFCCS:auto_bin
	NVAR manual_bin= root:ITIRFCCS:manual_bin
	strswitch(name)
			
		case  "automated_bin":
			//NVAR logarithmiccorrelation= root:ITIRFCCS: logarithmiccorrelation
			auto_bin = 1
			manual_bin =0
			CheckBox automated_bin value = 1
			CheckBox manual_bin, value = 0
			SetVariable startvalue, disable = 1
			SetVariable endvalue, disable = 1
			
			print "nnn"
			SetVariable sizeofbin, disable = 1
			break
	
		Case "manual_bin":
			//NVAR logarithmiccorrelation= root:ITIRFCCS: logarithmiccorrelation
			auto_bin = 0
			manual_bin = 1
			CheckBox automated_bin value = 0
			CheckBox manual_bin, value =1
			
			SetVariable startvalue, disable = 0,title="start ", fsize=10, font="Arial", pos={10,670},size={80,25},frame=1, value = v_start
			SetVariable endvalue, disable = 0,title="end   ", fsize=10, font="Arial", pos={100,670},size={80,25},frame=1, value = v_end
			SetVariable sizeofbin, disable = 0, title="width", fsize=10, font="Arial", pos={190,670},size={80,25},frame=1, value = v_size
			print "aaa", auto_bin, v_size
			break
			
			
	EndSwitch


End

Function Calibration(ctrlName) : ButtonControl
	String ctrlName
	variable binend=6
	NewPanel /N=ProgressPanel /W=(285,711,739,793)
	ValDisplay valdisp0,pos={18,32},size={342,18}
	ValDisplay valdisp0,limits={0, (binend-1)*3+1,0},barmisc={0,0}
	ValDisplay valdisp0,value= _NUM:0
	Button bStop,pos={375,32},size={50,20},title="Stop" 
	DoUpdate /W=ProgressPanel /E=1// mark this as our progress window

	Variable/G background_for_program
	Variable V_FitQuitReason = 0
	Variable V_fitoptions = 4

	NVAR bin = root:ITIRFCCS:bin 
	NVAR firstframe = root:ITIRFCCS:firstframe
	NVAR lastframe = root:ITIRFCCS:lastframe
	NVAR channel1 = root:ITIRFCCS:channel1
	NVAR channel2 = root:ITIRFCCS:channel2
	NVAR Background = root:ITIRFCCS:Background
	NVAR logarithmiccorrelation = root:ITIRFCCS:logarithmiccorrelation
	SVAR basename = root:ITIRFCCS:basename
	NVAR spim_mod = root:ITIRFCCS:spim_Mod


	Wave lagtime = root:ITIRFCCS:lagtime
	Wave numberofrows = root:ITIRFCCS:numberofrows
	Wave numberofcolumns = root:ITIRFCCS:numberofcolumns
	Wave minimum = root:ITIRFCCS:minimum

	Wave/T FolderFileList = root:ITIRFCCS:FolderFileList
	Wave/T output_corr= root:ITIRFCCS:output_corr
	Wave/T output_int = root:ITIRFCCS:output_int
	Wave/T output_minimum = root:ITIRFCCS:output_minimum
	Wave/T output_corr_dis = root:ITIRFCCS:output_corr_dis
	//Wave/T output_int_dis = root:ITIRFCCS:output_int_dis
	Wave/T output_sd = root:ITIRFCCS:output_sd
 
	Variable i,j,k,l = 0,m 

	if (Background > minimum[0])
		Background_for_program = minimum[0]
	else
		background_for_program = Background
	endif

	for (bin = 1; bin<binend; bin= bin+1)

		//print bin

		Make/N = ((numberofrows[0]- bin+1) * (numberofcolumns[0]- bin+1))/O/D w1
		Make/N = ((numberofrows[0]- bin+1) * (numberofcolumns[0]- bin+1))/O/D w2
		Make/T/N =3/O corr_name
		corr_name[0] = "corr_" + num2str(bin) + "_"
		corr_name[1] = "firstpixel_" + num2str(bin) + "_"
		corr_name[2] = "secondpixel_" + num2str(bin) + "_"
		//print corr_name[0]
		l = 0

		for (j = 0; j<numberofrows[0]- bin+1; j= j+1)
			for (k = 0; k<numberofcolumns[0]- bin+1; k= k+1)
				w1[l] = j*numberofcolumns[0] + k
				w2[l] = w1[l]
				l = l+ 1
			Endfor
		Endfor
			



		tif_program(FolderFileList[0], output_corr[0], output_int[0], FirstFrame, LastFrame, Background_for_program, Bin, channel1, channel2,w1,w2)
		GBLoadWave/Q/B/A=$corr_name[0]/T={2,2}/W=((numberofrows[0]- bin+1) * (numberofcolumns[0]- bin+1))/U=(channel1 + (channel2-1)*channel1/2) output_corr[0]
		Deletefile output_int[0]
		Deletefile output_corr[0]
		Duplicate/O w1, $corr_name[1]; KillWaves w1
		Duplicate/O w2, $corr_name[2]; KillWaves w2

	endfor



	//////////////curve fitting///////////////////
	NVAR D = root:ITIRFCCS:D
	NVAR lambda = root:ITIRFCCS:lambda
	NVAR lambda_exc = root:ITIRFCCS:lambda_exc
	NVAR sigma = root:ITIRFCCS:sigma 
	NVAR N = root:ITIRFCCS:N
	NVAR pixel = root:ITIRFCCS:pixel
	NVAR NA = root:ITIRFCCS:NA
	NVAR NA_exc = root:ITIRFCCS:NA_exc
	NVAR Bin = root:ITIRFCCS:Bin
	if(spim_mod==1)
		NVAR sigz = root:ITIRFCCS:sigz
	endif
	wave lagtime = root:ITIRFCCS:lagtime
	Make/O/D/N = 12 W_coef
	if(spim_mod==1)
		Make/O/D/N = 15 W_coef
	endif

	//for (bin = 1; bin<6; bin= bin+1)
	// 
	//

	String Diff_co, Number, sig, DC, chisq, fir_pix_fit_str, sec_pix_fit_str, wave_fit_name, reason1, vel_x, vel_y, sigz_name
	String Diff_co_1, Number_1, xaxis_str, yaxis_str, yaxis_dlaw_str, sigz_str
	//bin = 1
	variable sig_count = 0	
	make/n =2/O a_values
	make/n =2/O b_values
	variable V_a,V_b
	variable temp=1
	//for (sig_count =0; sig_count<1; sig_count = sig_count +1)	
	for (sig_count =0; sig_count<3; sig_count = sig_count +1)	
		xaxis_str = "xaxis_" + num2str(sig_count)
		yaxis_str = "yaxis_" + num2str(sig_count)
		yaxis_dlaw_str = "yaxis_dlaw_" + num2str(sig_count)
		for (bin =1; bin < binend; bin = bin+1)	
			temp=temp+1
			ValDisplay valdisp0,value= _NUM:temp,win=ProgressPanel
			//endif
			DoUpdate /W=ProgressPanel
			variable display_counter = 0
	
			for ( 	m =0;  m <((numberofrows[0]- bin+1) * (numberofcolumns[0]- bin+1)); m= m+1)
				//fitted_name = "fit_" + basename + "_" + num2str(successfulfiles[i]) + "_" + num2str(fir_pixelfit[m]) + "_" +num2str(sec_pixelfit[m])
				wave_fit_name = "corr_" + num2str(bin) + "_" + num2str(m)	//make/N = (channel1 + (channel2-1)*8)/O $fittedname
				//wave w1_fit = $fitted_name
				Wave w1 = root:ITIRFCCS:$wave_fit_name
				if(display_counter==0)
					Display $wave_fit_name vs lagtime
					//ModifyGraph width=7000,height={Aspect,1}
					display_counter = display_counter+1
					//Dowindow
				else
					AppendTograph $wave_fit_name vs lagtime
					//display_counter = display_counter + 1
				endif
			endfor
			ModifyGraph log(bottom)=1	
			Diff_co = "Diff_co_"+ num2str(bin) + "_" + num2str(sig_count)
			Diff_co_1 = "Diff_co_1D_"+ num2str(bin) + "_" + num2str(sig_count)
			Number  = "Number_ " + num2str(bin) + "_" + num2str(sig_count)
			Number_1  = "Number_ 1D_" + num2str(bin) + "_" + num2str(sig_count)
			sig = "sig_" + num2str(bin) + "_" + num2str(sig_count)
			chisq = "chisq_" + num2str(bin) + "_" + num2str(sig_count) 
			DC = "DC_" + num2str(bin) + "_" + num2str(sig_count)
			sigz_str = "sigz_" + num2str(bin) + "_" + num2str(sig_count)
			Make/N=((numberofrows[0]- bin+1) * (numberofcolumns[0]- bin+1))/O w_diff_co
			Make/N =((numberofrows[0]- bin+1) * (numberofcolumns[0]- bin+1))/O w_number
			Make/N = ((numberofrows[0]- bin+1) * (numberofcolumns[0]- bin+1))/O w_sig 
			Make/N = ((numberofrows[0]- bin+1) * (numberofcolumns[0]- bin+1))/O w_dc 
			Make/N = ((numberofrows[0]- bin+1) * (numberofcolumns[0]- bin+1))/O w_chisq 
			Make/N = ((numberofrows[0]- bin+1) * (numberofcolumns[0]- bin+1))/O w_sigz

			for ( m =0; m <((numberofrows[0]- bin+1) * (numberofcolumns[0]- bin+1)); m= m+1)
				//print m
				if(sig_count == 0)
					sigma = 0.3
					//sigma = 0.4
				endif
				if(sig_count ==1)
					sigma =0.5
				endif
				if(sig_count==2)
					sigma = 0.3 - b_values[0]*(0.5-0.3)/(b_values[1] - b_values[0])
				endif
				if(spim_mod==0)

					W_coef=  {0,0,0,0, Bin/2, D, lambda, NA, N*bin*bin,1,sigma,pixel}
				endif
				if(spim_mod==1)
					W_coef=  {0,0,0,0, Bin, D, lambda,  NA,  N,1,sigma,pixel, SIGZ, lambda_exc, NA_exc}
				endif
			
				//endif
				wave_fit_name = "corr_" + num2str(bin) + "_" + num2str(m)
				Wave w1 = root:ITIRFCCS:$wave_fit_name			

				if(spim_mod==0)
					//if(m==0)
					//FuncFit /x=1/q/H="111110110011"  ITIRFCCS_fit W_coef  w1[1,channel1 + (channel2-1)*channel1/2-1]/X=lagtime/D
					//else
					FuncFit/N=1 /q/H="111110110011"  ITIRFCCS_fit W_coef  w1[1,channel1 + (channel2-1)*channel1/2-1]/X=lagtime/D
					//endif
				endif

				//print winname(0,1)
				//	wave w_coef
				if (spim_mod ==1)
					//if(m==0)
					//FuncFit /x=1/q/H="111110110011111"  ITIRFCCS_spim W_coef  w1[1,channel1 + (channel2-1)*channel1/2-1]/X=lagtime/D/R/A=0; 
					//else
					FuncFit /N=1/q/H="111110110011111"  ITIRFCCS_spim W_coef  w1[1,channel1 + (channel2-1)*channel1/2-1]/X=lagtime/D/R/A=0; 

					//else
					//FuncFit /x=1/H="11" + num2str(vx_fit_value) + num2str(vy_fit_value) + "1" + num2str(D_fit_value) + "1100" + num2str(fit_value) +"1"  ITIRFCCS_fit W_coef  w1[1,channel1 + (channel2-1)*channel1/2-1]/X=lagtime/D/R/A=0; 
					//endif
				endif
				if(V_FitQuitReason == 0)
	 
					w_diff_co[m] = W_coef[5] 
					w_sig[m] = w_coef[10]
					w_chisq[m] = V_chisq
					w_number[m] = w_coef[8]
					w_dc[m] = w_coef[9]
					if (spim_mod ==1)
						w_sigz[m] = w_coef[12]
					endif
	
				else
	
					w_diff_co[m] = nan
					w_sig[m] = nan
					w_chisq[m] = nan
					w_number[m] = nan
					w_dc[m] = nan
					if (spim_mod ==1)
						w_sigz[m] =nan
					endif
	
				
				endif
				//((numberofrows[0]- bin+1) * (numberofcolumns[0]- bin+1))	

			endfor
			Redimension/N = (numberofcolumns[0]- bin+1,numberofrows[0]- bin+1) w_diff_co
			Redimension/N = (numberofcolumns[0]- bin+1,numberofrows[0]- bin+1) w_sig
			Redimension/N = (numberofcolumns[0]- bin+1,numberofrows[0]- bin+1) w_DC
			Redimension/N = (numberofcolumns[0]- bin+1,numberofrows[0]- bin+1) w_chisq
			Redimension/N = (numberofcolumns[0]- bin+1,numberofrows[0]- bin+1) w_number
			if (spim_mod ==1)
				Redimension/N = (numberofcolumns[0]- bin+1,numberofrows[0]- bin+1) w_sigz
			endif
			Duplicate/O w_diff_co, $Diff_co; 
			Duplicate/O w_diff_co, $Diff_co_1; 
			Redimension/N=((numberofcolumns[0]- bin+1)*(numberofrows[0]- bin+1)) $Diff_co_1
			KillWaves w_diff_co
			Duplicate/O w_sig,  $sig; KillWaves w_sig
			if (spim_mod ==1)
				Duplicate/O w_sigz,  $sig; KillWaves w_sigz
			endif
			Duplicate/O w_dc,  $DC; KillWaves w_dc
			Duplicate/O w_chisq, $chisq; KillWaves w_chisq	
			Duplicate/O w_number, $Number; 
			Duplicate/O w_number, $Number_1; 
			Redimension/N=((numberofcolumns[0]- bin+1)*(numberofrows[0]- bin+1)) $Number_1
			KillWaves w_number
		endfor	 

		variable numberofpts = 0, temp_1, temp_2=0

		bin = binend-1

		for (i = 1; i<=bin; i = i+1)
			numberofpts = numberofpts + (numberofcolumns[0]- i+1)*(numberofrows[0]- i+1)
			print numberofpts
		endfor

		make/n=(numberofpts) xaxis
		make/n=(numberofpts) yaxis
		make/n=(numberofpts) yaxis_dlaw

		for (i = 1; i<=bin; i = i+1)

			if (i>1)
				temp_2 = temp_2 +  (numberofcolumns[0]- (i-1)+1)*(numberofrows[0]- (i-1)+1)
			endif

			Diff_co_1 = "Diff_co_1D_"+ num2str(i) + "_" + num2str(sig_count)
			wave wn = root:ITIRFCCS:$Diff_co_1
			for (j=0; j<(numberofcolumns[0]- i+1)*(numberofrows[0]- i+1); j=j+1)
				xaxis[temp_2 +j] = i*i*pixel*pixel
				yaxis[temp_2 +j] = wn[j]
				yaxis_dlaw[temp_2+j] = i*i*pixel*pixel/wn[j]
			endfor
		endfor 
		Duplicate/O xaxis,  $xaxis_str; KillWaves xaxis
		Duplicate/O yaxis,  $yaxis_str; KillWaves yaxis
		Duplicate/O  yaxis_dlaw,  $yaxis_dlaw_str; KillWaves  yaxis_dlaw
		Display  $yaxis_str vs  $xaxis_str
		ModifyGraph mode=3
		CurveFit/M=2/W=0 line, $yaxis_str/X=$xaxis_str/D
		a_values[sig_count] =w_coef[0]
		b_values[sig_count] =w_coef[1]
		//PRINT "HELLO", a_values[sig_count]
		//Display $yaxis_dlaw_str vs $xaxis_str
		//ModifyGraph mode=3
		//CurveFit/M=2/W=0 line, $yaxis_dlaw_str/X=$xaxis_str/D
		if( sig_count ==1)
			print "the value of D is", (a_values[0] + a_values[1])/2
			print "the corresponding sigma is", 0.5 - b_values[0]*(0.5-0.3)/(b_values[1] - b_values[0]) 
		endif
	endfor 
	print time()
	KillWindow ProgressPanel
end	  



Function display_choose(name, value)

	String name
	Variable value
	
	strswitch(name)
			//NVAR logarithmiccorrelation= root:ITIRFCCS:logarithmiccorrelation

		case "image_show":
			NVAR image_display= root:ITIRFCCS:image_display
			NVAR histogram_display = root:ITIRFCCS:histogram_display
			histogram_display = 0
			CheckBox image_Show, value = 1
			CheckBox histogram_show, value = 0
			//SetVariable channel1, disable = 1,title="Group1_ch_n ", fsize=10, font="Arial", pos={170,160},size={110,25},frame=1, limits={1,99,1},value = Channel1
			//SetVariable channel2, disable = 1, title="Group_n          ", fsize=10, font="Arial", pos={170,190},size={110,25},frame=1, limits={1,99,1},value = Channel2
			Dowindow/F Dif
			Dowindow/F Chisq
			Dowindow/F No
			Dowindow/F DC
			Dowindow/F Sig
			//SetVariable linearpoints, disable = 0, title="Points", fsize=10, font="Arial", pos={170,160},size={110,25},frame=1, limits={1,10000,1},value = linearpoints
			//Dowindow/F Dif
			break
	
		Case "histogram_show":
			//NVAR logarithmiccorrelation= root:ITIRFCCS:logarithmiccorrelation
			//logarithmiccorrelation = 1
			NVAR image_display= root:ITIRFCCS:image_display
			NVAR histogram_display = root:ITIRFCCS:histogram_display
			image_display = 0
			CheckBox image_Show, value = 0
			CheckBox histogram_show, value = 1
			//ModifyImage Dif ctab= {*,*,BlueRedGreen,0}
			Dowindow/B Dif
			Dowindow/B Chisq
			Dowindow/B No
			Dowindow/B DC
			Dowindow/B Sig
			break
			
			
	EndSwitch


End


Function Remove_pixel(ctrlName) : ButtonControl
	String ctrlName
	NVAR pixel_d= root:ITIRFCCS:pixel_d
	NVAR fit_check = root:ITIRFCCS:fit_check
	if(fit_check>0)
		wave diff_co_0 = root:ITirFCCS:diff_co_0
		wave chisq_0 = root:ITIRFCCS:chisq_0
		wave number_0= root:ITIRFCCS:number_0
		wave dc_0 = root:ITIRFCCS:dc_0
		wave sig_0= root:ITiRFCCS:sig_0

		variable i, j
		i=hcsr(A)
		j=vcsr(A)
		diff_co_0[i][j]= nan
		chisq_0[i][j]=nan
		number_0[i][j]= nan
		dc_0[i][j]=nan
		sig_0[i][j]= nan

		variable bin1
		StatsQuantiles/iNaN Diff_co_0
		wavestats Diff_co_0
		bin1 = ceil (V_npnts ^ (1/3) * (V_max - V_min)/2/V_IQR)
		Make/N=(Bin1)/O Diff_co_0_Hist;

		if (V_avg - 3* V_sdev > 1e-16)
			Histogram/B={V_avg - 3* V_sdev,V_sdev*6/Bin1,Bin1} Diff_co_0,Diff_co_0_Hist
		else
			Histogram/B={0,V_sdev*6/Bin1,Bin1} Diff_co_0,Diff_co_0_Hist
		endif
		Display/I/W = (0,4.35, 2,6.85) Diff_co_0_hist
		ModifyGraph mode=5
		ModifyGraph mirror=2
		//ModifyGraph width=151.2,height={Aspect,1}
		ModifyGraph useNegRGB=1,usePlusRGB=1,hbFill=2,rgb=(0,0,0); 
		ModifyGraph negRGB=(47872,47872,47872),plusRGB=(47872,47872,47872)
		TextBox/C/N=text0/F=0/Z=1/A=MT/E num2str(V_avg) + " +- " + num2str(V_sdev)

	
	
		StatsQuantiles/iNaN Number_0
		wavestats Number_0
		bin1 = ceil (V_npnts ^ (1/3) * (V_max - V_min)/2/V_IQR)
	
		Make/N=(Bin1)/O Number_0_Hist;

		if (V_avg - 3* V_sdev > 1e-16)
			Histogram/B={V_avg - 3* V_sdev,V_sdev*6/Bin1,Bin1} Number_0,Number_0_Hist
		else
			Histogram/B={0,V_sdev*6/Bin1,Bin1} Number_0,Number_0_Hist
		endif

		Display/I/W = (4.5, 4.35, 6.5, 6.85) Number_0_hist
		//Display/I/W = (2.5,0.5,4.5,2.5)   number_0_hist
		ModifyGraph mode=5
		ModifyGraph mirror=2
		//ModifyGraph width=151.2,height={Aspect,1}
		ModifyGraph useNegRGB=1,usePlusRGB=1,hbFill=2,rgb=(0,0,0); 
		ModifyGraph negRGB=(47872,47872,47872),plusRGB=(47872,47872,47872)
		TextBox/C/N=text0/F=0/Z=1/A=MT/E num2str(V_avg) + " +- " + num2str(V_sdev)
	

		StatsQuantiles/iNaN DC_0  
		wavestats DC_0
		bin1 = ceil (V_npnts ^ (1/3) * (V_max - V_min)/2/V_IQR)
		Make/N=(Bin1)/O DC_0_Hist; 

		if (V_avg - 3* V_sdev > 1e-16)
			Histogram/B={V_avg - 3* V_sdev,V_sdev*6/Bin1,Bin1} DC_0,DC_0_Hist
		else
			Histogram/B={0,V_sdev*6/Bin1,Bin1} DC_0,DC_0_Hist
		endif

		Display/I/W = (0,7.25,2, 9.75) DC_0_hist
		//Display/W = (0,7.25,2, 9.75) sig_0_Hist
		ModifyGraph mode=5
		ModifyGraph mirror=2
		//ModifyGraph width=151.2,height={Aspect,2}
		ModifyGraph useNegRGB=1,usePlusRGB=1,hbFill=2,rgb=(0,0,0); 
		ModifyGraph negRGB=(47872,47872,47872),plusRGB=(47872,47872,47872)
		TextBox/C/N=text0/F=0/Z=1/A=MT/E num2str(V_avg) + " +- " + num2str(V_sdev)

		StatsQuantiles/iNaN chisq_0
		wavestats chisq_0
		bin1 = ceil (V_npnts ^ (1/3) * (V_max - V_min)/2/V_IQR)
		Make/N=(Bin1)/O chisq_0_Hist; 

		if (V_avg - 3* V_sdev > 1e-16)
			Histogram/B={V_avg - 3* V_sdev,V_sdev*6/Bin1,Bin1} chisq_0,chisq_0_Hist
		else
			Histogram/B={0,V_sdev*6/Bin1,Bin1} chisq_0,chisq_0_Hist
		endif
		

		Display/I/W = (2.25,4.35,4.25, 6.85)  chisq_0_hist
		//	ModifyGraph width=151.2,height={Aspect,1}
		ModifyGraph mode=5
		ModifyGraph mirror=2
		ModifyGraph useNegRGB=1,usePlusRGB=1,hbFill=2,rgb=(0,0,0); 
		ModifyGraph negRGB=(47872,47872,47872),plusRGB=(47872,47872,47872)
		TextBox/C/N=text0/F=0/Z=1/A=MT/E num2str(V_avg) + " +- " + num2str(V_sdev)

		Dowindow/F Dif
		Dowindow/F Chisq
		Dowindow/F No
		Dowindow/F DC
		Dowindow/F Sig
	else
		String new = "corr_0_" + num2str(pixel_d) + "_" + num2str(pixel_d)
		wave w2= root:ITIRFCCS:$new
		print w2
		w2=nan
	endif

End

Function Plot_all(ctrlName) : ButtonControl
	String ctrlName
	variable display_counter = 0
	SVAR basename = root:ITIRFCCS:basename
	variable m
	wave lagtime = root:ITIRFCCS:lagtime
	wave successfulfiles = root:ITIRFCCS:successfulfiles
	wave numberofrows = root:ITIRFCCS:numberofrows
	wave numberofcolumns = root:ITIRFCCS:numberofcolumns
	NVAR Bin = root:ITIRFCCS:Bin
	NVAR fit_check = root:ITIRFCCS:fit_check
	String wave_fit_name, wave_fit_name1
	String  fir_pix_fit_str, sec_pix_fit_str
	fir_pix_fit_str = "firstpixel" + num2str(successfulfiles[0])
	Wave fir_pixelfit = root:ITIRFCCS:$fir_pix_fit_str

	sec_pix_fit_str = "secondpixel" + num2str(successfulfiles[0])
	Wave sec_pixelfit = root:ITIRFCCS:$sec_pix_fit_str
	for ( 	m =0; m <(floor(numberofrows[successfulfiles[0]]/bin) * floor(numberofcolumns[successfulfiles[0]]/bin)); m= m+1)
		//fitted_name = "fit_" + basename + "_" + num2str(successfulfiles[i]) + "_" + num2str(fir_pixelfit[m]) + "_" +num2str(sec_pixelfit[m])
		wave_fit_name =basename + "_" + num2str(successfulfiles[0]) + "_" + num2str(fir_pixelfit[m]) + "_" +num2str(sec_pixelfit[m])
		//make/N = (channel1 + (channel2-1)*8)/O $fittedname
		//wave w1_fit = $fitted_name
		Wave w1 = root:ITIRFCCS:$wave_fit_name
		if(display_counter==0)
			Display/N =newstring $wave_fit_name vs lagtime
			display_counter = display_counter+1
		else
			AppendTograph $wave_fit_name vs lagtime
			//display_counter = display_counter + 1
		endif
	endfor
	ModifyGraph log(bottom)=1
	ModifyGraph width=216,height={Aspect,0.7}
	Label left "\\Z16G(\\F'Symbol't\\F'Arial')"
	Label bottom "\\Z16\\F'Symbol't\\F'Arial' [s]"
	ModifyGraph tick=2,mirror=2
	ModifyGraph rgb=(47872,47872,47872)
	SetAxis/A=2 left
	ModifyGraph fSize=18
	String wave_fit_name2
	if(fit_check>0)
		Wave diff_co_0= root:ITIRFCCS:diff_co_0
		variable i, j
		m=0
		for ( 	i=0; i <floor(numberofrows[0]/bin); i= i+1)

			for ( 	j=0; j <floor(numberofcolumns[0]/bin); j= j+1)
				print i, j
				//fitted_name = "fit_" + basename + "_" + num2str(successfulfiles[i]) + "_" + num2str(fir_pixelfit[m]) + "_" +num2str(sec_pixelfit[m])
	
				
				wave_fit_name2 = basename + "_0_" + num2str(fir_pixelfit[m]) + "_" +num2str(sec_pixelfit[m])
				Wave w3 = root:ITIRFCCS:$wave_fit_name2
				if (numtype(diff_co_0[i][j])==2)
					//print "true"
					RemoveFromGraph $wave_fit_name2
				else
		
					wave_fit_name ="Fit_"+ basename + "_0_" + num2str(fir_pixelfit[m]) + "_" +num2str(sec_pixelfit[m])
					Wave w1 = root:ITIRFCCS:$wave_fit_name 
				
					//make/N = (channel1 + (channel2-1)*8)/O $fittedname
					//wave w1_fit = $fitted_name
					wave_fit_name1 ="FitX_"+ basename + "_0_" + num2str(fir_pixelfit[m]) + "_" +num2str(sec_pixelfit[m])
				
		
					Wave w2 = root:ITIRFCCS:$wave_fit_name1
					AppendTograph $wave_fit_name vs $wave_fit_name1
				
				endif
				m=m+1
			endfor
		endfor

	endif
end


Function MyCheckProc_new1(name,value)

	String name
	Variable value
	
	///CheckBox bleachexpo title="Expo", pos={215, 70}, size={14,14}, mode=1, value=bleachexpov, proc=MyCheckProc_new1
	//CheckBox bleachwindow title="Slide", pos={215,100}, size={14,14}, mode=1,  value=bleachwindowv, proc=MyCheckProc_new1
	//SetVariable bleachvalue, title="time", fsize=10, font="Arial", pos={215,130},size={65,25},frame=1, limits={0,65536,1},value = time_slide
	
	NVAR bleachexpov= root:ITIRFCCS:bleachexpov
	NVAR bleachwindowv = root:ITIRFCCS:bleachwindowv
	NVAR time_slide = root:ITiRFCCS:time_slide

	strswitch (name)

		case "bleachexpo":

			bleachexpov= 1
			bleachwindowv= 0
			CheckBox bleachexpo,value= 1
			CheckBox bleachwindow,value= 0
			SetVariable bleachvalue disable = 1
	
			//CheckBox BGRConstant,value= 1
			//CheckBox BGRFile,value= 0
			//Print "The background was updated to ", Background
			break

		case "bleachwindow":
			bleachexpov= 0
			bleachwindowv= 1
			//minimum_for_program = Background 
			//print minimum_for_program
			//print TimeLag
			//CheckBox bleachexpo,value= bleachwindowv==2
			//CheckBox bleachwindow,value= bleachwindowv==1
			SetVariable bleachvalue disable = 0
			CheckBox bleachexpo,value= 0
			CheckBox bleachwindow,value= 1
			break
	endswitch
	//CheckBox BGRConstant,value= 1
	//TitleBox tb1,title=outputpath1,disable = 0,pos={323,70},size={260,30}
End


Function sliding_window()
	NVAR time_slide = root:ITIRFCCS:time_slide
	NVAR timelag = root:ITIRFCCS:Timelag
	NVAR firstframe= root:ITIRFCCS:firstframe
	NVAR lastframe = root:ITIRFCCS:lastframe
	Variable slide_length = floor(time_slide/timelag)
	Variable numberofloops = floor((lastframe-firstframe)/slide_length)
	Variable ii
	NVAR logarithmiccorrelation = root:ITIRFCCS:logarithmiccorrelation
	NVAR linearpoints = root:ITIRFCCS:linearpoints
	NVAR bin =root:ITIRFCCS:bin
	wave numberofrows = root:ITIRFCCS:numberofrows
	wave numberofcolumns = root:ITIRFCCS:numberofcolumns
	Wave lagtime = root:ITIRFCCS:lagtime
	Wave lagtime_check = root:ITIRFCCS:lagtime_check
	NVAR channel1 = root:ITIRFCCS:channel1
	NVAR channel2= root:ITIRFCCS:channel2
	if(slide_length >256) 
		channel2=5
	endif
	if(slide_length > 512) 
		channel2=6
	endif
	if(slide_length > 1024) 
		channel2=7
	endif
	if(slide_length > 2048) 
		channel2=8
	endif
	Wave successfulfiles = root:ITIRFCCS:successfulfiles
	wavestats successfulfiles
	Variable numboffiles, i,j
	numboffiles = V_npnts
	wave/T Folderfilelist = root:ITIRFCCS:Folderfilelist
	wave/T output_corr = root:ITIRFCCS:output_corr
	wave/T output_int = root:ITIRFCCS:output_int
	NVAR background_for_program = root:ITIRFCCS:background_for_program
	NVAR channel1 = root:ITIRFCCS:channel1
	NVAR channel2 = root:ITIRFCCS:channel2
	String corrname
	for ( i = 0; i<numboffiles; i = i+1)
		for (j= 0; j < numberofloops; j= j+1)
			//hh = (floor(numberofrows[successfulfiles[i]]/bin) * floor(numberofcolumns[successfulfiles[i]]/bin))
			//print hh, FirstFrame + j*lagtime_check[critical_files-1] + 1, FirstFrame + (j+1)*lagtime_check[critical_files-1] 
			Make/N = (floor(numberofrows[successfulfiles[i]]/bin) * floor(numberofcolumns[successfulfiles[i]]/bin))/O/D w1
			Make/N = (floor(numberofrows[successfulfiles[i]]/bin) * floor(numberofcolumns[successfulfiles[i]]/bin))/O/D w2
			variable l = 0,r,k
			for (r = 0; r<floor(numberofrows[successfulfiles[i]]/bin); r=r+1)
				for (k = 0; k<floor(numberofcolumns[successfulfiles[i]]/bin); k= k+1)
					w1[l] = r*bin*numberofcolumns[successfulfiles[i]] + bin*k
					w2[l] = w1[l]
					//print w1,w2
					l = l+ 1
				Endfor
			Endfor
			//print  FirstFrame + j*lagtime_check[channel1 + (channel2-1)*channel1/2-1] , FirstFrame + (j+1)*lagtime_check[channel1 + (channel2-1)*channel1/2-1] 
			///////changed here 
			print FirstFrame + j*slide_length, FirstFrame + (j+1)*slide_length
			tif_program(FolderFileList[successfulfiles[i]], output_corr[successfulfiles[i]], output_int[successfulfiles[i]], FirstFrame + j*slide_length, FirstFrame + (j+1)*slide_length , Background_for_program, Bin, channel1, channel2,w1,w2)
			GBLoadWave/Q/B/A=lll/T={2,2}/W=(floor(numberofrows[successfulfiles[i]]/bin) * floor(numberofcolumns[i]/bin))/U=(channel1 + (channel2-1)*channel1/2) output_corr[successfulfiles[i]]
			Deletefile output_int[successfulfiles[i]]
			DeleteFile output_corr[successfulfiles[i]]
			////////changed here
			//print FirstFrame + 2*j*lagtime_check[channel1 + (channel2-1)*channel1/2-1], FirstFrame +2*(j+1)*lagtime_check[channel1 + (channel2-1)*channel1/2-1]
			//			tif_program(FolderFileList[successfulfiles[i]], output_corr[successfulfiles[i]], output_int[successfulfiles[i]],FirstFrame + 2*j*lagtime_check[channel1 + (channel2-1)*channel1/2-1], FirstFrame +2* (j+1)*lagtime_check[channel1 + (channel2-1)*channel1/2-1] , Background_for_program, Bin, channel1, channel2,w1,w2)
			//			GBLoadWave/Q/B/A=lll/T={2,2}/W=(floor(numberofrows[successfulfiles[i]]/bin) * floor(numberofcolumns[i]/bin))/U=(channel1 + (channel2-1)*channel1/2) output_corr[successfulfiles[i]]
			//			print FirstFrame + j*10000, (j+1)*10000-1
			//			tif_program(FolderFileList[successfulfiles[i]], output_corr[successfulfiles[i]], output_int[successfulfiles[i]], FirstFrame +  j*10000, FirstFrame + (j+1)*10000-1 , Background_for_program, Bin, channel1, channel2,w1,w2)
			//			GBLoadWave/Q/B/A=lll/T={2,2}/W=(floor(numberofrows[successfulfiles[i]]/bin) * floor(numberofcolumns[i]/bin))/U=(channel1 + (channel2-1)*channel1/2) output_corr[successfulfiles[i]]
			//			
			//			
			print Background_for_program			
		endfor
	endfor
	variable somecounter = 0,m,ancounter = 0 
	String point_name, some_name
	Make/N =(channel1 + (channel2-1)*channel1/2)/O/D w21
	Make/N =((floor(numberofrows[successfulfiles[j]]/bin) * floor(numberofcolumns[j]/bin)), (channel1 + (channel2-1)*channel1/2))/O/D sum_av=0
	Make/N =((floor(numberofrows[successfulfiles[j]]/bin) * floor(numberofcolumns[j]/bin)), (channel1 + (channel2-1)*channel1/2))/O/D corr_sd=0
	for ( j = 0; j<numboffiles; j= j+1)
		variable pp
		Redimension/N=(channel1 + (channel2-1)*channel1/2) lagtime	
		for (m = 0; m< (floor(numberofrows[successfulfiles[j]]/bin) * floor(numberofcolumns[j]/bin)); m= m+1)
			String renamewave = "corr_0_" + num2str(m)+"_" + num2str(m)
			wave w22 = $renamewave
			Redimension/N=(channel1 + (channel2-1)*channel1/2) w22
			for (k = 0; k< (channel1 + (channel2-1)*channel1/2); k = k+1)
				for ( l = 0; l <numberofloops; l = l+1)
					some_name = "lll" +  num2str((floor(numberofrows[successfulfiles[j]]/bin) * floor(numberofcolumns[j]/bin))*l + m)
					wave w21 = $some_name
					sum_av[m][k]=sum_av[m][k] + w21[k] 
				endfor
				sum_av[m][k] = sum_av[m][k]/numberofloops
				w22[k]=sum_av[m][k]
			
			endfor
		endfor
	endfor
	//	print nooftimes_final
	for ( j = 0; j<numboffiles; j= j+1)
		for (m = 0; m< (floor(numberofrows[successfulfiles[j]]/bin) * floor(numberofcolumns[successfulfiles[j]]/bin)); m= m+1)
			for (k = 0; k< (channel1 + (channel2-1)*channel1/2); k = k+1)
				for ( l = 0; l <numberofloops; l = l+1)
					some_name = "lll" +  num2str((floor(numberofrows[successfulfiles[j]]/bin) * floor(numberofcolumns[successfulfiles[j]]/bin))*l + m)
					if(m==0)
						//print num2str((floor(numberofrows[successfulfiles[j]]/bin) * floor(numberofcolumns[successfulfiles[j]]/bin))*l + m)
					endif
					wave w21 = $some_name
					corr_sd[m][k]=corr_sd[m][k] + (w21[k] - sum_av[m][k])*  (w21[k] - sum_av[m][k])
				endfor
				corr_sd[m][k] = sqrt(corr_sd[m][k]/numberofloops)
				//if(corr_sd[m][k] == 0)
				//corr_sd[m][k] = 1
				//endif
			endfor
		endfor
	endfor
	String waveagain
	String waveagain_av
	for ( j = 0; j<numboffiles; j= j+1)
		for (m = 0; m< (floor(numberofrows[successfulfiles[j]]/bin) * floor(numberofcolumns[j]/bin)); m= m+1)
			waveagain = "SD_file_" + num2str(j) + "_pixel_" +num2str(m)
			waveagain_av = "av_file_" + num2str(j) + "_pixel_" + num2str(m)
			Make/N = (channel1 + (channel2-1)*channel1/2)/O $waveagain
			Make/N = (channel1 + (channel2-1)*channel1/2)/O $waveagain_av
			Wave w1 = $waveagain
			Wave w3 = $waveagain_av
			for (k = 0; k< channel1 + (channel2-1)*channel1/2; k = k+1)
				//point_name = "point" + "_" + num2str(j) + "_" + num2str(lagtime[k]) + "_pixel_" + num2str(m)
				//Make/N = (nooftimes_final)/O/D w2
				//wave w2 =  $point_name
				//wavestats/Q w2
				w3[k] = sum_av[m][k]
				w1[k] = corr_sd[m][k]
			endfor
		endfor
	endfor
	print "done"
End


Function Calibration1(ctrlName) : ButtonControl
	String ctrlName

	NewPanel /N=ProgressPanel /W=(285,711,739,793)
	ValDisplay valdisp0,pos={18,32},size={342,18}
	ValDisplay valdisp0,limits={0,6,0},barmisc={0,0}
	ValDisplay valdisp0,value= _NUM:0
	Button bStop,pos={375,32},size={50,20},title="Stop" 
	DoUpdate /W=ProgressPanel /E=1// mark this as our progress window
	Variable/G background_for_program 
	Variable V_FitQuitReason = 0
	Variable V_fitoptions = 4

	NVAR bin = root:ITIRFCCS:bin 
	NVAR firstframe = root:ITIRFCCS:firstframe
	NVAR lastframe = root:ITIRFCCS:lastframe
	NVAR channel1 = root:ITIRFCCS:channel1
	NVAR channel2 = root:ITIRFCCS:channel2
	NVAR Background = root:ITIRFCCS:Background
	NVAR logarithmiccorrelation = root:ITIRFCCS:logarithmiccorrelation
	SVAR basename = root:ITIRFCCS:basename

	Wave lagtime = root:ITIRFCCS:lagtime
	Wave numberofrows = root:ITIRFCCS:numberofrows
	Wave numberofcolumns = root:ITIRFCCS:numberofcolumns
	Wave minimum = root:ITIRFCCS:minimum

	Wave/T FolderFileList = root:ITIRFCCS:FolderFileList
	Wave/T output_corr= root:ITIRFCCS:output_corr
	Wave/T output_int = root:ITIRFCCS:output_int
	Wave/T output_minimum = root:ITIRFCCS:output_minimum
	Wave/T output_corr_dis = root:ITIRFCCS:output_corr_dis
	//Wave/T output_int_dis = root:ITIRFCCS:output_int_dis
	Wave/T output_sd = root:ITIRFCCS:output_sd
 
	Variable i,j,k,l = 0,m  

	if (Background > minimum[0])
		Background_for_program = minimum[0]
	else
		background_for_program = Background
	endif

	for (bin = 1; bin<6; bin= bin+1)

		//print bin

		Make/N = ((numberofrows[0]- bin+1) * (numberofcolumns[0]- bin+1))/O/D w1
		Make/N = ((numberofrows[0]- bin+1) * (numberofcolumns[0]- bin+1))/O/D w2
		Make/T/N =3/O corr_name
		corr_name[0] = "corr_" + num2str(bin) + "_"
		corr_name[1] = "firstpixel_" + num2str(bin) + "_"
		corr_name[2] = "secondpixel_" + num2str(bin) + "_"
		//print corr_name[0]
		l = 0
		//for (j = 0; j<floor(numberofrows[0]/ bin); j= j+1)
		//	for (k = 0; k<floor(numberofcolumns[0]/bin); k= k+1)
		//		w1[l] = j*bin*numberofcolumns[0] + bin*k
		//		w2[l] = w1[l]
		//		l = l+ 1
		//	Endfor
		//Endfor
		for (j = 0; j<numberofrows[0]- bin+1; j= j+1)
			for (k = 0; k<numberofcolumns[0]- bin+1; k= k+1)
				w1[l] = j*numberofcolumns[0] + k
				w2[l] = w1[l]
				l = l+ 1
			Endfor
		Endfor
		tif_program(FolderFileList[0], output_corr[0], output_int[0], FirstFrame, LastFrame, Background_for_program, Bin, channel1, channel2,w1,w2)
		GBLoadWave/Q/B/A=$corr_name[0]/T={2,2}/W=((numberofrows[0]- bin+1) * (numberofcolumns[0]- bin+1))/U=(channel1 + (channel2-1)*channel1/2) output_corr[0]
		Deletefile output_int[0]
		Deletefile output_corr[0]
		Duplicate/O w1, $corr_name[1]; KillWaves w1
		Duplicate/O w2, $corr_name[2]; KillWaves w2

	endfor



	//////////////curve fitting///////////////////
	NVAR D = root:ITIRFCCS:D
	NVAR lambda = root:ITIRFCCS:lambda
	NVAR lambda_exc = root:ITIRFCCS:lambda_exc
	NVAR sigma = root:ITIRFCCS:sigma 
	NVAR N = root:ITIRFCCS:N
	NVAR pixel = root:ITIRFCCS:pixel
	NVAR NA = root:ITIRFCCS:NA
	NVAR NA_exc = root:ITIRFCCS:NA_exc
	NVAR Bin = root:ITIRFCCS:Bin
	NVAR sigz = root:ITIRFCCS:sigz
	wave lagtime = root:ITIRFCCS:lagtime
	NVAR spim_fit = root:ITIRFCCS:spim_fit
	Make/O/D/N = 12 W_coef


	//for (bin = 1; bin<6; bin= bin+1)
	// 
	//

	String Diff_co, Number, sig, DC, chisq, fir_pix_fit_str, sec_pix_fit_str, wave_fit_name, reason1, vel_x, vel_y, sigz_name
	String Diff_co_1, Number_1, xaxis_str, yaxis_str, yaxis_dlaw_str
	//bin = 1
	variable sig_count = 0	
	make/n =2/O a_values
	make/n =2/O b_values
	variable V_a,V_b
	variable mm
	//for (sig_count =0; sig_count<1; sig_count = sig_count +1)	
	for (sig_count =0; sig_count<1; sig_count = sig_count +1)	
		xaxis_str = "xaxis_" + num2str(sig_count)
		yaxis_str = "yaxis_" + num2str(sig_count)
		yaxis_dlaw_str = "yaxis_dlaw_" + num2str(sig_count)
		for (bin =1; bin <6; bin = bin+1)
			ValDisplay valdisp0,value= _NUM:bin+1,win=ProgressPanel
			//endif
			DoUpdate /W=ProgressPanel
			variable display_counter = 0
	
			for ( 	m =0;  m <((numberofrows[0]- bin+1) * (numberofcolumns[0]- bin+1)); m= m+1)
				//fitted_name = "fit_" + basename + "_" + num2str(successfulfiles[i]) + "_" + num2str(fir_pixelfit[m]) + "_" +num2str(sec_pixelfit[m])
				wave_fit_name = "corr_" + num2str(bin) + "_" + num2str(m)	//make/N = (channel1 + (channel2-1)*8)/O $fittedname
				//wave w1_fit = $fitted_name
				Wave w1 = root:ITIRFCCS:$wave_fit_name
				if(display_counter==0)
					Display $wave_fit_name vs lagtime
					//ModifyGraph width=7000,height={Aspect,1}
					display_counter = display_counter+1
					//Dowindow
				else
					AppendTograph $wave_fit_name vs lagtime
					//display_counter = display_counter + 1
				endif
			endfor
			ModifyGraph log(bottom)=1
					
			Diff_co = "Diff_co_"+ num2str(bin) + "_" + num2str(sig_count)
			Diff_co_1 = "Diff_co_1D_"+ num2str(bin) + "_" + num2str(sig_count)
			Number  = "Number_ " + num2str(bin) + "_" + num2str(sig_count)
			Number_1  = "Number_ 1D_" + num2str(bin) + "_" + num2str(sig_count)
			sig = "sig_" + num2str(bin) + "_" + num2str(sig_count)
			chisq = "chisq_" + num2str(bin) + "_" + num2str(sig_count) 
			DC = "DC_" + num2str(bin) + "_" + num2str(sig_count)
			Make/N=((numberofrows[0]- bin+1) * (numberofcolumns[0]- bin+1))/O w_diff_co
			Make/N =((numberofrows[0]- bin+1) * (numberofcolumns[0]- bin+1))/O w_number
			Make/N = ((numberofrows[0]- bin+1) * (numberofcolumns[0]- bin+1))/O w_sig 
			Make/N = ((numberofrows[0]- bin+1) * (numberofcolumns[0]- bin+1))/O w_dc 
			Make/N = ((numberofrows[0]- bin+1) * (numberofcolumns[0]- bin+1))/O w_chisq 

			for ( m =0; m <((numberofrows[0]- bin+1) * (numberofcolumns[0]- bin+1)); m= m+1)

				if (Spim_fit==1)
					NVAR lambda_exc = root:ITIRFCCS:lambda_exc
					NVAR NA_exc = root:ITIRFCCS:NA_exc 
					NVAR sigz_hold1 = root:ITIRFCCS:sigz_hold1
					Make/O/D/N = 15 W_coef
					W_coef=  {0,0,0,0, Bin, D, lambda,  NA,  N,1,sigma,pixel, SIGZ, lambda_exc, NA_exc}
					FuncFit/N=1 /q/H="111110110011" + num2str(sigz_hold1) + "11"   ITIRFCCS_spim W_coef  w1[1,channel1 + (channel2-1)*channel1/2-1]/X=lagtime/D/R/A=0
				else
					W_coef=  {0,0,0,0, Bin/2, D, lambda, NA, N*bin*bin,1,sigma,pixel}
					wave_fit_name = "corr_" + num2str(bin) + "_" + num2str(m)
			
					Wave w1 = root:ITIRFCCS:$wave_fit_name			
					FuncFit/N=1/q/H="111110110011"  ITIRFCCS_fit W_coef  w1[1,channel1 + (channel2-1)*channel1/2-1]/X=lagtime/D
				endif
				if(V_FitQuitReason == 0)
	 
					w_diff_co[m] = W_coef[5] 
					w_sig[m] = w_coef[10]
					w_chisq[m] = V_chisq
					w_number[m] = w_coef[8]
					w_dc[m] = w_coef[9]
					
	
				else
	
					w_diff_co[m] = nan
					w_sig[m] = nan
					w_chisq[m] = nan
					w_number[m] = nan
					w_dc[m] = nan
				
				endif
				//((numberofrows[0]- bin+1) * (numberofcolumns[0]- bin+1))	

			endfor
			Redimension/N = (numberofcolumns[0]- bin+1,numberofrows[0]- bin+1) w_diff_co
			Redimension/N = (numberofcolumns[0]- bin+1,numberofrows[0]- bin+1) w_sig
			Redimension/N = (numberofcolumns[0]- bin+1,numberofrows[0]- bin+1) w_DC
			Redimension/N = (numberofcolumns[0]- bin+1,numberofrows[0]- bin+1) w_chisq
			Redimension/N = (numberofcolumns[0]- bin+1,numberofrows[0]- bin+1) w_number

			Duplicate/O w_diff_co, $Diff_co; 
			Duplicate/O w_diff_co, $Diff_co_1; 
			Redimension/N=((numberofcolumns[0]- bin+1)*(numberofrows[0]- bin+1)) $Diff_co_1
			KillWaves w_diff_co
			Duplicate/O w_sig,  $sig; KillWaves w_sig
			Duplicate/O w_dc,  $DC; KillWaves w_dc
			Duplicate/O w_chisq, $chisq; KillWaves w_chisq	
			Duplicate/O w_number, $Number; 
			Duplicate/O w_number, $Number_1; 
			Redimension/N=((numberofcolumns[0]- bin+1)*(numberofrows[0]- bin+1)) $Number_1
			KillWaves w_number
		endfor	 

		variable numberofpts = 0, temp_1, temp_2=0
		

		bin = 5

		for (i = 1; i<=bin; i = i+1)
			numberofpts = numberofpts + (numberofcolumns[0]- i+1)*(numberofrows[0]- i+1)
			print numberofpts
		endfor

		make/n=(numberofpts) xaxis
		make/n=(numberofpts) yaxis
		make/n=(numberofpts) yaxis_dlaw

		for (i = 1; i<=bin; i = i+1)

			if (i>1)
				temp_2 = temp_2 +  (numberofcolumns[0]- (i-1)+1)*(numberofrows[0]- (i-1)+1)
			endif

			Diff_co_1 = "Diff_co_1D_"+ num2str(i) + "_" + num2str(sig_count)
			wave wn = root:ITIRFCCS:$Diff_co_1
			for (j=0; j<(numberofcolumns[0]- i+1)*(numberofrows[0]- i+1); j=j+1)
				xaxis[temp_2 +j] = i*i*pixel*pixel
				yaxis[temp_2 +j] = wn[j]
				yaxis_dlaw[temp_2+j] = i*i*pixel*pixel/wn[j]
			endfor
		endfor 
		Duplicate/O xaxis,  $xaxis_str; KillWaves xaxis
		Duplicate/O yaxis,  $yaxis_str; KillWaves yaxis
		Duplicate/O  yaxis_dlaw,  $yaxis_dlaw_str; KillWaves  yaxis_dlaw
		Display  $yaxis_str vs  $xaxis_str
		ModifyGraph mode=3
		CurveFit/M=2/W=0 line, $yaxis_str/X=$xaxis_str/D
		a_values[sig_count] =w_coef[0]
		b_values[sig_count] =w_coef[1]
		//PRINT "HELLO", a_values[sig_count]
		Display $yaxis_dlaw_str vs $xaxis_str
		ModifyGraph mode=3
		CurveFit/M=2/W=0 line, $yaxis_dlaw_str/X=$xaxis_str/D
		if( sig_count ==1)
			print "the value of D is", (a_values[0] + a_values[1])/2
			print "the corresponding sigma is", 0.3 - b_values[0]*(0.5-0.3)/(b_values[1] - b_values[0]) 
		endif
	endfor 
	//print time()
	KillWindow ProgressPanel
end	  


Function simpletest(indefinite, useIgorDraw)
	Variable indefinite
	Variable useIgorDraw// True to use Igor's own draw method rather than native
	NewPanel /N=ProgressPanel /W=(285,111,739,193)
	ValDisplay valdisp0,pos={18,32},size={342,18}
	ValDisplay valdisp0,limits={0,100,0},barmisc={0,0}
	ValDisplay valdisp0,value= _NUM:0
	if( indefinite )
		ValDisplay valdisp0,mode= 4// candy stripe
	else
		ValDisplay valdisp0,mode= 3// bar with no fractional part
	endif
	if( useIgorDraw )
		ValDisplay valdisp0,highColor=(0,65535,0)
	endif
	Button bStop,pos={375,32},size={50,20},title="Stop"
	DoUpdate /W=ProgressPanel /E=1// mark this as our progress window
	Variable i,imax= indefinite ? 10000 : 100
	for(i=0;i<imax;i+=1)
		Variable t0= ticks
		do
		while( ticks < (t0+3) )
		if( indefinite )
			ValDisplay valdisp0,value= _NUM:1,win=ProgressPanel
		else
			ValDisplay valdisp0,value= _NUM:i+1,win=ProgressPanel
		endif
		DoUpdate /W=ProgressPanel
		if( V_Flag == 2 )// we only have one button and that means stop
			break

		endif
	endfor
	KillWindow ProgressPanel
End

Function Save_config(ctrlName) : ButtonControl
	String ctrlname
	SVAR path= root:ITIRFCCS:path
	//Make/O/T/N=(j) config
	String filename= ParseFilePath(1, path, ":", 1, 0) + "config.txt"
	//Wave/T config = root:ITIRFCCS:config
	//String filename =config[0]
	print filename
	Variable refNum
	String str

	NVAR timeLag = root:ITIRFCCS:timeLag
	NVAR bin = root:ITIRFCCS:bin
	NVAR firstframe = root:ITIRFCCS:firstframe
	NVAR lastframe = root:ITIRFCCS:lastframe
	NVAR channel1 = root:ITIRFCCS:channel1
	NVAR channel2 = root:ITIRFCCS:channel2
	NVAR Background = root:ITIRFCCS:Background
	Open   refNum as fileName
	fprintf refNUm, "%d\r\n", firstframe
	fprintf refNUm, "%d\r\n",  lastframe
	fprintf refNUm, "%3.8f\r\n", timelag
	fprintf refNUm, "%d\r\n", background
	fprintf refNUm, "%d\r\n", channel1
	fprintf refNUm, "%d\r\n", channel2

	Close refNum
	
	return 0
end


Function DemoOpen(pathName, fileName)
	String pathName // Name of symbolic path or "" for dialog.
	String fileName // File name, partial path, full path or "" for dialog.
	Variable refNum
	String str
	// Open file for read.
	Open/R/Z=2/P=$pathName refNum as fileName
	// Store results from Open in a safe place.
	Variable err = V_flag
	String fullPath = S_fileName
	if (err == -1)
		Print "DemoOpen canceled by user."
		return -1
	endif
	if (err != 0)
		DoAlert 0, "Error in DemoOpen"
		return err
	endif
	Printf "Reading from file \"%s\". First line is:\r", fullPath
	FReadLine refNum, str // Read first line into string variable
	Print str
	Close refNum
	return 0
End

Function fit_pixel(ctrlName) : ButtonControl
	String ctrlName
	NVAR pixel_d= root:ITIRFCCS:pixel_d
	NVAR fit_check = root:ITIRFCCS:fit_check
	NVAR itirfccs_mod = root:ITIRFCCS:itirfccs_mod
	if(fit_check>0)
		wave diff_co_0 = root:ITirFCCS:diff_co_0
		wave chisq_0 = root:ITIRFCCS:chisq_0
		wave number_0= root:ITIRFCCS:number_0
		wave dc_0 = root:ITIRFCCS:dc_0
		wave sig_0= root:ITiRFCCS:sig_0
		wave lagtime = root:ITIRFCCS:lagtime
		String new = "corr_0_" + num2str(pixel_d) + "_" + num2str(pixel_d)
		wave w1= root:ITIRFCCS:$new
		Display/N=tobekilled w1 vs lagtime
		ModifyGraph log(bottom)=1
		NVAR D = root:ITIRFCCS:D
		NVAR lambda = root:ITIRFCCS:lambda
		NVAR sigma = root:ITIRFCCS:sigma 
		NVAR channel1 = root:ITIRFCCS:channel1 
		NVAR channel2 = root:ITIRFCCS:channel2
		NVAR linearpoints = root:ITIRFCCS:linearpoints
		NVAR N = root:ITIRFCCS:N
		NVAR pixel = root:ITIRFCCS:pixel
		NVAR NA = root:ITIRFCCS:NA
		NVAR Bin = root:ITIRFCCS:Bin
		NVAR vx = root:ITIRFCCS:vx
		NVAR vy = root:ITIRFCCS:vy
		ControlInfo/W=ITIRFCCSMainControl_new fittingparameter
		variable fit_value  = V_Value
		Variable V_FitQuitReason = 0
	
		ControlInfo/W=ITIRFCCSMainControl_new fittingparameter_D
		variable D_fit_value = V_Value
	
		ControlInfo/W=ITIRFCCSMainControl_new fittingparameter_vx
		variable vx_fit_value = V_value
	
		ControlInfo/W=ITIRFCCSMainControl_new fittingparameter_vy
		variable vy_fit_value = V_value
	
		ControlInfo/W=ITIRFCCSMainControl_new fittingparameter_N
		variable N_fit_value = V_value

		NVAR fitrange_begin=root:ITIRFCCS:fitrange_begin
		print "hi", fitrange_begin
		NVAR fitrange_end=root:ITIRFCCS:fitrange_end
		Print "hello" , fitrange_end
		variable temp_new
		if (fitrange_end < fitrange_begin)
			temp_new = fitrange_begin
			fitrange_begin = fitrange_end
			fitrange_end = temp_new
		endif
		
		if(ITIRFCCS_mod==1)
			Make/O/D/N = 12 W_coef
			W_coef=  {0,0,vx,vy, Bin/2, D, lambda, NA, N,1,sigma,pixel}
			FuncFit/H="11" + num2str(vx_fit_value) + num2str(vy_fit_value) + "1" + num2str(D_fit_value) + "11" +num2str(N_fit_value)+"0" + num2str(fit_value) +"1"  ITIRFCCS_fit W_coef  w1[fitrange_begin,fitrange_end]/X=lagtime/D/R/A=0; 
		else
			NVAR sigz = root:ITIRFCCS:sigz
			NVAR lambda_exc = root:ITIRFCCS:lambda_exc
			NVAR NA_exc = root:ITIRFCCS:NA_exc 
			NVAR sigz_hold1 = root:ITIRFCCS:sigz_hold1
			Make/O/D/N = 15 W_coef
			W_coef=  {0,0,0,0, Bin, D, lambda,  NA,  N,1,sigma,pixel, SIGZ, lambda_exc, NA_exc}
			FuncFit/N=1 /q/H="11" + num2str(vx_fit_value) + num2str(vy_fit_value) + "1" + num2str(D_fit_value) + "1100" + num2str(fit_value) +"1"+ num2str(sigz_hold1) + "11"  ITIRFCCS_spim W_coef  w1[1,channel1 + (channel2-1)*channel1/2-1]/X=lagtime/D/R/A=0
		endif	
		Nvar j = root:ITIRFCCS:x_pos
		NVAR i= root:ITIRFCCS:y_pos
		diff_co_0[i][j]= w_coef[5]
		chisq_0[i][j]=V_chisq
		number_0[i][j]= w_coef[8]
		dc_0[i][j]=w_coef[9]
		sig_0[i][j]=  w_coef[10]
		Dowindow/K tobekilled

	endif
	
	
	doupdate
		


End


Function load_config(ctrlName) : ButtonControl
	String ctrlname
	SVAR path= root:ITIRFCCS:path
	//Make/O/T/N=(j) config
	String filename= ParseFilePath(1, path, ":", 1, 0) + "config.txt"
	//Wave/T config = root:ITIRFCCS:config
	//String filename =config[0]
	print filename
	Variable refNum
	String str

	NVAR timeLag = root:ITIRFCCS:timeLag
	NVAR bin = root:ITIRFCCS:bin
	NVAR firstframe = root:ITIRFCCS:firstframe
	NVAR lastframe = root:ITIRFCCS:lastframe
	NVAR channel1 = root:ITIRFCCS:channel1
	NVAR channel2 = root:ITIRFCCS:channel2
	NVAR Background = root:ITIRFCCS:Background
	Open/R   refNum as fileName
	//FReadLine refNum, str // Read first line into string variable/Print str
	Variable lineNumber, len
	make/n=6 tempwave
	String buffer
	lineNumber = 0
	do
		FReadLine refNum, buffer
		len = strlen(buffer)
		if (len == 0)
			break // No more lines to be read
		endif
		Printf "Line number %d: %d\r\n", lineNumber, str2num(buffer)+1
		tempwave[linenumber]= str2num(buffer)
		if (CmpStr(buffer[len-1],"\r") != 0) // Last line has no CR ?
			Printf "\r"
		endif
		lineNumber += 1
	while (1)
	Close refNum
	firstframe= tempwave[0]
	lastframe= tempwave[1]
	timelag= tempwave[2]
	background= tempwave[3]
	channel1= tempwave[4]
	channel2= tempwave[5]
	//print str
	return 0
end


Function p_choose(name,value)
	String name
	Variable value
	NVAR p1_mod = root:ITIRFCCS:p1_mod
	NVAR p2_mod = root:ITIRFCCS:p2_mod
	NVAR fittingparameter_D1 = root:ITIRFCCS:fittingparameter_D1
	NVAR q_hold =root:ITIRFCCS:q_Hold
	//	NVAR v_size = root:ITIRFCCS:v_size
	//	NVAR auto_bin= root:ITIRFCCS:auto_bin
	//	NVAR manual_bin= root:ITIRFCCS:manual_bin
	NVAR particle = root:ITIRFCCS:particle
	strswitch(name)
		case  "p1_model":
			//NVAR logarithmiccorrelation= root:ITIRFCCS: logarithmiccorrelation
			p1_mod = 1
			p2_mod =0
			CheckBox p1_model value = 1
			CheckBox p2_model, value = 0
			//			SetVariable startvalue, disable = 1
			//			SetVariable endvalue, disable = 1
			particle=1
			//			
			//			print "nnn"
			//			SetVariable sizeofbin, disable = 1
			SetVariable  D1  disable = 1
			SetVariable   q  disable = 1
			CheckBox fittingparameter_D1 title="Fix", pos={340, 325}, size={14,14}, mode=0, value=fittingparameter_D1, disable = 1
			CheckBox fittingparameter_q title="Fix", pos={340, 415}, size={14,14}, mode=0, value=q_hold, disable = 1
			break
		Case "p2_model":
			//NVAR logarithmiccorrelation= root:ITIRFCCS: logarithmiccorrelation
			p1_mod = 0
			p2_mod = 1
			CheckBox p1_model value = 0
			CheckBox p2_model, value =1
			SetVariable  D1, title = "F1  ", fsize = 12, font  = "Arial", pos = {140, 325}, size = {80,25}, frame = 1, limits = {0, 1, 1e-14},value = D1, disable = 0
			SetVariable   q, title = "q", fsize = 12, font  = "Arial", pos = {140, 415}, size = {80,25}, frame = 1, limits = {0,1, 0.01},value =q, disable = 0
			CheckBox fittingparameter_D1 title="Fix", pos={240, 325}, size={14,14}, mode=0, value=fittingparameter_D1, disable = 0
			CheckBox fittingparameter_q title="Fix", pos={240, 415}, size={14,14}, mode=0, value=q_hold, disable = 0
			particle=2
			break
	EndSwitch
end


//SetVariable  D1, title = "D2  ", fsize = 12, font  = "Arial", pos = {140, 325}, size = {80,25}, frame = 1, limits = {0, 1, 1e-14},value = D1, disable = 1
//SetVariable   q, title = "q", fsize = 12, font  = "Arial", pos = {140, 415}, size = {80,25}, frame = 1, limits = {0.1,10000, 0.01},value =q, disable = 1
	