#pragma rtGlobals=1		// Use modern global access method.
#pragma rtGlobals=1		// Use modern global access method.

Function/D ITIRFCCS_fit(W, tau) : fitfunc
Wave/D W; Variable/D tau


variable dx, dy,vx, vy, a,  lumbda, na, sigma, D, pixelsize
pixelsize = w[11]
dx=w[11]*w[0] //distance on x direction
	dy=w[11]*w[1] //distance on y direction
	vx=w[2] //velocity on x direction
	vy=w[3] //velocity on y direction
	a=w[11]*w[4] //size of binned area (2a*2a)
	D = w[5]
	lumbda=w[6] //wavelength
	na=w[7] //numerical aperture
	sigma=w[10]*lumbda/na
	variable gx, gy
	gx=TIRF_CCF(dx,vx,a,sigma,tau, D)
	gy=TIRF_CCF(dy,vy,a,sigma,tau, D)
	
	return (1/w[8]/64/(a^2)*gx*gy+w[9])   
END

Function/D TIRF_CCF(x, v, a,  sigma,tau, D)
	variable/D x, v, a, sigma,tau , D
	
	variable p1,p2, p3, p4, g1, g2, g3, g4
	p1=x-v*tau
	p2=2*a+x-v*tau 
	p3=2*a-x+v*tau
	p4=2*sqrt(D*tau + sigma * sigma)
	
	g1=p4*(-2*exp(-(p1/p4)^2)+exp(-(p2/p4)^2)+exp(-(p3/p4)^2))/sqrt(pi)
	g2=2*p1*erf(p1/p4,1e-6)
	g3=p2*erf(p2/p4,1e-6)
	g4=p3*erf(p3/p4,1e-6)
	
	return(g1-g2+g3+g4)
	
End